/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.Arrays;
import java.util.Locale;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.damage.DamageUtils;
import kernitus.plugin.OldCombatMechanics.utilities.damage.NewWeaponDamage;
import kernitus.plugin.OldCombatMechanics.utilities.damage.OCMEntityDamageByEntityEvent;
import kernitus.plugin.OldCombatMechanics.utilities.damage.WeaponDamages;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;

public class ModuleOldToolDamage
extends OCMModule {
    private static final String[] WEAPONS = new String[]{"sword", "axe", "pickaxe", "spade", "shovel", "hoe"};
    private boolean oldSharpness;

    public ModuleOldToolDamage(OCMMain plugin) {
        super(plugin, "old-tool-damage");
        this.reload();
    }

    @Override
    public void reload() {
        this.oldSharpness = this.module().getBoolean("old-sharpness", true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDamaged(OCMEntityDamageByEntityEvent event) {
        double expectedBaseDamage;
        Entity damager = event.getDamager();
        if (event.getCause() == EntityDamageEvent.DamageCause.THORNS) {
            return;
        }
        World world = damager.getWorld();
        if (!this.isEnabled(world)) {
            return;
        }
        ItemStack weapon = event.getWeapon();
        Material weaponMaterial = weapon.getType();
        this.debug("Weapon material: " + weaponMaterial);
        if (!this.isWeapon(weaponMaterial)) {
            return;
        }
        double oldBaseDamage = event.getBaseDamage();
        if (Math.abs(oldBaseDamage - (expectedBaseDamage = (double)NewWeaponDamage.getDamage(weaponMaterial))) > 1.0E-4) {
            this.debug("Expected " + expectedBaseDamage + " got " + oldBaseDamage + " ignoring weapon...");
            return;
        }
        double newWeaponBaseDamage = WeaponDamages.getDamage(weaponMaterial);
        if (newWeaponBaseDamage <= 0.0) {
            this.debug("Unknown tool type: " + weaponMaterial, (CommandSender)damager);
            return;
        }
        event.setBaseDamage(newWeaponBaseDamage);
        Messenger.debug("Old tool damage: " + oldBaseDamage + " New: " + newWeaponBaseDamage, new Object[0]);
        int sharpnessLevel = event.getSharpnessLevel();
        double newSharpnessDamage = this.oldSharpness ? DamageUtils.getOldSharpnessDamage(sharpnessLevel) : DamageUtils.getNewSharpnessDamage(sharpnessLevel);
        this.debug("Old sharpness damage: " + event.getSharpnessDamage() + " New: " + newSharpnessDamage, (CommandSender)damager);
        event.setSharpnessDamage(newSharpnessDamage);
    }

    private boolean isWeapon(Material material) {
        return Arrays.stream(WEAPONS).anyMatch(type -> this.isOfType(material, (String)type));
    }

    private boolean isOfType(Material mat, String type) {
        return mat.toString().endsWith("_" + type.toUpperCase(Locale.ROOT));
    }
}

