/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.packet.PacketHelper;
import kernitus.plugin.OldCombatMechanics.utilities.packet.mitm.PacketAdapter;
import kernitus.plugin.OldCombatMechanics.utilities.packet.mitm.PacketEvent;
import kernitus.plugin.OldCombatMechanics.utilities.packet.mitm.PacketManager;
import kernitus.plugin.OldCombatMechanics.utilities.packet.team.TeamPacket;
import kernitus.plugin.OldCombatMechanics.utilities.teams.CollisionRule;
import kernitus.plugin.OldCombatMechanics.utilities.teams.TeamAction;
import kernitus.plugin.OldCombatMechanics.utilities.teams.TeamUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;

public class ModulePlayerCollisions
extends OCMModule {
    private final CollisionPacketListener collisionPacketListener = new CollisionPacketListener();
    private final Map<Player, TeamPacket> playerTeamMap = new WeakHashMap<Player, TeamPacket>();

    public ModulePlayerCollisions(OCMMain plugin) {
        super(plugin, "disable-player-collisions");
        OCMMain.getInstance().addDisableListener(() -> {
            Map<Player, TeamPacket> map = this.playerTeamMap;
            synchronized (map) {
                for (Map.Entry<Player, TeamPacket> entry : this.playerTeamMap.entrySet()) {
                    if (!TeamUtils.isOcmTeam(entry.getValue())) continue;
                    TeamUtils.disband(entry.getValue().getName(), entry.getKey());
                }
            }
        });
        OCMMain.getInstance().addEnableListener(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                PacketManager.getInstance().addListener(this.collisionPacketListener, player);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLogin(PlayerJoinEvent e) {
        PacketManager.getInstance().addListener(this.collisionPacketListener, e.getPlayer());
        this.createOrUpdateTeam(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChangeWorld(PlayerChangedWorldEvent e) {
        this.createOrUpdateTeam(e.getPlayer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrUpdateTeam(Player player) {
        CollisionRule collisionRule = this.isEnabled(player.getWorld()) ? CollisionRule.NEVER : CollisionRule.ALWAYS;
        Map<Player, TeamPacket> map = this.playerTeamMap;
        synchronized (map) {
            if (this.playerTeamMap.containsKey(player)) {
                TeamPacket teamPacket = this.playerTeamMap.get(player);
                teamPacket = teamPacket.withAction(TeamAction.UPDATE);
                teamPacket = teamPacket.withCollisionRule(collisionRule);
                this.playerTeamMap.put(player, teamPacket);
                teamPacket.send(player);
            } else {
                this.debug("Fake collision team created for you.", (CommandSender)player);
                this.createAndSendNewTeam(player, collisionRule);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndSendNewTeam(Player player, CollisionRule collisionRule) {
        Map<Player, TeamPacket> map = this.playerTeamMap;
        synchronized (map) {
            TeamPacket newTeamPacket = TeamUtils.craftTeamCreatePacket(player, collisionRule);
            this.playerTeamMap.put(player, newTeamPacket);
            newTeamPacket.send(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        Map<Player, TeamPacket> map = this.playerTeamMap;
        synchronized (map) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.createOrUpdateTeam(player);
            }
        }
    }

    private class CollisionPacketListener
    extends PacketAdapter {
        private final Class<?> targetClass = PacketHelper.getPacketClass(PacketHelper.PacketType.PlayOut, "ScoreboardTeam");

        private CollisionPacketListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPacketSend(PacketEvent packetEvent) {
            if (packetEvent.getPacket().getPacketClass() != this.targetClass) {
                return;
            }
            Map map = ModulePlayerCollisions.this.playerTeamMap;
            synchronized (map) {
                this.handlePacket(packetEvent);
            }
        }

        private void handlePacket(PacketEvent packetEvent) {
            CollisionRule collisionRule;
            Object nmsPacket = packetEvent.getPacket().getNmsPacket();
            TeamPacket incomingTeamPacket = TeamPacket.from(nmsPacket);
            CollisionRule collisionRule2 = collisionRule = ModulePlayerCollisions.this.isEnabled(packetEvent.getPlayer().getWorld()) ? CollisionRule.NEVER : CollisionRule.ALWAYS;
            if (this.interestingForPlayer(incomingTeamPacket, packetEvent.getPlayer())) {
                this.updateToPacket(packetEvent.getPlayer(), incomingTeamPacket);
            }
            if (!ModulePlayerCollisions.this.isEnabled(packetEvent.getPlayer().getWorld())) {
                return;
            }
            Messenger.debug("[%s-%s] Collision rule set to %s for action %s in world %s.", new Object[]{incomingTeamPacket.getName(), Optional.ofNullable(ModulePlayerCollisions.this.playerTeamMap.get(packetEvent.getPlayer())).map(TeamPacket::getName), collisionRule, incomingTeamPacket.getAction(), packetEvent.getPlayer().getWorld().getName()});
            incomingTeamPacket = incomingTeamPacket.withCollisionRule(collisionRule);
            packetEvent.setPacket(PacketHelper.wrap(incomingTeamPacket.getNmsPacket()));
            if (!ModulePlayerCollisions.this.playerTeamMap.containsKey(packetEvent.getPlayer())) {
                ModulePlayerCollisions.this.createAndSendNewTeam(packetEvent.getPlayer(), collisionRule);
            }
        }

        private boolean interestingForPlayer(TeamPacket packet, Player player) {
            if (TeamUtils.targetsPlayer(packet, player)) {
                return true;
            }
            TeamPacket storedTeam = (TeamPacket)ModulePlayerCollisions.this.playerTeamMap.get(player);
            return storedTeam != null && storedTeam.getName().equals(packet.getName());
        }

        private void updateToPacket(Player player, TeamPacket incomingPacket) {
            Optional<TeamPacket> newPacket;
            boolean currentIsOcmTeam;
            Optional<Object> current = Optional.ofNullable(ModulePlayerCollisions.this.playerTeamMap.get(player));
            if (incomingPacket.getAction() == TeamAction.DISBAND && TeamUtils.isOcmTeam(incomingPacket)) {
                return;
            }
            boolean bl = currentIsOcmTeam = current.isPresent() && TeamUtils.isOcmTeam((TeamPacket)current.get());
            if (incomingPacket.getAction() == TeamAction.DISBAND && currentIsOcmTeam) {
                return;
            }
            if (!current.isPresent() || !incomingPacket.getName().equals(((TeamPacket)current.get()).getName())) {
                if (currentIsOcmTeam) {
                    TeamUtils.disband(((TeamPacket)current.get()).getName(), player);
                }
                current = Optional.of(incomingPacket);
            }
            if ((newPacket = ((TeamPacket)current.get()).adjustedTo(incomingPacket, player)).isPresent()) {
                ModulePlayerCollisions.this.playerTeamMap.put(player, newPacket.get());
            } else {
                ModulePlayerCollisions.this.playerTeamMap.remove(player);
                ModulePlayerCollisions.this.debug("Your team was disbanded.", (CommandSender)player);
            }
        }
    }
}

