/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ModuleShieldDamageReduction
extends OCMModule {
    private int genericDamageReductionAmount;
    private int genericDamageReductionPercentage;
    private int projectileDamageReductionAmount;
    private int projectileDamageReductionPercentage;
    private final Map<UUID, List<ItemStack>> fullyBlocked = new WeakHashMap<UUID, List<ItemStack>>();

    public ModuleShieldDamageReduction(OCMMain plugin) {
        super(plugin, "shield-damage-reduction");
        this.reload();
    }

    @Override
    public void reload() {
        this.genericDamageReductionAmount = this.module().getInt("generalDamageReductionAmount", 1);
        this.genericDamageReductionPercentage = this.module().getInt("generalDamageReductionPercentage", 50);
        this.projectileDamageReductionAmount = this.module().getInt("projectileDamageReductionAmount", 1);
        this.projectileDamageReductionPercentage = this.module().getInt("projectileDamageReductionPercentage", 50);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemDamage(PlayerItemDamageEvent e) {
        Player player = e.getPlayer();
        if (!this.isEnabled(player.getWorld())) {
            return;
        }
        UUID uuid = player.getUniqueId();
        ItemStack item = e.getItem();
        if (this.fullyBlocked.containsKey(uuid)) {
            List<ItemStack> armour = this.fullyBlocked.get(uuid);
            List matchedPieces = armour.stream().filter(piece -> piece.equals((Object)item)).collect(Collectors.toList());
            armour.removeAll(matchedPieces);
            this.debug("Ignoring armour durability damage due to full block", (CommandSender)player);
            if (!matchedPieces.isEmpty()) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onHit(EntityDamageByEntityEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        final Player player = (Player)entity;
        if (!this.isEnabled(player.getWorld())) {
            return;
        }
        double currentDamage = e.getDamage(EntityDamageEvent.DamageModifier.BASE) + e.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT);
        if (!this.shieldBlockedDamage(currentDamage, e.getDamage(EntityDamageEvent.DamageModifier.BLOCKING))) {
            return;
        }
        double damageReduction = this.getDamageReduction(currentDamage, e.getCause());
        e.setDamage(EntityDamageEvent.DamageModifier.BLOCKING, -damageReduction);
        this.debug("Damage reduced by: " + damageReduction + " to " + (currentDamage -= damageReduction) + " before armour, resistance, absorption", (CommandSender)player);
        final UUID uuid = player.getUniqueId();
        if (currentDamage <= 0.0) {
            List armour = Arrays.stream(player.getInventory().getArmorContents()).filter(Objects::nonNull).collect(Collectors.toList());
            this.fullyBlocked.put(uuid, armour);
            new BukkitRunnable(){

                public void run() {
                    ModuleShieldDamageReduction.this.fullyBlocked.remove(uuid);
                    ModuleShieldDamageReduction.this.debug("Removed from fully blocked set!", (CommandSender)player);
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        }
    }

    private double getDamageReduction(double damage, EntityDamageEvent.DamageCause damageCause) {
        damage -= damageCause == EntityDamageEvent.DamageCause.PROJECTILE ? (double)this.projectileDamageReductionAmount : (double)this.genericDamageReductionAmount;
        if ((damage *= (double)(damageCause == EntityDamageEvent.DamageCause.PROJECTILE ? this.projectileDamageReductionPercentage : this.genericDamageReductionPercentage) / 100.0) < 0.0) {
            damage = 0.0;
        }
        return damage;
    }

    private boolean shieldBlockedDamage(double attackDamage, double blockingReduction) {
        return attackDamage > 0.0 && blockingReduction < 0.0;
    }
}

