/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.ConfigUtils;
import kernitus.plugin.OldCombatMechanics.utilities.RunnableSeries;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ModuleSwordBlocking
extends OCMModule {
    private static final ItemStack SHIELD = new ItemStack(Material.SHIELD);
    private final Map<UUID, ItemStack> storedOffhandItems = new HashMap<UUID, ItemStack>();
    private final Map<UUID, RunnableSeries> correspondingTasks = new HashMap<UUID, RunnableSeries>();
    private int restoreDelay;
    private boolean blacklist;
    private List<Material> noBlockingItems = new ArrayList<Material>();

    public ModuleSwordBlocking(OCMMain plugin) {
        super(plugin, "sword-blocking");
    }

    @Override
    public void reload() {
        this.restoreDelay = this.module().getInt("restoreDelay", 40);
        this.blacklist = this.module().getBoolean("blacklist");
        this.noBlockingItems = ConfigUtils.loadMaterialList(this.module(), "noBlockingItems");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRightClick(PlayerInteractEvent e) {
        Action action = e.getAction();
        if (action != Action.RIGHT_CLICK_BLOCK && action != Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (action == Action.RIGHT_CLICK_BLOCK && e.getHand() == EquipmentSlot.HAND) {
            return;
        }
        Player player = e.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemStack mainHandItem = inventory.getItemInMainHand();
        ItemStack offHandItem = inventory.getItemInOffHand();
        boolean isHoldingSword = this.isHoldingSword(mainHandItem.getType()) || this.isHoldingSword(offHandItem.getType());
        World world = player.getWorld();
        if (!this.isEnabled(world)) {
            return;
        }
        if (this.module().getBoolean("use-permission") && !player.hasPermission("oldcombatmechanics.swordblock")) {
            return;
        }
        UUID id = player.getUniqueId();
        if (!this.isPlayerBlocking(player)) {
            if (!isHoldingSword || this.hasShield(player)) {
                return;
            }
            boolean isNoBlockingItem = this.noBlockingItems.contains(inventory.getItemInOffHand().getType());
            if (this.blacklist && isNoBlockingItem || !this.blacklist && !isNoBlockingItem) {
                return;
            }
            this.storedOffhandItems.put(id, inventory.getItemInOffHand());
            inventory.setItemInOffHand(SHIELD);
        }
        this.scheduleRestore(player);
    }

    @EventHandler
    public void onHotBarChange(PlayerItemHeldEvent e) {
        this.restore(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onWorldChange(PlayerChangedWorldEvent e) {
        this.restore(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerLogout(PlayerQuitEvent e) {
        this.restore(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(PlayerDeathEvent e) {
        Player p = e.getEntity();
        UUID id = p.getUniqueId();
        if (!this.areItemsStored(id)) {
            return;
        }
        e.getDrops().replaceAll(item -> {
            if (item.getType().equals((Object)Material.SHIELD)) {
                item = this.storedOffhandItems.remove(id);
            }
            return item;
        });
        this.restore(p);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent e) {
        Player p = e.getPlayer();
        if (this.areItemsStored(p.getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent e) {
        Player p;
        if (e.getWhoClicked() instanceof Player && this.areItemsStored((p = (Player)e.getWhoClicked()).getUniqueId())) {
            ItemStack cursor = e.getCursor();
            ItemStack current = e.getCurrentItem();
            if (cursor != null && cursor.getType() == Material.SHIELD || current != null && current.getType() == Material.SHIELD) {
                e.setCancelled(true);
                this.restore(p);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onItemDrop(PlayerDropItemEvent e) {
        Item is = e.getItemDrop();
        Player p = e.getPlayer();
        if (this.areItemsStored(p.getUniqueId()) && is.getItemStack().getType() == Material.SHIELD) {
            e.setCancelled(true);
            this.restore(p);
        }
    }

    private void restore(Player p) {
        UUID id = p.getUniqueId();
        this.tryCancelTask(id);
        if (!this.areItemsStored(id)) {
            return;
        }
        if (this.isPlayerBlocking(p)) {
            this.scheduleRestore(p);
        } else {
            p.getInventory().setItemInOffHand(this.storedOffhandItems.get(id));
            this.storedOffhandItems.remove(id);
        }
    }

    private void tryCancelTask(UUID id) {
        Optional.ofNullable(this.correspondingTasks.remove(id)).ifPresent(RunnableSeries::cancelAll);
    }

    private void scheduleRestore(final Player p) {
        UUID id = p.getUniqueId();
        this.tryCancelTask(id);
        BukkitRunnable removeItem = new BukkitRunnable(){

            public void run() {
                ModuleSwordBlocking.this.restore(p);
            }
        };
        removeItem.runTaskLater((Plugin)this.plugin, (long)this.restoreDelay);
        BukkitRunnable checkBlocking = new BukkitRunnable(){

            public void run() {
                if (!ModuleSwordBlocking.this.isPlayerBlocking(p)) {
                    ModuleSwordBlocking.this.restore(p);
                }
            }
        };
        checkBlocking.runTaskTimer((Plugin)this.plugin, 10L, 2L);
        this.correspondingTasks.put(p.getUniqueId(), new RunnableSeries(removeItem, checkBlocking));
    }

    private boolean areItemsStored(UUID uuid) {
        return this.storedOffhandItems.containsKey(uuid);
    }

    private boolean isPlayerBlocking(Player player) {
        return player.isBlocking() || Reflector.versionIsNewerOrEqualAs(1, 11, 0) && player.isHandRaised() && player.getInventory().getItemInOffHand().getType() == Material.SHIELD;
    }

    private boolean hasShield(Player p) {
        return p.getInventory().getItemInOffHand().getType() == Material.SHIELD;
    }

    private boolean isHoldingSword(Material mat) {
        return mat.toString().endsWith("_SWORD");
    }
}

