/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import kernitus.plugin.OldCombatMechanics.ModuleLoader;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.damage.EntityDamageByEntityListener;
import kernitus.plugin.OldCombatMechanics.utilities.damage.WeaponDamages;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    private static final String CONFIG_NAME = "config.yml";
    private static OCMMain plugin;
    private static FileConfiguration config;

    public static void initialise(OCMMain plugin) {
        Config.plugin = plugin;
        config = plugin.getConfig();
        Config.reload();
    }

    private static boolean checkConfigVersion() {
        YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Objects.requireNonNull(plugin.getResource(CONFIG_NAME))));
        if (config.getInt("config-version") != defaultConfig.getInt("config-version")) {
            plugin.upgradeConfig();
            Config.reload();
            return true;
        }
        return false;
    }

    public static void reload() {
        if (plugin.doesConfigExist()) {
            plugin.reloadConfig();
            config = plugin.getConfig();
        } else {
            plugin.upgradeConfig();
        }
        if (Config.checkConfigVersion()) {
            return;
        }
        Messenger.DEBUG_ENABLED = config.getBoolean("debug.enabled");
        WeaponDamages.initialise(plugin);
        EntityDamageByEntityListener EDBEL = EntityDamageByEntityListener.getINSTANCE();
        if (EDBEL != null) {
            EDBEL.setEnabled(Config.moduleEnabled("old-tool-damage") || Config.moduleEnabled("old-potion-effects") || Config.moduleEnabled("old-critical-hits"));
        }
        ModuleLoader.toggleModules();
        ModuleLoader.getModules().forEach(module -> {
            try {
                module.reload();
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.WARNING, "Error reloading module '" + module.toString() + "'", e);
            }
        });
    }

    public static boolean moduleEnabled(String name, World world) {
        boolean isBlacklist = config.getBoolean("worlds-is-blacklist");
        ConfigurationSection section = config.getConfigurationSection(name);
        if (section == null) {
            plugin.getLogger().warning("Tried to check module '" + name + "', but it didn't exist!");
            return false;
        }
        if (!section.getBoolean("enabled")) {
            return false;
        }
        if (world == null) {
            return true;
        }
        String worldName = world.getName();
        List list = section.getStringList("worlds");
        if (list.size() == 0) {
            return true;
        }
        boolean isInList = list.stream().anyMatch(entry -> entry.equalsIgnoreCase(worldName));
        return isBlacklist != isInList;
    }

    public static boolean moduleEnabled(String name) {
        return Config.moduleEnabled(name, null);
    }

    public static boolean debugEnabled() {
        return Config.moduleEnabled("debug", null);
    }

    public static List<?> getWorlds(String moduleName) {
        return config.getList(moduleName + ".worlds");
    }

    public static boolean moduleSettingEnabled(String moduleName, String moduleSettingName) {
        return config.getBoolean(moduleName + "." + moduleSettingName);
    }

    public static void setModuleSetting(String moduleName, String moduleSettingName, boolean value) {
        config.set(moduleName + "." + moduleSettingName, (Object)value);
        plugin.saveConfig();
    }

    public static FileConfiguration getConfig() {
        return plugin.getConfig();
    }
}

