/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.packet.mitm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.packet.mitm.PacketInjector;
import kernitus.plugin.OldCombatMechanics.utilities.packet.mitm.PacketListener;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class PacketManager
implements Listener {
    private static PacketManager instance;
    private final Map<UUID, PacketInjector> injectorMap = new HashMap<UUID, PacketInjector>();

    private PacketManager(Plugin plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
        OCMMain.getInstance().addDisableListener(() -> {
            this.removeAll();
            instance = null;
        });
    }

    public static synchronized PacketManager getInstance() {
        if (instance == null) {
            instance = new PacketManager((Plugin)OCMMain.getInstance());
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PacketListener listener, Player player) {
        Objects.requireNonNull(listener, "listener can not be null");
        Objects.requireNonNull(player, "player can not be null");
        Map<UUID, PacketInjector> map = this.injectorMap;
        synchronized (map) {
            if (this.injectorMap.containsKey(player.getUniqueId())) {
                this.injectorMap.get(player.getUniqueId()).addPacketListener(listener);
            } else {
                try {
                    PacketInjector injector = new PacketInjector(player);
                    injector.addPacketListener(listener);
                    this.injectorMap.put(player.getUniqueId(), injector);
                }
                catch (Exception e) {
                    Messenger.debug("Error attaching packet listener!", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PacketListener listener, Player player) {
        Objects.requireNonNull(listener, "listener can not be null");
        Objects.requireNonNull(player, "player can not be null");
        Map<UUID, PacketInjector> map = this.injectorMap;
        synchronized (map) {
            if (!this.injectorMap.containsKey(player.getUniqueId())) {
                return;
            }
            PacketInjector injector = this.injectorMap.get(player.getUniqueId());
            injector.removePacketListener(listener);
            if (injector.getListenerAmount() < 1) {
                injector.detach();
                this.injectorMap.remove(player.getUniqueId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners(UUID uuid) {
        Objects.requireNonNull(uuid, "uuid can not be null");
        Map<UUID, PacketInjector> map = this.injectorMap;
        synchronized (map) {
            if (this.injectorMap.containsKey(uuid)) {
                this.injectorMap.get(uuid).detach();
                this.injectorMap.remove(uuid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAll() {
        Map<UUID, PacketInjector> map = this.injectorMap;
        synchronized (map) {
            HashSet<UUID> keys = new HashSet<UUID>(this.injectorMap.keySet());
            keys.forEach(this::removeAllListeners);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onLeave(PlayerQuitEvent event) {
        this.removeAllListeners(event.getPlayer().getUniqueId());
    }
}

