/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.packet.particle;

import java.util.Optional;
import kernitus.plugin.OldCombatMechanics.utilities.packet.ImmutablePacket;
import kernitus.plugin.OldCombatMechanics.utilities.packet.PacketHelper;
import kernitus.plugin.OldCombatMechanics.utilities.packet.particle.PreV13ParticlePacket;
import kernitus.plugin.OldCombatMechanics.utilities.packet.particle.V13ParticlePacket;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;

public abstract class ParticlePacket
implements ImmutablePacket {
    protected static final Class<?> PACKET_CLASS = PacketHelper.getPacketClass(PacketHelper.PacketType.PlayOut, "WorldParticles");
    private final Object nmsPacket;

    protected ParticlePacket(ImmutablePacket packet) {
        this.nmsPacket = packet.getNmsPacket();
    }

    @Override
    public Object getNmsPacket() {
        return this.nmsPacket;
    }

    public abstract String getParticleName();

    public static Optional<ParticlePacket> from(ImmutablePacket packet) {
        if (packet.getPacketClass() != PACKET_CLASS) {
            return Optional.empty();
        }
        if (Reflector.versionIsNewerOrEqualAs(1, 13, 0)) {
            return Optional.of(new V13ParticlePacket(packet));
        }
        return Optional.of(new PreV13ParticlePacket(packet));
    }
}

