/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.utilities.packet.team;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import kernitus.plugin.OldCombatMechanics.utilities.packet.PacketHelper;
import kernitus.plugin.OldCombatMechanics.utilities.packet.team.TeamPacket;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import kernitus.plugin.OldCombatMechanics.utilities.teams.CollisionRule;
import kernitus.plugin.OldCombatMechanics.utilities.teams.TeamAction;
import org.bukkit.entity.Player;

public class PreV17TeamPacket
extends TeamPacket {
    private static final PacketAccess PACKET_ACCESS = new PacketAccess();

    protected PreV17TeamPacket(Object nmsPacket) {
        super(nmsPacket);
    }

    @Override
    public TeamPacket withCollisionRule(CollisionRule collisionRule) {
        PACKET_ACCESS.setCollisionRule(this.getNmsPacket(), collisionRule);
        return this;
    }

    @Override
    public Collection<String> getPlayerNames() {
        return PACKET_ACCESS.getPlayerNames(this.getNmsPacket());
    }

    @Override
    public TeamPacket withAction(TeamAction action) {
        PACKET_ACCESS.setAction(this.getNmsPacket(), action);
        return this;
    }

    @Override
    public TeamAction getAction() {
        return PACKET_ACCESS.getAction(this.getNmsPacket());
    }

    @Override
    public String getName() {
        return PACKET_ACCESS.getName(this.getNmsPacket());
    }

    public static TeamPacket create(TeamAction action, CollisionRule collisionRule, String name, Collection<Player> players) {
        return new PreV17TeamPacket(PACKET_ACCESS.createTeamPacket(action, collisionRule, name, players));
    }

    private static class PacketAccess {
        private final Field fieldCollisionRule;
        private final Field fieldPlayerNames;
        private final Field fieldAction;
        private final Field fieldName;
        private final Constructor<?> constructorTeamPacket;

        private PacketAccess() {
            Class<?> packetClass = PacketHelper.getPacketClass(PacketHelper.PacketType.PlayOut, "ScoreboardTeam");
            this.fieldCollisionRule = Reflector.getInaccessibleField(packetClass, "f");
            this.fieldPlayerNames = Reflector.getInaccessibleField(packetClass, "h");
            this.fieldAction = Reflector.getInaccessibleField(packetClass, "i");
            this.fieldName = Reflector.getInaccessibleField(packetClass, "a");
            this.constructorTeamPacket = Reflector.getConstructor(packetClass, 0);
        }

        public void setCollisionRule(Object packet, CollisionRule rule) {
            Reflector.doUnchecked(() -> this.fieldCollisionRule.set(packet, rule.getName()));
        }

        public TeamAction getAction(Object packet) {
            return Reflector.getUnchecked(() -> TeamAction.fromId((Integer)this.fieldAction.get(packet)));
        }

        public void setAction(Object packet, TeamAction action) {
            Reflector.doUnchecked(() -> this.fieldAction.set(packet, action.getMinecraftId()));
        }

        public String getName(Object packet) {
            return Reflector.getUnchecked(() -> (String)this.fieldName.get(packet));
        }

        public Collection<String> getPlayerNames(Object packet) {
            Collection identifiers = Reflector.getUnchecked(() -> (Collection)this.fieldPlayerNames.get(packet));
            if (identifiers == null) {
                return Collections.emptyList();
            }
            return identifiers;
        }

        public Object createTeamPacket(TeamAction action, CollisionRule collisionRule, String name, Collection<Player> players) {
            Object packet = Reflector.getUnchecked(() -> this.constructorTeamPacket.newInstance(new Object[0]));
            this.setCollisionRule(packet, collisionRule);
            this.setAction(packet, action);
            Reflector.doUnchecked(() -> this.fieldPlayerNames.set(packet, players.stream().map(Player::getName).collect(Collectors.toList())));
            Reflector.doUnchecked(() -> this.fieldName.set(packet, name));
            return packet;
        }
    }
}

