/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.adventure.platform.facet;

import java.util.Set;
import java.util.function.Function;
import me.lucko.luckperms.lib.adventure.bossbar.BossBar;
import me.lucko.luckperms.lib.adventure.platform.facet.Facet;
import me.lucko.luckperms.lib.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

class FacetBossBarListener<V>
implements Facet.BossBar<V> {
    private final Facet.BossBar<V> facet;
    private final Function<Component, Component> translator;

    FacetBossBarListener(@NotNull Facet.BossBar<V> facet, @NotNull Function<Component, Component> translator) {
        this.facet = facet;
        this.translator = translator;
    }

    @Override
    public void bossBarInitialized(@NotNull BossBar bar) {
        this.facet.bossBarInitialized(bar);
        this.bossBarNameChanged(bar, bar.name(), bar.name());
    }

    public void bossBarNameChanged(@NotNull BossBar bar, @NotNull Component oldName, @NotNull Component newName) {
        this.facet.bossBarNameChanged(bar, oldName, this.translator.apply(newName));
    }

    public void bossBarProgressChanged(@NotNull BossBar bar, float oldPercent, float newPercent) {
        this.facet.bossBarProgressChanged(bar, oldPercent, newPercent);
    }

    public void bossBarColorChanged(@NotNull BossBar bar, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull BossBar.Color oldColor, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull BossBar.Color newColor) {
        this.facet.bossBarColorChanged(bar, oldColor, newColor);
    }

    public void bossBarOverlayChanged(@NotNull BossBar bar, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull BossBar.Overlay oldOverlay, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull BossBar.Overlay newOverlay) {
        this.facet.bossBarOverlayChanged(bar, oldOverlay, newOverlay);
    }

    public void bossBarFlagsChanged(@NotNull BossBar bar, @NotNull Set<BossBar.Flag> flagsAdded, @NotNull Set<BossBar.Flag> flagsRemoved) {
        this.facet.bossBarFlagsChanged(bar, flagsAdded, flagsRemoved);
    }

    @Override
    public void addViewer(@NotNull V viewer) {
        this.facet.addViewer(viewer);
    }

    @Override
    public void removeViewer(@NotNull V viewer) {
        this.facet.removeViewer(viewer);
    }

    @Override
    public boolean isEmpty() {
        return this.facet.isEmpty();
    }

    @Override
    public void close() {
        this.facet.close();
    }
}

