/*
 * Decompiled with CFR 0.152.
 */
package de.gerrygames.viarewind.protocol.protocol1_7_6_10to1_8.packets;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.minecraft.entities.Entity1_10Types;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.version.Types1_8;
import com.viaversion.viaversion.protocols.protocol1_8.ClientboundPackets1_8;
import de.gerrygames.viarewind.protocol.protocol1_7_6_10to1_8.ClientboundPackets1_7;
import de.gerrygames.viarewind.protocol.protocol1_7_6_10to1_8.Protocol1_7_6_10TO1_8;
import de.gerrygames.viarewind.protocol.protocol1_7_6_10to1_8.items.ItemRewriter;
import de.gerrygames.viarewind.protocol.protocol1_7_6_10to1_8.metadata.MetadataRewriter;
import de.gerrygames.viarewind.protocol.protocol1_7_6_10to1_8.storage.EntityTracker;
import de.gerrygames.viarewind.protocol.protocol1_7_6_10to1_8.storage.GameProfileStorage;
import de.gerrygames.viarewind.protocol.protocol1_7_6_10to1_8.types.Types1_7_6_10;
import de.gerrygames.viarewind.replacement.EntityReplacement;
import de.gerrygames.viarewind.utils.PacketUtil;
import java.util.List;
import java.util.UUID;

public class EntityPackets {
    public static void register(Protocol1_7_6_10TO1_8 protocol) {
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.ENTITY_EQUIPMENT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT, (Type)Type.INT);
                this.map((Type)Type.SHORT);
                this.map(Type.ITEM, Types1_7_6_10.COMPRESSED_NBT_ITEM);
                this.handler(packetWrapper -> {
                    Item item = (Item)packetWrapper.get(Types1_7_6_10.COMPRESSED_NBT_ITEM, 0);
                    ItemRewriter.toClient(item);
                    packetWrapper.set(Types1_7_6_10.COMPRESSED_NBT_ITEM, 0, (Object)item);
                });
                this.handler(packetWrapper -> {
                    short limit;
                    EntityTracker tracker = (EntityTracker)packetWrapper.user().get(EntityTracker.class);
                    int id = (Integer)packetWrapper.get((Type)Type.INT, 0);
                    short s = limit = tracker.getPlayerId() == id ? (short)3 : (short)4;
                    if ((Short)packetWrapper.get((Type)Type.SHORT, 0) > limit) {
                        packetWrapper.cancel();
                    }
                });
                this.handler(packetWrapper -> {
                    short slot = (Short)packetWrapper.get((Type)Type.SHORT, 0);
                    if (packetWrapper.isCancelled()) {
                        return;
                    }
                    EntityTracker tracker = (EntityTracker)packetWrapper.user().get(EntityTracker.class);
                    UUID uuid = tracker.getPlayerUUID((Integer)packetWrapper.get((Type)Type.INT, 0));
                    if (uuid == null) {
                        return;
                    }
                    Item item = (Item)packetWrapper.get(Types1_7_6_10.COMPRESSED_NBT_ITEM, 0);
                    tracker.setPlayerEquipment(uuid, item, slot);
                    GameProfileStorage storage = (GameProfileStorage)packetWrapper.user().get(GameProfileStorage.class);
                    GameProfileStorage.GameProfile profile = storage.get(uuid);
                    if (profile != null && profile.gamemode == 3) {
                        packetWrapper.cancel();
                    }
                });
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.USE_BED, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT, (Type)Type.INT);
                this.handler(packetWrapper -> {
                    Position position = (Position)packetWrapper.read(Type.POSITION);
                    packetWrapper.write((Type)Type.INT, (Object)position.x());
                    packetWrapper.write((Type)Type.UNSIGNED_BYTE, (Object)((short)position.y()));
                    packetWrapper.write((Type)Type.INT, (Object)position.z());
                });
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.COLLECT_ITEM, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT, (Type)Type.INT);
                this.map((Type)Type.VAR_INT, (Type)Type.INT);
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.ENTITY_VELOCITY, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT, (Type)Type.INT);
                this.map((Type)Type.SHORT);
                this.map((Type)Type.SHORT);
                this.map((Type)Type.SHORT);
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.DESTROY_ENTITIES, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.handler(packetWrapper -> {
                    int[] entityIds = (int[])packetWrapper.read(Type.VAR_INT_ARRAY_PRIMITIVE);
                    EntityTracker tracker = (EntityTracker)packetWrapper.user().get(EntityTracker.class);
                    for (int entityId : entityIds) {
                        tracker.removeEntity(entityId);
                    }
                    List parts = Lists.partition((List)Ints.asList((int[])entityIds), (int)127);
                    for (int i = 0; i < parts.size() - 1; ++i) {
                        PacketWrapper destroy = PacketWrapper.create((PacketType)ClientboundPackets1_7.DESTROY_ENTITIES, (UserConnection)packetWrapper.user());
                        destroy.write(Types1_7_6_10.INT_ARRAY, (Object)((List)parts.get(i)).stream().mapToInt(Integer::intValue).toArray());
                        PacketUtil.sendPacket(destroy, Protocol1_7_6_10TO1_8.class);
                    }
                    packetWrapper.write(Types1_7_6_10.INT_ARRAY, (Object)((List)parts.get(parts.size() - 1)).stream().mapToInt(Integer::intValue).toArray());
                });
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.ENTITY_MOVEMENT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT, (Type)Type.INT);
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.ENTITY_POSITION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT, (Type)Type.INT);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BOOLEAN, (Type)Type.NOTHING);
                this.handler(packetWrapper -> {
                    int entityId = (Integer)packetWrapper.get((Type)Type.INT, 0);
                    EntityTracker tracker = (EntityTracker)packetWrapper.user().get(EntityTracker.class);
                    EntityReplacement replacement = tracker.getEntityReplacement(entityId);
                    if (replacement != null) {
                        packetWrapper.cancel();
                        byte x = (Byte)packetWrapper.get((Type)Type.BYTE, 0);
                        byte y = (Byte)packetWrapper.get((Type)Type.BYTE, 1);
                        byte z = (Byte)packetWrapper.get((Type)Type.BYTE, 2);
                        replacement.relMove((double)x / 32.0, (double)y / 32.0, (double)z / 32.0);
                    }
                });
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.ENTITY_ROTATION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT, (Type)Type.INT);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BOOLEAN, (Type)Type.NOTHING);
                this.handler(packetWrapper -> {
                    int entityId = (Integer)packetWrapper.get((Type)Type.INT, 0);
                    EntityTracker tracker = (EntityTracker)packetWrapper.user().get(EntityTracker.class);
                    EntityReplacement replacement = tracker.getEntityReplacement(entityId);
                    if (replacement != null) {
                        packetWrapper.cancel();
                        byte yaw = (Byte)packetWrapper.get((Type)Type.BYTE, 0);
                        byte pitch = (Byte)packetWrapper.get((Type)Type.BYTE, 1);
                        replacement.setYawPitch((float)yaw * 360.0f / 256.0f, (float)pitch * 360.0f / 256.0f);
                    }
                });
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.ENTITY_POSITION_AND_ROTATION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT, (Type)Type.INT);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BOOLEAN, (Type)Type.NOTHING);
                this.handler(packetWrapper -> {
                    int entityId = (Integer)packetWrapper.get((Type)Type.INT, 0);
                    EntityTracker tracker = (EntityTracker)packetWrapper.user().get(EntityTracker.class);
                    EntityReplacement replacement = tracker.getEntityReplacement(entityId);
                    if (replacement != null) {
                        packetWrapper.cancel();
                        byte x = (Byte)packetWrapper.get((Type)Type.BYTE, 0);
                        byte y = (Byte)packetWrapper.get((Type)Type.BYTE, 1);
                        byte z = (Byte)packetWrapper.get((Type)Type.BYTE, 2);
                        byte yaw = (Byte)packetWrapper.get((Type)Type.BYTE, 3);
                        byte pitch = (Byte)packetWrapper.get((Type)Type.BYTE, 4);
                        replacement.relMove((double)x / 32.0, (double)y / 32.0, (double)z / 32.0);
                        replacement.setYawPitch((float)yaw * 360.0f / 256.0f, (float)pitch * 360.0f / 256.0f);
                    }
                });
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.ENTITY_TELEPORT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT, (Type)Type.INT);
                this.map((Type)Type.INT);
                this.map((Type)Type.INT);
                this.map((Type)Type.INT);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BOOLEAN, (Type)Type.NOTHING);
                this.handler(packetWrapper -> {
                    int entityId = (Integer)packetWrapper.get((Type)Type.INT, 0);
                    EntityTracker tracker = (EntityTracker)packetWrapper.user().get(EntityTracker.class);
                    Entity1_10Types.EntityType type = tracker.getClientEntityTypes().get(entityId);
                    if (type == Entity1_10Types.EntityType.MINECART_ABSTRACT) {
                        int y = (Integer)packetWrapper.get((Type)Type.INT, 2);
                        packetWrapper.set((Type)Type.INT, 2, (Object)(y += 12));
                    }
                });
                this.handler(packetWrapper -> {
                    int entityId = (Integer)packetWrapper.get((Type)Type.INT, 0);
                    EntityTracker tracker = (EntityTracker)packetWrapper.user().get(EntityTracker.class);
                    EntityReplacement replacement = tracker.getEntityReplacement(entityId);
                    if (replacement != null) {
                        packetWrapper.cancel();
                        int x = (Integer)packetWrapper.get((Type)Type.INT, 1);
                        int y = (Integer)packetWrapper.get((Type)Type.INT, 2);
                        int z = (Integer)packetWrapper.get((Type)Type.INT, 3);
                        byte yaw = (Byte)packetWrapper.get((Type)Type.BYTE, 0);
                        byte pitch = (Byte)packetWrapper.get((Type)Type.BYTE, 1);
                        replacement.setLocation((double)x / 32.0, (double)y / 32.0, (double)z / 32.0);
                        replacement.setYawPitch((float)yaw * 360.0f / 256.0f, (float)pitch * 360.0f / 256.0f);
                    }
                });
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.ENTITY_HEAD_LOOK, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT, (Type)Type.INT);
                this.map((Type)Type.BYTE);
                this.handler(packetWrapper -> {
                    int entityId = (Integer)packetWrapper.get((Type)Type.INT, 0);
                    EntityTracker tracker = (EntityTracker)packetWrapper.user().get(EntityTracker.class);
                    EntityReplacement replacement = tracker.getEntityReplacement(entityId);
                    if (replacement != null) {
                        packetWrapper.cancel();
                        byte yaw = (Byte)packetWrapper.get((Type)Type.BYTE, 0);
                        replacement.setHeadYaw((float)yaw * 360.0f / 256.0f);
                    }
                });
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.ATTACH_ENTITY, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.INT);
                this.map((Type)Type.INT);
                this.map((Type)Type.BOOLEAN);
                this.handler(packetWrapper -> {
                    boolean leash = (Boolean)packetWrapper.get((Type)Type.BOOLEAN, 0);
                    if (leash) {
                        return;
                    }
                    int passenger = (Integer)packetWrapper.get((Type)Type.INT, 0);
                    int vehicle = (Integer)packetWrapper.get((Type)Type.INT, 1);
                    EntityTracker tracker = (EntityTracker)packetWrapper.user().get(EntityTracker.class);
                    tracker.setPassenger(vehicle, passenger);
                });
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.ENTITY_METADATA, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT, (Type)Type.INT);
                this.map(Types1_8.METADATA_LIST, Types1_7_6_10.METADATA_LIST);
                this.handler(wrapper -> {
                    List metadataList = (List)wrapper.get(Types1_7_6_10.METADATA_LIST, 0);
                    int entityId = (Integer)wrapper.get((Type)Type.INT, 0);
                    EntityTracker tracker = (EntityTracker)wrapper.user().get(EntityTracker.class);
                    if (tracker.getClientEntityTypes().containsKey(entityId)) {
                        EntityReplacement replacement = tracker.getEntityReplacement(entityId);
                        if (replacement != null) {
                            wrapper.cancel();
                            replacement.updateMetadata(metadataList);
                        } else {
                            MetadataRewriter.transform(tracker.getClientEntityTypes().get(entityId), metadataList);
                            if (metadataList.isEmpty()) {
                                wrapper.cancel();
                            }
                        }
                    } else {
                        tracker.addMetadataToBuffer(entityId, metadataList);
                        wrapper.cancel();
                    }
                });
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.ENTITY_EFFECT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT, (Type)Type.INT);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.VAR_INT, (Type)Type.SHORT);
                this.map((Type)Type.BYTE, (Type)Type.NOTHING);
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.REMOVE_ENTITY_EFFECT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT, (Type)Type.INT);
                this.map((Type)Type.BYTE);
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.ENTITY_PROPERTIES, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT, (Type)Type.INT);
                this.handler(packetWrapper -> {
                    int entityId = (Integer)packetWrapper.get((Type)Type.INT, 0);
                    EntityTracker tracker = (EntityTracker)packetWrapper.user().get(EntityTracker.class);
                    if (tracker.getEntityReplacement(entityId) != null) {
                        packetWrapper.cancel();
                        return;
                    }
                    int amount = (Integer)packetWrapper.passthrough((Type)Type.INT);
                    for (int i = 0; i < amount; ++i) {
                        packetWrapper.passthrough(Type.STRING);
                        packetWrapper.passthrough((Type)Type.DOUBLE);
                        int modifierlength = (Integer)packetWrapper.read((Type)Type.VAR_INT);
                        packetWrapper.write((Type)Type.SHORT, (Object)((short)modifierlength));
                        for (int j = 0; j < modifierlength; ++j) {
                            packetWrapper.passthrough(Type.UUID);
                            packetWrapper.passthrough((Type)Type.DOUBLE);
                            packetWrapper.passthrough((Type)Type.BYTE);
                        }
                    }
                });
            }
        });
        protocol.cancelClientbound((ClientboundPacketType)ClientboundPackets1_8.UPDATE_ENTITY_NBT);
    }
}

