/*
 * Decompiled with CFR 0.152.
 */
package de.gerrygames.viarewind.protocol.protocol1_7_6_10to1_8.types;

import com.viaversion.viaversion.api.minecraft.Environment;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.type.PartialType;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.protocols.protocol1_9_3to1_9_1_2.storage.ClientWorld;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.util.zip.DeflaterOutputStream;

public class Chunk1_7_10Type
extends PartialType<Chunk, ClientWorld> {
    public Chunk1_7_10Type(ClientWorld param) {
        super((Object)param, Chunk.class);
    }

    public Chunk read(ByteBuf byteBuf, ClientWorld clientWorld) throws Exception {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ByteBuf output, ClientWorld clientWorld, Chunk chunk) throws Exception {
        output.writeInt(chunk.getX());
        output.writeInt(chunk.getZ());
        output.writeBoolean(chunk.isFullChunk());
        output.writeShort(chunk.getBitmask());
        output.writeShort(0);
        ByteBuf dataToCompress = output.alloc().buffer();
        try {
            boolean skyLight;
            int j;
            DataPalette palette;
            ChunkSection section;
            int i;
            for (i = 0; i < chunk.getSections().length; ++i) {
                if ((chunk.getBitmask() & 1 << i) == 0) continue;
                section = chunk.getSections()[i];
                palette = section.palette(PaletteType.BLOCKS);
                for (j = 0; j < 4096; ++j) {
                    int block = palette.idAt(j);
                    dataToCompress.writeByte(block >> 4);
                }
            }
            for (i = 0; i < chunk.getSections().length; ++i) {
                if ((chunk.getBitmask() & 1 << i) == 0) continue;
                section = chunk.getSections()[i];
                palette = section.palette(PaletteType.BLOCKS);
                for (j = 0; j < 4096; j += 2) {
                    int data0 = palette.idAt(j) & 0xF;
                    int data1 = palette.idAt(j + 1) & 0xF;
                    dataToCompress.writeByte(data1 << 4 | data0);
                }
            }
            for (i = 0; i < chunk.getSections().length; ++i) {
                if ((chunk.getBitmask() & 1 << i) == 0) continue;
                chunk.getSections()[i].getLight().writeBlockLight(dataToCompress);
            }
            boolean bl = skyLight = clientWorld != null && clientWorld.getEnvironment() == Environment.NORMAL;
            if (skyLight) {
                for (int i2 = 0; i2 < chunk.getSections().length; ++i2) {
                    if ((chunk.getBitmask() & 1 << i2) == 0) continue;
                    chunk.getSections()[i2].getLight().writeSkyLight(dataToCompress);
                }
            }
            if (chunk.isFullChunk() && chunk.isBiomeData()) {
                for (int biome : chunk.getBiomeData()) {
                    dataToCompress.writeByte(biome);
                }
            }
            ByteArrayOutputStream compressedStream = new ByteArrayOutputStream();
            try (DeflaterOutputStream compressorStream = new DeflaterOutputStream(compressedStream);){
                compressorStream.write((byte[])Type.REMAINING_BYTES.read(dataToCompress));
            }
            output.writeInt(compressedStream.size());
            output.writeBytes(compressedStream.toByteArray());
        }
        finally {
            dataToCompress.release();
        }
    }
}

