/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.pht64kd;

import ch.ethz.globis.pht64kd.MaxKTreeI;
import ch.ethz.globis.phtree.v11.nt.NodeTreeV11;

public class MaxKTree64<T>
implements MaxKTreeI {
    private final long[] dummy;
    private final NodeTreeV11<T> tree;

    private MaxKTree64() {
        this.tree = NodeTreeV11.create(64);
        this.dummy = new long[this.getKeyBitWidth()];
    }

    private MaxKTree64(int keyWidth) {
        this.tree = NodeTreeV11.create(keyWidth);
        this.dummy = new long[this.getKeyBitWidth()];
    }

    public static <T> MaxKTree64<T> create() {
        return new MaxKTree64<T>();
    }

    public static <T> MaxKTree64<T> create(int keyWidth) {
        return new MaxKTree64<T>(keyWidth);
    }

    public T put(long key, T value) {
        return this.tree.put(key, this.dummy, value);
    }

    public T putKD(long key, long[] kdKey, T value) {
        return this.tree.put(key, kdKey, value);
    }

    public boolean contains(long key) {
        return this.tree.contains(key, this.dummy);
    }

    public T get(long key) {
        return this.tree.get(key, this.dummy);
    }

    public T getKd(long key, long[] kdKeyOut) {
        return this.tree.get(key, kdKeyOut);
    }

    public T remove(long key) {
        return this.tree.remove(key);
    }

    public boolean delete(long key) {
        return this.tree.remove(key) != null;
    }

    public String toStringTree() {
        return this.tree.toStringTree();
    }

    public MaxKTreeI.PhIterator64<T> queryWithMask(long minMask, long maxMask) {
        return this.tree.queryWithMask(minMask, maxMask);
    }

    public MaxKTreeI.PhIterator64<T> query(long min, long max) {
        return this.tree.query(min, max);
    }

    public MaxKTreeI.PhIterator64<T> iterator() {
        return this.tree.iterator();
    }

    public boolean checkTree() {
        return this.tree.checkTree();
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    @Override
    public int getKeyBitWidth() {
        return this.tree.getKeyBitWidth();
    }

    @Override
    public Object getRoot() {
        return this.tree.getRoot();
    }
}

