/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree;

import ch.ethz.globis.phtree.PhDistance;
import ch.ethz.globis.phtree.pre.PreProcessorPointF;
import java.util.Arrays;

public class PhDistancePP
implements PhDistance {
    public static final PhDistance DOUBLE = new PhDistancePP(new PreProcessorPointF.IEEE());
    private final PreProcessorPointF pre;

    public PhDistancePP(PreProcessorPointF pre) {
        this.pre = pre;
    }

    @Override
    public double dist(long[] v1, long[] v2) {
        double d = 0.0;
        double[] d1 = new double[v1.length];
        double[] d2 = new double[v2.length];
        this.pre.post(v1, d1);
        this.pre.post(v2, d2);
        for (int i = 0; i < v1.length; ++i) {
            double dl = d1[i] - d2[i];
            d += dl * dl;
        }
        return Math.sqrt(d);
    }

    @Override
    public void toMBB(double distance, long[] center, long[] outMin, long[] outMax) {
        double[] c = new double[center.length];
        double[] min = new double[outMin.length];
        double[] max = new double[outMax.length];
        this.pre.post(center, c);
        for (int i = 0; i < center.length; ++i) {
            min[i] = c[i] - distance;
            max[i] = c[i] + distance;
        }
        this.pre.pre(min, outMin);
        this.pre.pre(max, outMax);
    }

    @Override
    public void knnCalcDistances(long[] kNNCenterIn, long[] prefixIn, int bitsToIgnore, double[] outDistances) {
        int i;
        long maskSingleBit = 1L << bitsToIgnore - 1;
        if (maskSingleBit < 0L) {
            return;
        }
        long maskPrefix = -1L << bitsToIgnore;
        long maskPostFix = (maskPrefix ^ 0xFFFFFFFFFFFFFFFFL) >> 1;
        for (i = 0; i < prefixIn.length; ++i) {
            long nodeCenter = prefixIn[i] & maskPrefix;
            boolean isLarger = kNNCenterIn[i] > (nodeCenter | maskPostFix);
            double dist = this.pre.post(nodeCenter |= isLarger ? maskPostFix : maskSingleBit) - this.pre.post(kNNCenterIn[i]);
            outDistances[i] = dist * dist;
        }
        Arrays.sort(outDistances);
        for (i = 1; i < outDistances.length; ++i) {
            int n = i;
            outDistances[n] = outDistances[n] + outDistances[i - 1];
        }
        for (i = 0; i < outDistances.length; ++i) {
            outDistances[i] = Math.sqrt(outDistances[i]);
        }
    }
}

