/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree;

import ch.ethz.globis.phtree.PhDistanceSF;
import ch.ethz.globis.phtree.pre.PreProcessorRangeF;
import java.util.Arrays;

public class PhDistanceSFEdgeDist
implements PhDistanceSF {
    private final PreProcessorRangeF pre;
    private final double[] qMIN;
    private final double[] qMAX;

    public PhDistanceSFEdgeDist(PreProcessorRangeF pre, int dims) {
        this.pre = pre;
        this.qMIN = new double[dims];
        Arrays.fill(this.qMIN, Double.NEGATIVE_INFINITY);
        this.qMAX = new double[dims];
        Arrays.fill(this.qMAX, Double.POSITIVE_INFINITY);
    }

    @Override
    public double dist(long[] v1, long[] v2) {
        double d = 0.0;
        double[] d1lo = new double[v1.length >> 1];
        double[] d1up = new double[v1.length >> 1];
        double[] d2lo = new double[v2.length >> 1];
        double[] d2up = new double[v2.length >> 1];
        this.pre.post(v1, d1lo, d1up);
        this.pre.post(v2, d2lo, d2up);
        for (int i = 0; i < d1lo.length; ++i) {
            double dOnAxis = 0.0;
            if (d1up[i] < d2lo[i]) {
                dOnAxis = d2lo[i] - d1up[i];
            } else if (d1lo[i] > d2up[i]) {
                dOnAxis = d1lo[i] - d2up[i];
            }
            d += dOnAxis * dOnAxis;
        }
        return Math.sqrt(d);
    }

    @Override
    public void toMBB(double distance, long[] center, long[] outMin, long[] outMax) {
        int dimsHalf = center.length >> 1;
        double[] cLo = new double[dimsHalf];
        double[] cUp = new double[dimsHalf];
        double[] min = new double[dimsHalf];
        double[] max = new double[dimsHalf];
        this.pre.post(center, cLo, cUp);
        for (int i = 0; i < dimsHalf; ++i) {
            min[i] = cLo[i] - distance;
            max[i] = cUp[i] + distance;
        }
        this.pre.pre(this.qMIN, min, outMin);
        this.pre.pre(max, this.qMAX, outMax);
    }

    @Override
    public void knnCalcDistances(long[] kNNCenter, long[] prefix, int bitsToIgnore, double[] outDistances) {
        int i;
        long maskSingleBit = 1L << bitsToIgnore - 1;
        if (maskSingleBit < 0L) {
            return;
        }
        long[] v2 = new long[prefix.length];
        long maskPrefix = -1L << bitsToIgnore;
        long maskPostFix = (maskPrefix ^ 0xFFFFFFFFFFFFFFFFL) >> 1;
        for (int i2 = 0; i2 < prefix.length; ++i2) {
            long nodeCenter = prefix[i2] & maskPrefix;
            boolean isLarger = kNNCenter[i2] > (nodeCenter | maskPostFix);
            v2[i2] = nodeCenter |= isLarger ? maskPostFix : maskSingleBit;
        }
        int dimsHalf = kNNCenter.length >> 1;
        double[] d1lo = new double[dimsHalf];
        double[] d1up = new double[dimsHalf];
        double[] d2lo = new double[dimsHalf];
        double[] d2up = new double[dimsHalf];
        this.pre.post(kNNCenter, d1lo, d1up);
        this.pre.post(v2, d2lo, d2up);
        for (i = 0; i < dimsHalf; ++i) {
            double dOnAxis = 0.0;
            if (d1up[i] < d2lo[i]) {
                dOnAxis = d2lo[i] - d1up[i];
            } else if (d1lo[i] > d2up[i]) {
                dOnAxis = d1lo[i] - d2up[i];
            }
            outDistances[i] = dOnAxis * dOnAxis;
        }
        Arrays.sort(outDistances, 0, dimsHalf);
        for (i = 1; i < dimsHalf; ++i) {
            int n = i;
            outDistances[n] = outDistances[n] + outDistances[i - 1];
        }
        for (i = 0; i < outDistances.length; ++i) {
            outDistances[i] = Math.sqrt(outDistances[i]);
        }
    }
}

