/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree;

import ch.ethz.globis.phtree.PhDistance;
import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhEntryDist;
import ch.ethz.globis.phtree.PhFilter;
import ch.ethz.globis.phtree.PhRangeQuery;
import ch.ethz.globis.phtree.PhTreeConfig;
import ch.ethz.globis.phtree.util.PhIteratorBase;
import ch.ethz.globis.phtree.util.PhMapper;
import ch.ethz.globis.phtree.util.PhTreeStats;
import ch.ethz.globis.phtree.v13.PhTree13;
import ch.ethz.globis.phtree.v16.PhTree16;
import ch.ethz.globis.phtree.v16hd.PhTree16HD;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface PhTree<T> {
    public int size();

    public PhTreeStats getStats();

    public T put(long[] var1, T var2);

    public boolean contains(long ... var1);

    public T get(long ... var1);

    public T remove(long ... var1);

    public String toStringPlain();

    public String toStringTree();

    public PhExtent<T> queryExtent();

    public PhQuery<T> query(long[] var1, long[] var2);

    default public PhQuery<T> query(long[] min, long[] max, PhFilter filter) {
        throw new UnsupportedOperationException("This is only supported in V13, V16 and V16HD.");
    }

    public int getDim();

    public int getBitDepth();

    public PhKnnQuery<T> nearestNeighbour(int var1, long ... var2);

    public PhKnnQuery<T> nearestNeighbour(int var1, PhDistance var2, PhFilter var3, long ... var4);

    public PhRangeQuery<T> rangeQuery(double var1, long ... var3);

    public PhRangeQuery<T> rangeQuery(double var1, PhDistance var3, long ... var4);

    public T update(long[] var1, long[] var2);

    public List<PhEntry<T>> queryAll(long[] var1, long[] var2);

    public <R> List<R> queryAll(long[] var1, long[] var2, int var3, PhFilter var4, PhMapper<T, R> var5);

    public static <T> PhTree<T> create(int dim) {
        if (dim > 60) {
            return new PhTree16HD(dim);
        }
        if (dim >= 8) {
            return new PhTree16(dim);
        }
        return new PhTree13(dim);
    }

    public static <T> PhTree<T> create(PhTreeConfig cfg) {
        if (cfg.getDim() > 60) {
            return new PhTree16HD(cfg);
        }
        if (cfg.getDim() >= 8) {
            return new PhTree16(cfg);
        }
        return new PhTree13(cfg);
    }

    public void clear();

    default public T getOrDefault(long[] key, T defaultValue) {
        T t = this.get(key);
        return t == null ? defaultValue : t;
    }

    default public T putIfAbsent(long[] key, T value) {
        throw new UnsupportedOperationException();
    }

    default public boolean remove(long[] key, T value) {
        throw new UnsupportedOperationException();
    }

    default public boolean replace(long[] key, T oldValue, T newValue) {
        throw new UnsupportedOperationException();
    }

    default public T replace(long[] key, T value) {
        throw new UnsupportedOperationException();
    }

    default public T computeIfAbsent(long[] key, Function<long[], ? extends T> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    default public T computeIfPresent(long[] key, BiFunction<long[], ? super T, ? extends T> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    default public T compute(long[] key, BiFunction<long[], ? super T, ? extends T> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public static interface PhKnnQuery<T>
    extends PhIteratorBase<T, PhEntryDist<T>> {
        public long[] nextKey();

        public PhKnnQuery<T> reset(int var1, PhDistance var2, long ... var3);
    }

    public static interface PhQuery<T>
    extends PhIterator<T> {
        public PhQuery<T> reset(long[] var1, long[] var2);
    }

    public static interface PhExtent<T>
    extends PhIterator<T> {
        public PhExtent<T> reset();
    }

    public static interface PhIterator<T>
    extends PhIteratorBase<T, PhEntry<T>> {
        public long[] nextKey();

        @Override
        public PhEntry<T> nextEntryReuse();
    }
}

