/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v11.nt;

import ch.ethz.globis.pht64kd.MaxKTreeI;
import ch.ethz.globis.phtree.PhTreeHelper;
import ch.ethz.globis.phtree.util.IntVar;
import ch.ethz.globis.phtree.util.PhTreeStats;
import ch.ethz.globis.phtree.util.StringBuilderLn;
import ch.ethz.globis.phtree.v11.Bits;
import ch.ethz.globis.phtree.v11.Node;
import ch.ethz.globis.phtree.v11.nt.NtIteratorMask;
import ch.ethz.globis.phtree.v11.nt.NtIteratorMinMax;
import ch.ethz.globis.phtree.v11.nt.NtNode;
import java.util.List;

public class NodeTreeV11<T>
implements MaxKTreeI {
    static final boolean HCI_ENABLED = true;
    static final boolean AHC_ENABLED = true;
    public static final Object NT_NULL = new Object();
    private static int WARNINGS = 0;
    protected final IntVar nEntries = new IntVar(0);
    private final int keyBitWidth;
    private NtNode<T> root = null;

    private NodeTreeV11(int keyBitWidth) {
        if (keyBitWidth < 1 || keyBitWidth > 64) {
            throw new UnsupportedOperationException("keyBitWidth=" + keyBitWidth);
        }
        this.keyBitWidth = keyBitWidth;
        this.root = NtNode.createRoot(this.getKeyBitWidth());
    }

    public static <T> NodeTreeV11<T> create(int keyBitWidth) {
        return new NodeTreeV11<T>(keyBitWidth);
    }

    private static <T> T addEntry(NtNode<T> root, long hcPos, long[] kdKey, Object value, IntVar entryCount) {
        T t = NodeTreeV11.addEntry(root, hcPos, kdKey, value, (Node)null);
        if (t == null) {
            entryCount.inc();
        }
        return t;
    }

    public static <T> T addEntry(NtNode<T> root, long hcPos, long[] kdKey, Object value, Node phNode) {
        Object localVal;
        int pin;
        NtNode currentNode = root;
        while (true) {
            int conflictingLevels;
            long postInFix;
            long localHcPos;
            if ((pin = currentNode.getPosition(localHcPos = NtNode.pos2LocalPos(hcPos, currentNode.getPostLen()), 6)) < 0) {
                currentNode.localAddEntryPIN(pin, localHcPos, hcPos, kdKey, value);
                NodeTreeV11.incCounter(phNode);
                return null;
            }
            localVal = currentNode.getValueByPIN(pin);
            boolean isSubNode = localVal instanceof NtNode;
            NtNode sub = null;
            if (isSubNode) {
                sub = (NtNode)localVal;
                if (currentNode.getPostLen() - sub.getPostLen() > 1) {
                    postInFix = currentNode.localReadInfix(pin, localHcPos);
                    conflictingLevels = NtNode.getConflictingLevels(hcPos, postInFix, currentNode.getPostLen(), sub.getPostLen());
                } else {
                    postInFix = 0L;
                    conflictingLevels = 0;
                }
            } else {
                postInFix = currentNode.localReadPostfix(pin, localHcPos);
                conflictingLevels = NtNode.getConflictingLevels(hcPos, postInFix, currentNode.getPostLen());
            }
            if (conflictingLevels != 0) {
                int newPostLen = conflictingLevels - 1;
                NtNode newNode = NtNode.createNode(newPostLen, kdKey.length);
                currentNode.localReplaceEntryWithSub(pin, localHcPos, hcPos, newNode);
                long localHcInSubOfNewEntry = NtNode.pos2LocalPos(hcPos, newPostLen);
                long localHcInSubOfPrevEntry = NtNode.pos2LocalPos(postInFix, newPostLen);
                newNode.localAddEntry(localHcInSubOfNewEntry, hcPos, kdKey, value);
                long[] localKdKey = new long[kdKey.length];
                currentNode.readKdKeyPIN(pin, localKdKey);
                newNode.localAddEntry(localHcInSubOfPrevEntry, postInFix, localKdKey, localVal);
                NodeTreeV11.incCounter(phNode);
                return null;
            }
            if (!isSubNode) break;
            currentNode = sub;
        }
        if (phNode == null) {
            return (T)currentNode.localReplaceEntry(pin, kdKey, value);
        }
        if (localVal instanceof Node) {
            Node subNode = (Node)localVal;
            long mask = phNode.calcInfixMask(subNode.getPostLen());
            return (T)NodeTreeV11.insertSplitPH(kdKey, value, localVal, pin, mask, currentNode, phNode);
        }
        if (phNode.getPostLen() > 0) {
            long mask = phNode.calcPostfixMask();
            return (T)NodeTreeV11.insertSplitPH(kdKey, value, localVal, pin, mask, currentNode, phNode);
        }
        currentNode.localReplaceValue(pin, value);
        return (T)value;
    }

    private static void incCounter(Node node) {
        if (node != null) {
            node.incEntryCount();
        }
    }

    private static Object insertSplitPH(long[] newKey, Object newValue, Object currentValue, int pin, long mask, NtNode<?> currentNode, Node phNode) {
        long[] localKdKey = new long[newKey.length];
        currentNode.readKdKeyPIN(pin, localKdKey);
        int maxConflictingBits = Node.calcConflictingBits(newKey, localKdKey, mask);
        if (maxConflictingBits == 0) {
            if (!(currentValue instanceof Node)) {
                currentNode.localReplaceValue(pin, newValue);
            }
            return currentValue;
        }
        Node newNode = phNode.createNode(newKey, newValue, localKdKey, currentValue, maxConflictingBits);
        currentNode.localReplaceEntry(pin, newKey, newNode);
        return null;
    }

    public static <T> Object removeEntry(NtNode<T> root, long hcPos, int outerDims, IntVar entryCount) {
        Object t = NodeTreeV11.removeEntry(root, hcPos, outerDims, null, null, null, null);
        if (t != null) {
            entryCount.dec();
        }
        return t;
    }

    public static <T> Object removeEntry(NtNode<T> root, long hcPos, int outerDims, long[] keyToMatch, long[] newKey, int[] insertRequired, Node phNode) {
        Object localVal;
        long localHcPos;
        int pin;
        NtNode parentNode = null;
        int parentPin = -1;
        long parentHcPos = -1L;
        NtNode currentNode = root;
        while (true) {
            boolean conflictingLevels;
            long postInFix;
            if ((pin = currentNode.getPosition(localHcPos = NtNode.pos2LocalPos(hcPos, currentNode.getPostLen()), 6)) < 0) {
                return null;
            }
            localVal = currentNode.getValueByPIN(pin);
            boolean isLocalSubNode = localVal instanceof NtNode;
            NtNode sub = null;
            if (isLocalSubNode) {
                sub = (NtNode)localVal;
                if (currentNode.getPostLen() - sub.getPostLen() > 1) {
                    postInFix = currentNode.localReadInfix(pin, localHcPos);
                    conflictingLevels = NtNode.hasConflictingLevels(hcPos, postInFix, currentNode.getPostLen(), sub.getPostLen());
                } else {
                    conflictingLevels = false;
                }
            } else {
                postInFix = currentNode.localReadPostfix(pin, localHcPos);
                conflictingLevels = NtNode.hasConflictingLevels(hcPos, postInFix, currentNode.getPostLen());
            }
            if (conflictingLevels) {
                return null;
            }
            if (!isLocalSubNode) break;
            parentNode = currentNode;
            parentPin = pin;
            parentHcPos = localHcPos;
            currentNode = sub;
        }
        if (phNode != null) {
            Object o = NodeTreeV11.phGetIfKdMatches(keyToMatch, currentNode, pin, localVal, phNode);
            if (o instanceof Node) {
                return o;
            }
            if (o == null) {
                return null;
            }
            if (newKey != null) {
                int bitPosOfDiff = Node.calcConflictingBits(keyToMatch, newKey, -1L);
                if (bitPosOfDiff <= phNode.getPostLen()) {
                    return currentNode.replaceEntry(pin, newKey, localVal);
                }
                insertRequired[0] = bitPosOfDiff;
            }
            phNode.decEntryCount();
        }
        Object ret = currentNode.removeValue(localHcPos, pin, outerDims, 6);
        if (parentNode != null && currentNode.getEntryCount() == 1) {
            int pin2 = currentNode.findFirstEntry(6);
            long localHcPos2 = currentNode.localReadKey(pin2);
            Object val2 = currentNode.getValueByPIN(pin2);
            int postLen2 = currentNode.getPostLen() * 6;
            long mask2 = postLen2 + 6 == 64 ? 0L : -1L << postLen2 + 6;
            long postInfix2 = hcPos & mask2;
            postInfix2 |= localHcPos2 << postLen2;
            postInfix2 = val2 instanceof NtNode ? (postInfix2 |= currentNode.localReadInfix(pin2, localHcPos2)) : (postInfix2 |= currentNode.localReadPostfix(pin2, localHcPos2));
            parentNode.replacePost(parentPin, parentHcPos, postInfix2, 6);
            long[] kdKey2 = new long[outerDims];
            currentNode.readKdKeyPIN(pin2, kdKey2);
            parentNode.localReplaceEntry(parentPin, kdKey2, val2);
            currentNode.discardNode();
        }
        return ret;
    }

    private static Object phGetIfKdMatches(long[] keyToMatch, NtNode<?> currentNodeNt, int pinNt, Object currentVal, Node phNode) {
        if (currentVal instanceof Node) {
            Node sub = (Node)currentVal;
            long mask = phNode.calcInfixMask(sub.getPostLen());
            if (!currentNodeNt.readKdKeyAndCheck(pinNt, keyToMatch, mask)) {
                return null;
            }
            return currentVal;
        }
        long mask = phNode.calcPostfixMask();
        if (!currentNodeNt.readKdKeyAndCheck(pinNt, keyToMatch, mask)) {
            return null;
        }
        return currentVal;
    }

    public static <T> Object getEntry(NtNode<T> root, long hcPos, long[] outKey, long[] kdKeyToMatch, Node phNode) {
        Object localVal;
        int pin;
        NtNode currentNode = root;
        while (true) {
            boolean conflictingLevels;
            long postInFix;
            long localHcPos;
            if ((pin = currentNode.getPosition(localHcPos = NtNode.pos2LocalPos(hcPos, currentNode.getPostLen()), 6)) < 0) {
                return null;
            }
            localVal = outKey != null ? currentNode.getEntryByPIN(pin, outKey) : currentNode.getValueByPIN(pin);
            boolean isLocalSubNode = localVal instanceof NtNode;
            NtNode sub = null;
            if (isLocalSubNode) {
                sub = (NtNode)localVal;
                if (currentNode.getPostLen() - sub.getPostLen() > 1) {
                    postInFix = currentNode.localReadInfix(pin, localHcPos);
                    conflictingLevels = NtNode.hasConflictingLevels(hcPos, postInFix, currentNode.getPostLen(), sub.getPostLen());
                } else {
                    conflictingLevels = false;
                }
            } else {
                postInFix = currentNode.localReadPostfix(pin, localHcPos);
                conflictingLevels = NtNode.hasConflictingLevels(hcPos, postInFix, currentNode.getPostLen());
            }
            if (conflictingLevels) {
                return null;
            }
            if (!isLocalSubNode) break;
            currentNode = sub;
        }
        if (kdKeyToMatch != null && NodeTreeV11.phGetIfKdMatches(kdKeyToMatch, currentNode, pin, localVal, phNode) == null) {
            return null;
        }
        return localVal;
    }

    public static <T> T replaceValue(NtNode<T> root, long hcPos, Object value) {
        int pin;
        NtNode currentNode = root;
        while (true) {
            int conflictingLevels;
            long postInFix;
            long localHcPos;
            if ((pin = currentNode.getPosition(localHcPos = NtNode.pos2LocalPos(hcPos, currentNode.getPostLen()), 6)) < 0) {
                throw new IllegalArgumentException();
            }
            Object localVal = currentNode.getValueByPIN(pin);
            boolean isSubNode = localVal instanceof NtNode;
            NtNode sub = null;
            if (isSubNode) {
                sub = (NtNode)localVal;
                if (currentNode.getPostLen() - sub.getPostLen() > 1) {
                    postInFix = currentNode.localReadInfix(pin, localHcPos);
                    conflictingLevels = NtNode.getConflictingLevels(hcPos, postInFix, currentNode.getPostLen(), sub.getPostLen());
                } else {
                    conflictingLevels = 0;
                }
            } else {
                postInFix = currentNode.localReadPostfix(pin, localHcPos);
                conflictingLevels = NtNode.getConflictingLevels(hcPos, postInFix, currentNode.getPostLen());
            }
            if (conflictingLevels != 0) {
                throw new IllegalArgumentException();
            }
            if (!isSubNode) break;
            currentNode = sub;
        }
        return (T)currentNode.localReplaceValue(pin, value);
    }

    static long inc(long v, long min, long max) {
        long r = v | max ^ 0xFFFFFFFFFFFFFFFFL;
        return ++r & max | min;
    }

    @Override
    public int size() {
        return this.nEntries.get();
    }

    void increaseNrEntries() {
        this.nEntries.inc();
    }

    void decreaseNrEntries() {
        this.nEntries.dec();
    }

    @Override
    public int getKeyBitWidth() {
        return this.keyBitWidth;
    }

    @Override
    public NtNode<T> getRoot() {
        return this.root;
    }

    public T put(long key, long[] kdKey, T value) {
        return NodeTreeV11.addEntry(this.root, key, kdKey, value == null ? NT_NULL : value, this.nEntries);
    }

    public boolean putB(long key, long[] kdKey) {
        return NodeTreeV11.addEntry(this.root, key, kdKey, NT_NULL, this.nEntries) != null;
    }

    public boolean contains(long key, long[] outKdKey) {
        return NodeTreeV11.getEntry(this.root, key, outKdKey, null, null) != null;
    }

    public T get(long key, long[] outKdKey) {
        Object ret = NodeTreeV11.getEntry(this.root, key, outKdKey, null, null);
        return (T)(ret == NT_NULL ? null : ret);
    }

    public T remove(long key) {
        Object ret = NodeTreeV11.removeEntry(this.root, key, this.getKeyBitWidth(), this.nEntries);
        return (T)(ret == NT_NULL ? null : ret);
    }

    public boolean removeB(long key) {
        Object ret = NodeTreeV11.removeEntry(this.root, key, this.getKeyBitWidth(), this.nEntries);
        return ret != null;
    }

    public String toStringTree() {
        StringBuilderLn sb = new StringBuilderLn();
        this.printTree(sb, this.root);
        return sb.toString();
    }

    private void printTree(StringBuilderLn str, NtNode<T> node) {
        int indent = NtNode.calcTreeHeight(this.getKeyBitWidth()) - node.getPostLen();
        String pre = "";
        for (int i = 0; i < indent; ++i) {
            pre = pre + "-";
        }
        str.append(pre + "pl=" + node.getPostLen());
        str.append(";ec=" + node.getEntryCount());
        str.appendLn("; ID=" + node);
        long[] kdKey = new long[this.getKeyBitWidth()];
        for (int i = 0; i < 64; ++i) {
            int pin = node.getPosition(i, 6);
            if (pin < 0) continue;
            Object v = node.getEntryByPIN(pin, kdKey);
            if (v instanceof NtNode) {
                str.append(pre + i + " ");
                this.printTree(str, (NtNode)v);
                continue;
            }
            str.appendLn(pre + i + " " + Bits.toBinary(kdKey) + " v=" + v);
        }
    }

    public NtIteratorMask<T> queryWithMask(long minMask, long maxMask) {
        NtIteratorMask<T> it = new NtIteratorMask<T>(this.getKeyBitWidth());
        it.reset(this.root, minMask, maxMask);
        return it;
    }

    public MaxKTreeI.PhIterator64<T> query(long min, long max) {
        NtIteratorMinMax<T> it = new NtIteratorMinMax<T>(this.getKeyBitWidth());
        it.reset(this.root, min, max);
        return it;
    }

    public MaxKTreeI.PhIterator64<T> iterator() {
        NtIteratorMinMax<T> it = new NtIteratorMinMax<T>(this.getKeyBitWidth());
        it.reset(this.root, Long.MIN_VALUE, Long.MAX_VALUE);
        return it;
    }

    public boolean checkTree() {
        System.err.println("Not implemented: checkTree()");
        return true;
    }

    public static void getStats(NtNode<?> node, PhTreeStats stats, int dims, List<Object> entryBuffer) {
        int REF = 4;
        ++stats.nNtNodes;
        stats.size += (long)PhTreeHelper.align8(28);
        int nNodeEntriesFound = 0;
        for (Object o : node.values()) {
            if (o == null) continue;
            ++nNodeEntriesFound;
            if (o instanceof NtNode) {
                NodeTreeV11.getStats((NtNode)o, stats, dims, entryBuffer);
                continue;
            }
            entryBuffer.add(o);
        }
        if (nNodeEntriesFound != node.getEntryCount()) {
            System.err.println("WARNING: entry count mismatch: found/ntec=" + nNodeEntriesFound + "/" + node.getEntryCount());
        }
        stats.size += (long)(16 + PhTreeHelper.align8(node.ba.length * 8));
        stats.size += (long)(16 + PhTreeHelper.align8(node.values().length * 4));
        stats.size += (long)(16 + PhTreeHelper.align8(node.kdKeys().length * 8));
        if (dims <= 31 && (long)node.getEntryCount() > 1L << dims) {
            System.err.println("WARNING: Over-populated node found: ntec=" + node.getEntryCount());
        }
        int baS = node.calcArraySizeTotalBits(node.getEntryCount(), dims);
        if ((baS = Bits.calcArraySize(baS)) < node.ba.length) {
            System.err.println("Array too large in NT(" + ++WARNINGS + "): " + node.ba.length + " - " + baS + " = " + (node.ba.length - baS));
        }
    }
}

