/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v13;

import ch.ethz.globis.phtree.PhDistance;
import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhEntryDist;
import ch.ethz.globis.phtree.PhTree;
import ch.ethz.globis.phtree.v13.Node;
import ch.ethz.globis.phtree.v13.NodeIteratorFullToList;
import ch.ethz.globis.phtree.v13.PhResultList;
import ch.ethz.globis.phtree.v13.PhTree13;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;

public class PhQueryKnnHS<T>
implements PhTree.PhKnnQuery<T> {
    private static final PhDEComp COMP = new PhDEComp();
    private final int dims;
    private PhTree13<T> pht;
    private PhDistance distance;
    private long[] center;
    private final ArrayList<PhEntryDist<T>> results = new ArrayList();
    private final ArrayList<PhEntryDist<T>> pool = new ArrayList();
    private final PriorityQueue<PhEntryDist<T>> queue = new PriorityQueue(COMP);
    private final NodeIteratorFullToList<T> iterNode;
    private Iterator<PhEntryDist<T>> iterResult;
    private final KnnResultList<T> candidateBuffer;

    public PhQueryKnnHS(PhTree13<T> pht) {
        this.dims = pht.getDim();
        this.pht = pht;
        this.candidateBuffer = new KnnResultList<T>(this.dims, this.pool);
        this.iterNode = new NodeIteratorFullToList(this.dims);
    }

    @Override
    public long[] nextKey() {
        return ((PhEntry)this.nextEntryReuse()).getKey();
    }

    @Override
    public T nextValue() {
        return ((PhEntry)this.nextEntryReuse()).getValue();
    }

    @Override
    public PhEntryDist<T> nextEntry() {
        return this.iterResult.next();
    }

    @Override
    public PhEntryDist<T> nextEntryReuse() {
        return this.iterResult.next();
    }

    @Override
    public boolean hasNext() {
        return this.iterResult.hasNext();
    }

    @Override
    public T next() {
        return this.nextValue();
    }

    @Override
    public PhTree.PhKnnQuery<T> reset(int nMin, PhDistance dist, long ... center) {
        this.distance = dist == null ? this.distance : dist;
        this.center = center;
        this.queue.clear();
        this.results.clear();
        if (nMin <= 0 || this.pht.size() == 0) {
            this.iterResult = Collections.emptyList().iterator();
            return this;
        }
        PhEntryDist<Object> rootE = PhQueryKnnHS.createEntry(this.pool, new long[this.dims], null, 0.0);
        rootE.setNodeInternal(this.pht.getRoot());
        this.queue.add(rootE);
        this.search(nMin);
        this.iterResult = this.results.iterator();
        return this;
    }

    private void search(int k) {
        while (!this.queue.isEmpty()) {
            PhEntryDist<T> candidate = this.queue.poll();
            if (!candidate.hasNodeInternal()) {
                this.results.add(candidate);
                if (this.results.size() < k) continue;
                return;
            }
            Node node = (Node)candidate.getNodeInternal();
            this.candidateBuffer.clear();
            this.iterNode.init(node, this.candidateBuffer, candidate.getKey());
            for (int i = 0; i < this.candidateBuffer.size(); ++i) {
                Object e2 = this.candidateBuffer.get(i);
                if (((PhEntry)e2).hasNodeInternal()) {
                    Node sub = (Node)((PhEntry)e2).getNodeInternal();
                    double d = this.distToNode(((PhEntry)e2).getKey(), sub.getPostLen() + 1);
                    ((PhEntryDist)e2).setDist(d);
                } else {
                    double d = this.distance.dist(this.center, ((PhEntry)e2).getKey());
                    ((PhEntryDist)e2).setDist(d);
                }
                this.queue.add((PhEntryDist<T>)e2);
            }
            this.pool.add(candidate);
        }
    }

    private static <T> PhEntryDist<T> createEntry(ArrayList<PhEntryDist<T>> pool, long[] key, T val, double dist) {
        if (pool.isEmpty()) {
            return new PhEntryDist<T>(key, val, dist);
        }
        PhEntryDist<T> e = pool.remove(pool.size() - 1);
        e.setKeyInternal(key);
        e.set(val, dist);
        return e;
    }

    private double distToNode(long[] prefix, int bitsToIgnore) {
        long maskMin = -1L << bitsToIgnore;
        long maskMax = maskMin ^ 0xFFFFFFFFFFFFFFFFL;
        long[] buf = new long[prefix.length];
        for (int i = 0; i < buf.length; ++i) {
            long min = prefix[i] & maskMin;
            long max = prefix[i] | maskMax;
            buf[i] = min > this.center[i] ? min : (max < this.center[i] ? max : this.center[i]);
        }
        return this.distance.dist(this.center, buf);
    }

    static class KnnResultList<T>
    extends PhResultList<T, PhEntryDist<T>> {
        private final ArrayList<PhEntryDist<T>> list = new ArrayList();
        private PhEntryDist<T> free;
        private final ArrayList<PhEntryDist<T>> pool;

        KnnResultList(int dims, ArrayList<PhEntryDist<T>> pool) {
            this.pool = pool;
            this.free = PhQueryKnnHS.createEntry(pool, new long[dims], null, 0.0);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public PhEntryDist<T> get(int index) {
            return this.list.get(index);
        }

        @Override
        PhEntryDist<T> phGetTempEntry() {
            PhEntryDist<T> ret = this.free;
            this.free = null;
            return ret;
        }

        @Override
        void phReturnTemp(PhEntry<T> entry) {
            if (this.free == null) {
                this.free = (PhEntryDist)entry;
            }
        }

        @Override
        void phOffer(PhEntry<T> e) {
            this.list.add((PhEntryDist)e);
            this.free = PhQueryKnnHS.createEntry(this.pool, new long[e.getKey().length], null, 0.0);
        }

        @Override
        boolean phIsPrefixValid(long[] prefix, int bitsToIgnore) {
            return true;
        }
    }

    private static class PhDEComp
    implements Comparator<PhEntryDist<?>> {
        private PhDEComp() {
        }

        @Override
        public int compare(PhEntryDist<?> a, PhEntryDist<?> b) {
            double d2;
            double d1 = a.dist();
            return d1 < (d2 = b.dist()) ? -1 : (d1 > d2 ? 1 : 0);
        }
    }
}

