/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v16;

import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhFilter;
import ch.ethz.globis.phtree.v16.Node;
import ch.ethz.globis.phtree.v16.bst.BSTIteratorAll;

public class NodeIteratorFullNoGC<T> {
    private final BSTIteratorAll ntIterator = new BSTIteratorAll();
    private PhFilter checker;

    void init(Node node, PhFilter checker) {
        this.checker = checker;
        this.ntIterator.reset(node.getRoot());
    }

    boolean increment(PhEntry<T> result) {
        while (this.ntIterator.hasNextEntry()) {
            Node.BSTEntry be = this.ntIterator.nextEntry();
            if (!this.readValue(be, result)) continue;
            return true;
        }
        return false;
    }

    private boolean readValue(Node.BSTEntry entry, PhEntry<T> result) {
        long[] kdKey = entry.getKdKey();
        Object value = entry.getValue();
        if (value instanceof Node) {
            Node sub = (Node)value;
            if (this.checker != null && !this.checker.isValid(sub.postLenStored() + 1, kdKey)) {
                return false;
            }
            result.setKeyInternal(kdKey);
            result.setNodeInternal(sub);
        } else {
            if (this.checker != null && !this.checker.isValid(kdKey)) {
                return false;
            }
            result.setKeyInternal(kdKey);
            result.setValueInternal(value);
        }
        return true;
    }
}

