/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPI;
import net.milkbowl.vault.chat.Chat;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;
import us.ajg0702.leaderboards.Debug;
import us.ajg0702.leaderboards.Listeners;
import us.ajg0702.leaderboards.TimeUtils;
import us.ajg0702.leaderboards.boards.StatEntry;
import us.ajg0702.leaderboards.boards.TimedType;
import us.ajg0702.leaderboards.boards.TopManager;
import us.ajg0702.leaderboards.cache.Cache;
import us.ajg0702.leaderboards.cache.ExtraManager;
import us.ajg0702.leaderboards.commands.base.CommandSender;
import us.ajg0702.leaderboards.commands.base.platforms.bukkit.BukkitCommand;
import us.ajg0702.leaderboards.commands.base.platforms.bukkit.BukkitSender;
import us.ajg0702.leaderboards.commands.main.MainCommand;
import us.ajg0702.leaderboards.displays.armorstands.ArmorStandManager;
import us.ajg0702.leaderboards.displays.heads.HeadManager;
import us.ajg0702.leaderboards.displays.lpcontext.LuckpermsContextLoader;
import us.ajg0702.leaderboards.displays.lpcontext.WithLPCtx;
import us.ajg0702.leaderboards.displays.lpcontext.WithoutLPCtx;
import us.ajg0702.leaderboards.displays.signs.SignManager;
import us.ajg0702.leaderboards.formatting.PlaceholderFormatter;
import us.ajg0702.leaderboards.libs.bstats.bukkit.Metrics;
import us.ajg0702.leaderboards.libs.configurate.CommentedConfigurationNode;
import us.ajg0702.leaderboards.libs.configurate.ConfigurateException;
import us.ajg0702.leaderboards.libs.configurate.serialize.SerializationException;
import us.ajg0702.leaderboards.libs.kyori.adventure.platform.bukkit.BukkitAudiences;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.Component;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.minimessage.MiniMessage;
import us.ajg0702.leaderboards.libs.slimjar.app.builder.ApplicationBuilder;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.Repository;
import us.ajg0702.leaderboards.libs.utils.common.Config;
import us.ajg0702.leaderboards.libs.utils.common.Messages;
import us.ajg0702.leaderboards.loaders.MessageLoader;
import us.ajg0702.leaderboards.nms.legacy.HeadUtils;
import us.ajg0702.leaderboards.placeholders.PlaceholderExpansion;
import us.ajg0702.leaderboards.utils.Exporter;
import us.ajg0702.leaderboards.utils.OfflineUpdater;
import us.ajg0702.leaderboards.utils.SlimJarLogger;

public class LeaderboardPlugin
extends JavaPlugin {
    private Config config;
    private Cache cache;
    private ExtraManager extraManager;
    private Messages messages;
    private TopManager topManager;
    private SignManager signManager;
    private HeadManager headManager;
    private HeadUtils headUtils;
    private ArmorStandManager armorStandManager;
    private LuckpermsContextLoader contextLoader;
    private final Exporter exporter = new Exporter(this);
    private final PlaceholderFormatter placeholderFormatter = new PlaceholderFormatter(this);
    private final Map<String, OfflineUpdater> offlineUpdaters = new ConcurrentHashMap<String, OfflineUpdater>();
    private boolean vault;
    private Chat vaultChat;
    private boolean shuttingDown = false;
    int updateTaskId = -1;
    final HashMap<TimedType, Integer> resetIds = new HashMap();
    private static MiniMessage miniMessage;
    private static BukkitAudiences adventure;
    private long lastTimeAlert = 0L;
    private boolean doublePrevention = false;

    public void onLoad() {
        try {
            Path downloadPath = Paths.get(this.getDataFolder().getPath() + File.separator + "libs", new String[0]);
            ApplicationBuilder.appending("ajLeaderboards").logger(new SlimJarLogger(this)).downloadDirectoryPath(downloadPath).mirrorSelector((a, b) -> a).internalRepositories(Collections.singleton(new Repository(new URL("https://repo1.maven.org/maven2/")))).build();
        }
        catch (IOException | ReflectiveOperationException | URISyntaxException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public void onEnable() {
        if (this.isShuttingDown()) {
            throw new IllegalStateException("Reload was used! ajLeaderboards does not support this!");
        }
        StatEntry.setPlugin(this);
        BukkitCommand bukkitMainCommand = new BukkitCommand(new MainCommand(this));
        bukkitMainCommand.register(this);
        BukkitSender.setAdventure(this.getAdventure());
        try {
            this.config = new Config(this.getDataFolder(), this.getLogger());
        }
        catch (ConfigurateException e) {
            this.getLogger().log(Level.WARNING, "An error occurred while loading your config:", e);
        }
        Debug.setLogger(this.getLogger());
        Debug.setDebug(this.config.getBoolean("debug"));
        Debug.setParticles(this.config.getBoolean("particles"));
        this.setWeeklyResetDay();
        this.messages = MessageLoader.loadMessages(this);
        CommentedConfigurationNode msgs = this.messages.getRootNode();
        if (msgs.hasChild(this.getSignPath("1"))) {
            int i;
            ArrayList<String> linesList = new ArrayList<String>();
            for (i = 1; i <= 4; ++i) {
                linesList.add(((CommentedConfigurationNode)msgs.node((Iterable)this.getSignPath(i))).getString());
            }
            try {
                ((CommentedConfigurationNode)msgs.node((Iterable)this.getSignPath("default"))).setList(String.class, (List)linesList);
                for (i = 1; i <= 4; ++i) {
                    ((CommentedConfigurationNode)msgs.node((Iterable)this.getSignPath(i))).set(null);
                }
                this.messages.save();
            }
            catch (SerializationException e) {
                this.getLogger().log(Level.SEVERE, "Unable to move sign messages: ", e);
            }
        }
        TimeUtils.setStrings(this.messages);
        Bukkit.getScheduler().runTask((Plugin)this, () -> {
            if (Bukkit.getPluginManager().isPluginEnabled("Vault")) {
                RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Chat.class);
                if (rsp == null) {
                    this.vault = false;
                    this.getLogger().warning("Vault prefix hook failed! Make sure you have a plugin that implements chat (e.g. Luckperms)");
                } else {
                    this.vaultChat = (Chat)rsp.getProvider();
                    this.vault = true;
                }
            }
        });
        this.signManager = new SignManager(this);
        this.headManager = new HeadManager(this);
        this.headUtils = new HeadUtils(this.getLogger());
        this.armorStandManager = new ArmorStandManager(this);
        this.cache = new Cache(this);
        List<String> initialBoards = this.cache.getBoards();
        this.getLogger().info("Loaded " + initialBoards.size() + " boards");
        this.extraManager = new ExtraManager(this);
        this.topManager = new TopManager(this, initialBoards);
        this.reloadInterval();
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, this::scheduleResets, 0L, 18000L);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> this.offlineUpdaters.forEach((b, u) -> u.progressLog()), 100L, 600L);
        Metrics metrics = new Metrics((Plugin)this, 9338);
        metrics.addCustomChart(new Metrics.SimplePie("storage_method", () -> this.getCache().getMethod().getName()));
        PlaceholderExpansion placeholders = new PlaceholderExpansion(this);
        if (placeholders.register()) {
            this.getLogger().info("PAPI placeholders successfully registered!");
        } else {
            this.getLogger().warning("Failed to register ajlb PAPI placeholders!");
        }
        this.contextLoader = Bukkit.getPluginManager().isPluginEnabled("LuckPerms") ? new WithLPCtx(this) : new WithoutLPCtx(this);
        this.contextLoader.checkReload();
        Bukkit.getPluginManager().registerEvents((Listener)new Listeners(this), (Plugin)this);
        this.getLogger().info("ajLeaderboards v" + this.getDescription().getVersion() + " by ajgeiss0702 enabled!");
    }

    private Iterable<String> getSignPath(int i) {
        return this.getSignPath(i + "");
    }

    private Iterable<String> getSignPath(String end) {
        return Arrays.asList("signs", "top", end);
    }

    public void onDisable() {
        this.shuttingDown = true;
        if (this.getContextLoader() != null) {
            this.getContextLoader().checkReload(false);
        }
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        if (this.getTopManager() != null) {
            this.getTopManager().shutdown();
        }
        if (this.getCache() != null) {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            executorService.execute(() -> {
                this.getLogger().info("Shutting down cache method..");
                this.getCache().getMethod().shutdown();
                this.getLogger().info("Cache method shut down");
            });
            executorService.shutdown();
            try {
                if (!executorService.awaitTermination(15L, TimeUnit.SECONDS)) {
                    executorService.shutdownNow();
                    this.getLogger().warning("Cache took too long to shut down. Skipping it.");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.getLogger().info("Killing remaining workers");
        this.killWorkers(1000);
        Debug.info("1st kill pass done, retrying for remaining");
        this.killWorkers(5000);
        this.getLogger().info("Remaining workers killed");
        this.getLogger().info("ajLeaderboards v" + this.getDescription().getVersion() + " disabled.");
        Bukkit.getScheduler().getActiveWorkers().forEach(bukkitWorker -> {
            Debug.info("Active worker: " + bukkitWorker.getOwner().getDescription().getName() + " " + bukkitWorker.getTaskId());
            for (StackTraceElement stackTraceElement : bukkitWorker.getThread().getStackTrace()) {
                Debug.info(" - " + stackTraceElement);
            }
        });
    }

    private void killWorkers(int waitForDeath) {
        ArrayList workers = new ArrayList(Bukkit.getScheduler().getActiveWorkers());
        ArrayList killedWorkers = new ArrayList();
        workers.forEach(bukkitWorker -> {
            if (!bukkitWorker.getOwner().equals((Object)this)) {
                return;
            }
            int id = bukkitWorker.getTaskId();
            if (killedWorkers.contains(id)) {
                return;
            }
            Debug.info("Got worker " + id);
            try {
                bukkitWorker.getThread().interrupt();
                Debug.info("Interupted");
                bukkitWorker.getThread().join(waitForDeath);
                Debug.info("Death");
            }
            catch (SecurityException e) {
                Debug.info("denied: " + e.getMessage());
            }
            catch (InterruptedException ignored) {
                Debug.info("threw interupted exception on " + id);
            }
            killedWorkers.add(id);
        });
    }

    public Config getAConfig() {
        return this.config;
    }

    public Cache getCache() {
        return this.cache;
    }

    public ExtraManager getExtraManager() {
        return this.extraManager;
    }

    public TopManager getTopManager() {
        return this.topManager;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public boolean hasVault() {
        return this.vault;
    }

    public SignManager getSignManager() {
        return this.signManager;
    }

    public HeadUtils getHeadUtils() {
        return this.headUtils;
    }

    public ArmorStandManager getArmorStandManager() {
        return this.armorStandManager;
    }

    public HeadManager getHeadManager() {
        return this.headManager;
    }

    public Chat getVaultChat() {
        return this.vaultChat;
    }

    public LuckpermsContextLoader getContextLoader() {
        return this.contextLoader;
    }

    public Exporter getExporter() {
        return this.exporter;
    }

    public PlaceholderFormatter getPlaceholderFormatter() {
        return this.placeholderFormatter;
    }

    public Map<String, OfflineUpdater> getOfflineUpdaters() {
        return this.offlineUpdaters;
    }

    public void reloadInterval() {
        if (this.updateTaskId != -1) {
            try {
                Bukkit.getScheduler().cancelTask(this.updateTaskId);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.updateTaskId = -1;
        }
        this.updateTaskId = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
            if (!this.config.getBoolean("update-stats")) {
                return;
            }
            if (this.getTopManager().getFetchingAverage() > 100) {
                this.getLogger().warning("Database is overloaded! Skipping update of players.");
                return;
            }
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (this.isShuttingDown()) {
                    return;
                }
                this.getTopManager().submit(() -> this.getCache().updatePlayerStats((OfflinePlayer)p));
            }
        }, 200L, (long)this.config.getInt("stat-refresh").intValue()).getTaskId();
        Debug.info("Update task id is " + this.updateTaskId);
    }

    public void scheduleResets() {
        this.resetIds.values().forEach(arg_0 -> ((BukkitScheduler)Bukkit.getScheduler()).cancelTask(arg_0));
        this.resetIds.clear();
        for (TimedType type : TimedType.values()) {
            try {
                this.scheduleReset(type);
            }
            catch (InterruptedException | ExecutionException e) {
                if (this.isShuttingDown()) {
                    return;
                }
                this.getLogger().log(Level.WARNING, "Scheduling reset interupted:", e);
            }
        }
    }

    public void scheduleReset(TimedType type) throws ExecutionException, InterruptedException {
        if (type.equals((Object)TimedType.ALLTIME)) {
            return;
        }
        long now = Instant.now().getEpochSecond();
        long nextReset = type.getNextReset().toEpochSecond(TimeUtils.getDefaultZoneOffset());
        ArrayList<String> resetNow = new ArrayList<String>();
        for (String board : this.getTopManager().getBoards()) {
            long lastReset = this.topManager.getLastReset(board, type);
            LocalDateTime lastResetDate = LocalDateTime.ofEpochSecond(lastReset, 0, ZoneOffset.UTC);
            long estLastReset = type.getEstimatedLastReset().toEpochSecond(TimeUtils.getDefaultZoneOffset());
            long lastResetConverted = lastResetDate.toEpochSecond(TimeUtils.getDefaultZoneOffset());
            if (lastResetConverted >= estLastReset) continue;
            Debug.info("lastRest for " + (Object)((Object)type) + " " + board + " is before estimatedLastReset! " + lastReset + " < " + estLastReset);
            resetNow.add(board);
        }
        if (resetNow.size() > 0) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                try {
                    for (String board : resetNow) {
                        this.cache.reset(board, type);
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    if (this.isShuttingDown()) {
                        return;
                    }
                    this.getLogger().log(Level.WARNING, "Unable to reset " + (Object)((Object)type) + ": (interupted/exception)", e);
                }
            });
        }
        if (this.isShuttingDown()) {
            return;
        }
        long secsTilNextReset = nextReset - now;
        Debug.info("Initial secsTilNextReset for " + type.lowerName() + ": " + secsTilNextReset);
        if (secsTilNextReset < 0L) {
            secsTilNextReset = 0L;
        }
        Debug.info(TimeUtils.formatTimeSeconds(secsTilNextReset) + " until the reset for " + type.lowerName() + " (next formatted: " + type.getNextReset().atOffset(ZoneOffset.UTC).format(DateTimeFormatter.RFC_1123_DATE_TIME) + " next: " + nextReset + ")");
        if (this.isShuttingDown()) {
            return;
        }
        int taskId = Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, () -> {
            try {
                for (String board : this.getTopManager().getBoards()) {
                    this.cache.reset(board, type);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                if (this.isShuttingDown()) {
                    return;
                }
                this.getLogger().log(Level.WARNING, "Unable to reset " + (Object)((Object)type) + ": (interupted/exception)", e);
            }
        }, secsTilNextReset * 20L).getTaskId();
        this.resetIds.put(type, taskId);
    }

    public boolean validatePlaceholder(String placeholder, CommandSender sayOutput) {
        if (Bukkit.getOnlinePlayers().size() == 0) {
            this.getLogger().warning("Unable to validate placeholder because no players are online. Skipping validation.");
            return true;
        }
        Player vp = (Player)Bukkit.getOnlinePlayers().iterator().next();
        String out = PlaceholderAPI.setPlaceholders((Player)vp, (String)("%" + Cache.alternatePlaceholders(placeholder) + "%")).replaceAll(",", "");
        try {
            this.getPlaceholderFormatter().toDouble(out, placeholder);
        }
        catch (NumberFormatException e) {
            if (sayOutput != null) {
                sayOutput.sendMessage(LeaderboardPlugin.message("&7Returned: " + out.replaceAll("\u00a7", "&")));
            }
            return false;
        }
        return true;
    }

    public static MiniMessage getMiniMessage() {
        if (miniMessage == null) {
            miniMessage = MiniMessage.miniMessage();
        }
        return miniMessage;
    }

    public BukkitAudiences getAdventure() {
        if (adventure == null) {
            adventure = BukkitAudiences.create((Plugin)this);
        }
        return adventure;
    }

    public void setWeeklyResetDay() {
        DayOfWeek day;
        String rawDay = this.config.getString("reset-weekly-on");
        try {
            day = DayOfWeek.valueOf(rawDay.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warning("Invalid day '" + rawDay + "' for reset-weekly-on in the config! Defaulting to sunday.");
            day = DayOfWeek.SUNDAY;
        }
        TimedType.setWeeklyResetDay(day);
    }

    public static Component message(String miniMessage) {
        return LeaderboardPlugin.getMiniMessage().deserialize(Messages.color(miniMessage));
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public void timePlaceholderUsed() {
        if (this.doublePrevention) {
            return;
        }
        this.doublePrevention = true;
        long timeAlertCooldown = 1800000L;
        if (this.lastTimeAlert == 0L) {
            this.lastTimeAlert = System.currentTimeMillis() - (timeAlertCooldown - 30000L);
        }
        if (System.currentTimeMillis() - this.lastTimeAlert > timeAlertCooldown) {
            this.lastTimeAlert = System.currentTimeMillis();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.hasPermission("ajleaderboards.use")) continue;
                this.getAdventure().player(player).sendMessage(LeaderboardPlugin.message("&6[&eajLeaderboards&6] &cYou are using a deprecated placeholder! &7The time placeholder is no longer necessary, and will be removed in the future.\n&fTo replace it&7, replace all time placeholders with value placeholders. They will automatically format the time.\n\n&eFor more information, &6<click:open_url:'https://wiki.ajg0702.us/ajleaderboards/time-deprecation'><underlined>click here</click>\n"));
            }
        }
        this.doublePrevention = false;
    }
}

