/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.cache.helpers;

import com.google.gson.JsonObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import us.ajg0702.leaderboards.boards.TimedType;
import us.ajg0702.leaderboards.utils.EasyJsonObject;

public class DbRow {
    private final UUID id;
    private final double value;
    private final Map<TimedType, Double> deltas;
    private final Map<TimedType, Double> lastTotals;
    private final Map<TimedType, Long> timestamps;
    private final String namecache;
    private final String prefixcache;
    private final String suffixcache;
    private final String displaynamecache;
    private static final Map<String, Integer> positionCache = new HashMap<String, Integer>();

    public DbRow(ResultSet resultSet) throws SQLException {
        this(UUID.fromString(resultSet.getString(DbRow.getIndex(resultSet, "id"))), resultSet.getDouble(DbRow.getIndex(resultSet, "value")), DbRow.getTypeMaps(resultSet), resultSet.getString(DbRow.getIndex(resultSet, "namecache")), resultSet.getString(DbRow.getIndex(resultSet, "prefixcache")), resultSet.getString(DbRow.getIndex(resultSet, "suffixcache")), resultSet.getString(DbRow.getIndex(resultSet, "displaynamecache")));
    }

    public static void clearPositionCache() {
        positionCache.clear();
    }

    private DbRow(UUID id, double value, List<Object> typeMaps, String namecache, String prefixcache, String suffixcache, String displaynamecache) {
        this(id, value, (Map)typeMaps.get(0), (Map)typeMaps.get(1), (Map)typeMaps.get(2), namecache, prefixcache, suffixcache, displaynamecache);
    }

    public DbRow(UUID id, double value, Map<TimedType, Double> deltas, Map<TimedType, Double> lastTotals, Map<TimedType, Long> timestamps, String namecache, String prefixcache, String suffixcache, String displaynamecache) {
        this.id = id;
        this.value = value;
        this.deltas = deltas;
        this.lastTotals = lastTotals;
        this.timestamps = timestamps;
        this.namecache = namecache;
        this.prefixcache = prefixcache;
        this.suffixcache = suffixcache;
        this.displaynamecache = displaynamecache;
    }

    private static List<Object> getTypeMaps(ResultSet resultSet) throws SQLException {
        HashMap<TimedType, Double> deltas = new HashMap<TimedType, Double>();
        HashMap<TimedType, Double> lastTotals = new HashMap<TimedType, Double>();
        HashMap<TimedType, Long> timestamps = new HashMap<TimedType, Long>();
        for (TimedType type : TimedType.values()) {
            if (type == TimedType.ALLTIME) continue;
            deltas.put(type, resultSet.getDouble(DbRow.getIndex(resultSet, type.lowerName() + "_delta")));
            lastTotals.put(type, resultSet.getDouble(DbRow.getIndex(resultSet, type.lowerName() + "_lasttotal")));
            timestamps.put(type, resultSet.getLong(DbRow.getIndex(resultSet, type.lowerName() + "_timestamp")));
        }
        return Arrays.asList(deltas, lastTotals, timestamps);
    }

    private static int getIndex(ResultSet rs, String name) throws SQLException {
        if (!positionCache.containsKey(name)) {
            int position = rs.findColumn(name);
            positionCache.put(name, position);
            return position;
        }
        return positionCache.get(name);
    }

    public UUID getId() {
        return this.id;
    }

    public double getValue() {
        return this.value;
    }

    public Map<TimedType, Double> getDeltas() {
        return this.deltas;
    }

    public Map<TimedType, Double> getLastTotals() {
        return this.lastTotals;
    }

    public Map<TimedType, Long> getTimestamps() {
        return this.timestamps;
    }

    public String getNamecache() {
        return this.namecache;
    }

    public String getPrefixcache() {
        return this.prefixcache;
    }

    public String getSuffixcache() {
        return this.suffixcache;
    }

    public String getDisplaynamecache() {
        return this.displaynamecache;
    }

    public JsonObject toJsonObject() {
        EasyJsonObject out = new EasyJsonObject().add("id", this.getId().toString()).add("value", this.getValue());
        for (TimedType type : TimedType.values()) {
            String lowerName = type.lowerName();
            out.add(lowerName + "_delta", this.getDeltas().get((Object)type));
            out.add(lowerName + "_lasttotal", this.getLastTotals().get((Object)type));
            out.add(lowerName + "_timestamp", this.getTimestamps().get((Object)type));
        }
        out.add("namecache", this.getNamecache());
        out.add("prefixcache", this.getPrefixcache());
        out.add("suffixcache", this.getSuffixcache());
        out.add("displaynamecache", this.getDisplaynamecache() == null ? this.getNamecache() : this.getDisplaynamecache());
        return out.getHandle();
    }

    public static DbRow fromJsonObject(JsonObject object) {
        HashMap<TimedType, Double> deltas = new HashMap<TimedType, Double>();
        HashMap<TimedType, Double> lastTotals = new HashMap<TimedType, Double>();
        HashMap<TimedType, Long> timestamps = new HashMap<TimedType, Long>();
        for (TimedType type : TimedType.values()) {
            if (type == TimedType.ALLTIME) continue;
            deltas.put(type, object.get(type.lowerName() + "_delta").getAsDouble());
            lastTotals.put(type, object.get(type.lowerName() + "_lasttotal").getAsDouble());
            timestamps.put(type, object.get(type.lowerName() + "_timestamp").getAsLong());
        }
        return new DbRow(UUID.fromString(object.get("id").getAsString()), object.get("value").getAsDouble(), deltas, lastTotals, timestamps, object.get("namecache").getAsString(), object.get("prefixcache").getAsString(), object.get("suffixcache").getAsString(), object.get("displaynamecache").getAsString());
    }
}

