/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.commands.main.subcommands;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.commands.base.CommandSender;
import us.ajg0702.leaderboards.commands.base.SubCommand;

public class Export
extends SubCommand {
    private final LeaderboardPlugin plugin;

    public Export(LeaderboardPlugin plugin) {
        super("export", Collections.emptyList(), null, "Export cache to a .json file that can be imported later");
        this.plugin = plugin;
    }

    @Override
    public List<String> autoComplete(CommandSender sender, String[] args) {
        if (args.length == 1 && !args[0].isEmpty()) {
            return Collections.singletonList(this.addJsonEnding(args[0]));
        }
        return Collections.emptyList();
    }

    @Override
    public void execute(CommandSender sender, String[] args, String label) {
        if (args.length < 1) {
            sender.sendMessage(LeaderboardPlugin.message("&cPlease provide a file name.\n&7Usage: /" + label + " export <file>"));
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            String fileName = this.addJsonEnding(args[0]);
            File file = new File(this.plugin.getDataFolder(), fileName);
            if (file.exists()) {
                sender.sendMessage(this.plugin.getMessages().getComponent("commands.export.fileexists", "FILE:" + fileName));
                return;
            }
            JsonObject obj = this.plugin.getExporter().export(sender);
            if (obj == null) {
                sender.sendMessage(this.plugin.getMessages().getComponent("commands.export.fail", new String[0]));
                return;
            }
            try {
                FileWriter writer = new FileWriter(file);
                new Gson().toJson((JsonElement)obj, (Appendable)writer);
                ((Writer)writer).close();
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "An error occurred while writing:", e);
                sender.sendMessage(this.plugin.getMessages().getComponent("commands.export.fail", new String[0]));
                return;
            }
            sender.sendMessage(this.plugin.getMessages().getComponent("commands.export.success", "FILE:" + fileName));
            this.plugin.getLogger().info("Exporting to file " + fileName + " complete!");
        });
    }

    private String addJsonEnding(String has) {
        if (has.endsWith(".json")) {
            return has;
        }
        int lastDot = has.lastIndexOf(46);
        if (lastDot != -1) {
            String afterDot = has.substring(lastDot);
            if (this.recursiveEquals(afterDot) && afterDot.length() < 5) {
                return has + ".json".substring(afterDot.length());
            }
            return has + ".json";
        }
        return has + ".json";
    }

    private boolean recursiveEquals(String thing) {
        for (int i = ".json".length(); i >= 0; --i) {
            String s = ".json".substring(0, i);
            if (!thing.equals(s)) continue;
            return true;
        }
        return false;
    }
}

