/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.commands.main.subcommands;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import us.ajg0702.leaderboards.Debug;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.TimeUtils;
import us.ajg0702.leaderboards.commands.base.CommandSender;
import us.ajg0702.leaderboards.commands.base.SubCommand;
import us.ajg0702.leaderboards.libs.configurate.ConfigurateException;

public class Reload
extends SubCommand {
    private final LeaderboardPlugin plugin;

    public Reload(LeaderboardPlugin plugin) {
        super("reload", Collections.emptyList(), "ajleaderboards.use", "Reload the config files");
        this.plugin = plugin;
    }

    @Override
    public List<String> autoComplete(CommandSender commandSender, String[] strings) {
        return Collections.emptyList();
    }

    @Override
    public void execute(CommandSender sender, String[] args, String label) {
        if (!this.checkPermission(sender)) {
            sender.sendMessage(this.plugin.getMessages().getComponent("noperm", new String[0]));
            return;
        }
        try {
            this.plugin.getAConfig().reload();
            this.plugin.setWeeklyResetDay();
            this.plugin.getMessages().reload();
            this.plugin.getSignManager().reload();
            this.plugin.reloadInterval();
            Debug.setDebug(this.plugin.getAConfig().getBoolean("debug"));
            Debug.setParticles(this.plugin.getAConfig().getBoolean("particles"));
            TimeUtils.setStrings(this.plugin.getMessages());
        }
        catch (ConfigurateException e) {
            this.plugin.getLogger().log(Level.WARNING, "Unable to reload the config:", e);
            sender.sendMessage(this.plugin.getMessages().getComponent("commands.reload.fail", new String[0]));
            return;
        }
        this.plugin.getContextLoader().checkReload();
        sender.sendMessage(this.plugin.getMessages().getComponent("commands.reload.success", new String[0]));
    }
}

