/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.commands.main.subcommands;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.commands.base.CommandSender;
import us.ajg0702.leaderboards.commands.base.SubCommand;

public class Viewer
extends SubCommand {
    private final LeaderboardPlugin plugin;

    public Viewer(LeaderboardPlugin plugin) {
        super("viewer", Collections.singletonList("webviewer"), null, "Export all board data to be viewed in the Web Viewer");
        this.plugin = plugin;
    }

    @Override
    public List<String> autoComplete(CommandSender sender, String[] args) {
        return Collections.emptyList();
    }

    @Override
    public void execute(CommandSender sender, String[] args, String label) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            URL url;
            JsonObject obj = this.plugin.getExporter().export(sender);
            if (obj == null) {
                sender.sendMessage(this.plugin.getMessages().getComponent("commands.export.fail", new String[0]));
                return;
            }
            String data = obj.toString();
            sender.sendMessage(this.plugin.getMessages().getComponent("commands.viewer.uploading", new String[0]));
            try {
                url = new URL("https://paste.ajg0702.us/post");
            }
            catch (MalformedURLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "An error occurred while exporting to viewer:", e);
                sender.sendMessage(this.plugin.getMessages().getComponent("commands.export.fail", new String[0]));
                return;
            }
            try {
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setRequestMethod("POST");
                con.setRequestProperty("User-Agent", "AJLB-exporter/" + this.plugin.getDescription().getVersion());
                con.setRequestProperty("Content-Type", "application/json");
                con.setDoOutput(true);
                try (OutputStream os = con.getOutputStream();){
                    byte[] input = data.getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
                try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8));){
                    String responseLine;
                    StringBuilder response = new StringBuilder();
                    while ((responseLine = br.readLine()) != null) {
                        response.append(responseLine.trim());
                    }
                    JsonObject responseJson = (JsonObject)new Gson().fromJson(response.toString(), JsonObject.class);
                    sender.sendMessage(this.plugin.getMessages().getComponent("commands.viewer.success", "URL:https://ajlb-viewer.ajg0702.us/#" + responseJson.get("key").getAsString()));
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "An error occurred while exporting to viewer:", e);
                sender.sendMessage(this.plugin.getMessages().getComponent("commands.export.fail", new String[0]));
                return;
            }
        });
    }
}

