/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.commands.main.subcommands.signs;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.boards.TimedType;
import us.ajg0702.leaderboards.commands.base.CommandSender;
import us.ajg0702.leaderboards.commands.base.SubCommand;

public class AddSign
extends SubCommand {
    private final LeaderboardPlugin plugin;
    private final String usage = "signs add <board> <position> <type>";

    public AddSign(LeaderboardPlugin plugin) {
        super("add", Collections.emptyList(), null, "Create a leaderboard sign at the sign you are looking at");
        this.plugin = plugin;
    }

    @Override
    public List<String> autoComplete(CommandSender commandSender, String[] args) {
        if (args.length == 1) {
            return this.plugin.getTopManager().getBoards();
        }
        if (args.length == 3) {
            return TimedType.lowerNames();
        }
        return Collections.emptyList();
    }

    @Override
    public void execute(CommandSender sender, String[] args, String label) {
        TimedType type;
        int pos;
        if (args.length < 1) {
            sender.sendMessage(LeaderboardPlugin.message("&cPlease provide a board and a position for the sign!\n&7Usage: /" + label + " " + "signs add <board> <position> <type>"));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(LeaderboardPlugin.message("&cPlease provide a position for the sign\n&7Usage: /" + label + " " + "signs add <board> <position> <type>"));
            return;
        }
        if (args.length < 3) {
            sender.sendMessage(LeaderboardPlugin.message("&cPlease provide a timed type for the sign\n&7Usage: /" + label + " " + "signs add <board> <position> <type>"));
            return;
        }
        if (!sender.isPlayer()) {
            sender.sendMessage(LeaderboardPlugin.message("&cYou must be in-game to do this!"));
            return;
        }
        Player p = (Player)sender.getHandle();
        try {
            pos = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(LeaderboardPlugin.message("&cInvalid number! Please enter a real number for the position.\n&7Usage: /" + label + " signs add <board> <position>"));
            return;
        }
        Block target = p.getTargetBlock(null, 10);
        if (!target.getType().toString().contains("SIGN")) {
            sender.sendMessage(LeaderboardPlugin.message("&cThe block you are looking at is not a sign! Please look at a sign to set."));
            return;
        }
        try {
            type = TimedType.valueOf(args[2].toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            StringBuilder list = new StringBuilder();
            TimedType.lowerNames().forEach(s -> list.append((String)s).append(", "));
            list.delete(list.length() - 2, list.length() - 1);
            sender.sendMessage(LeaderboardPlugin.message("&cInvalid timed type!\n&7Options: " + list));
            return;
        }
        if (!this.plugin.getTopManager().boardExists(args[0])) {
            sender.sendMessage(LeaderboardPlugin.message("&cInvalid board name! &7Make sure to &cnot&7 put &f%&7 around the board name, and also make sure that you created the board.\n&7If you havent yet created the board, there are instructions here:<reset> https://wiki.ajg0702.us/ajleaderboards/setup/setup/ &7(make sure to not skip steps 1 and 2!)"));
            return;
        }
        this.plugin.getSignManager().addSign(target.getLocation(), args[0], pos, type);
        sender.sendMessage(LeaderboardPlugin.message("&aSign created!"));
    }
}

