/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.displays.heads;

import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.plugin.Plugin;
import us.ajg0702.leaderboards.Debug;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.displays.signs.BoardSign;
import us.ajg0702.leaderboards.libs.utils.spigot.VersionSupport;

public class HeadManager {
    private final LeaderboardPlugin plugin;
    private final HashMap<Location, UUID> headLocationCache = new HashMap();

    public HeadManager(LeaderboardPlugin plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void search(BoardSign sign, String name, UUID id) {
        BlockFace face;
        if (this.plugin.isShuttingDown()) {
            return;
        }
        if (!sign.getLocation().getBlock().getType().toString().contains("SIGN")) {
            return;
        }
        if (!this.plugin.getTopManager().getBoards().contains(sign.getBoard())) {
            return;
        }
        if (id == null) {
            return;
        }
        Sign ss = sign.getSign();
        if (ss == null) {
            return;
        }
        if (VersionSupport.getMinorVersion() > 12) {
            org.bukkit.block.data.type.Sign bs;
            BlockData bd = ss.getBlockData();
            if (bd instanceof org.bukkit.block.data.type.Sign) {
                bs = (org.bukkit.block.data.type.Sign)bd;
                face = bs.getRotation();
            } else {
                if (!(bd instanceof WallSign)) {
                    Debug.info("Skipping searching for heads around sign because its an unknown type! " + bd.getClass());
                    return;
                }
                bs = (WallSign)bd;
                face = bs.getFacing();
            }
        } else {
            org.bukkit.material.Sign bs = (org.bukkit.material.Sign)ss.getData();
            face = bs.getFacing();
        }
        Location sl = sign.getLocation();
        switch (face) {
            case NORTH: 
            case NORTH_EAST: 
            case NORTH_NORTH_EAST: 
            case NORTH_NORTH_WEST: 
            case NORTH_WEST: {
                for (int z = sl.getBlockZ() + 1; z > sl.getBlockZ() - 1; --z) {
                    for (int y = sl.getBlockY() + 1; y > sl.getBlockY() - 1; --y) {
                        Location curloc = new Location(sl.getWorld(), sl.getX(), (double)y, (double)z);
                        this.checkHead(curloc, name, id);
                    }
                }
                return;
            }
            case SOUTH: 
            case SOUTH_EAST: 
            case SOUTH_SOUTH_EAST: 
            case SOUTH_SOUTH_WEST: 
            case SOUTH_WEST: {
                for (int z = sl.getBlockZ(); z > sl.getBlockZ() - 2; --z) {
                    for (int y = sl.getBlockY() + 1; y > sl.getBlockY() - 1; --y) {
                        Location curloc = new Location(sl.getWorld(), sl.getX(), (double)y, (double)z);
                        this.checkHead(curloc, name, id);
                    }
                }
                return;
            }
            case EAST: 
            case EAST_NORTH_EAST: 
            case EAST_SOUTH_EAST: {
                for (int x = sl.getBlockX(); x > sl.getBlockX() - 2; --x) {
                    for (int y = sl.getBlockY() + 1; y > sl.getBlockY() - 1; --y) {
                        Location curloc = new Location(sl.getWorld(), (double)x, (double)y, sl.getZ());
                        this.checkHead(curloc, name, id);
                    }
                }
                return;
            }
            case WEST: 
            case WEST_NORTH_WEST: 
            case WEST_SOUTH_WEST: {
                for (int x = sl.getBlockX() + 1; x > sl.getBlockX() - 1; --x) {
                    for (int y = sl.getBlockY() + 1; y > sl.getBlockY() - 1; --y) {
                        Location curloc = new Location(sl.getWorld(), (double)x, (double)y, sl.getZ());
                        this.checkHead(curloc, name, id);
                    }
                }
                return;
            }
        }
    }

    public void checkHead(Location loc, String name, UUID id) {
        Validate.notNull((Object)loc);
        Validate.notNull((Object)id, (String)"UUID is null!");
        String blockType = loc.getBlock().getType().toString();
        if (this.headLocationCache.containsKey(loc) && blockType.contains("AIR")) {
            this.headLocationCache.remove(loc);
            Debug.info("Removed air from cache");
        }
        if (id.equals(this.headLocationCache.get(loc))) {
            return;
        }
        if (!(blockType.contains("SKULL") || blockType.contains("HEAD") && !blockType.contains("PISTON"))) {
            return;
        }
        Debug.info("Updating head with " + id);
        OfflinePlayer op = VersionSupport.getMinorVersion() > 9 ? Bukkit.getOfflinePlayer((UUID)id) : null;
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (this.plugin.getHeadUtils().getVersionedHeadUtils() != null) {
                this.plugin.getHeadUtils().getVersionedHeadUtils().setHeadBlock(loc.getBlock(), id, name);
            } else {
                BlockState bs = loc.getBlock().getState();
                if (!(bs instanceof Skull)) {
                    return;
                }
                Skull skull = (Skull)bs;
                if (VersionSupport.getMinorVersion() > 9) {
                    assert (op != null);
                    skull.setOwningPlayer(op);
                } else {
                    skull.setOwner(name);
                }
                skull.update();
            }
            this.headLocationCache.put(loc, id);
        });
    }
}

