/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.displays.signs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.boards.StatEntry;
import us.ajg0702.leaderboards.boards.TimedType;
import us.ajg0702.leaderboards.displays.signs.BoardSign;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.Component;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import us.ajg0702.leaderboards.libs.utils.common.Messages;
import us.ajg0702.leaderboards.libs.utils.spigot.VersionSupport;

public class SignManager {
    private final LeaderboardPlugin plugin;
    private YamlConfiguration cfg;
    private File cfgFile;
    private static final LegacyComponentSerializer LEGACY_SIGN_SERIALIZER = LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    private final List<BoardSign> signs = new CopyOnWriteArrayList<BoardSign>();
    int updateIntervalId = -1;
    final HashMap<String, String> names = new HashMap();

    public SignManager(LeaderboardPlugin plugin) {
        this.plugin = plugin;
        Bukkit.getScheduler().runTask((Plugin)plugin, this::reload);
    }

    public List<BoardSign> getSigns() {
        return this.signs;
    }

    public void reload() {
        this.cfgFile = new File(this.plugin.getDataFolder(), "displays.yml");
        this.cfg = YamlConfiguration.loadConfiguration((File)this.cfgFile);
        String headerText = "This file is for storing sign location, npcs, and other things in the plugin that might display data";
        if (VersionSupport.getMinorVersion() > 18) {
            this.cfg.options().setHeader(Collections.singletonList(headerText));
        } else {
            this.cfg.options().header(headerText);
        }
        this.signs.clear();
        if (this.cfg.contains("signs")) {
            List rawsigns = this.cfg.getStringList("signs");
            for (String s : rawsigns) {
                try {
                    this.signs.add(BoardSign.deserialize(s));
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.WARNING, "An error occurred while loading a sign:", e);
                }
            }
        }
        this.updateNameCache();
        if (this.updateIntervalId != -1) {
            try {
                Bukkit.getScheduler().cancelTask(this.updateIntervalId);
                this.updateIntervalId = -1;
            }
            catch (IllegalStateException e) {
                this.updateIntervalId = -1;
            }
        }
        this.updateIntervalId = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::updateSigns, 200L, (long)this.plugin.getAConfig().getInt("sign-update").intValue()).getTaskId();
    }

    public boolean removeSign(Location l) {
        return this.removeSign(l, true);
    }

    public boolean removeSign(Location l, boolean removeText) {
        boolean save = false;
        for (BoardSign s : this.signs) {
            if (!l.equals((Object)s.getLocation())) continue;
            this.signs.remove(s);
            save = true;
            s.setRemoved(true);
            if (!removeText) break;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> s.setText("", "", "", ""));
            break;
        }
        if (save) {
            this.saveFile();
        }
        return save;
    }

    public BoardSign findSign(Location l) {
        for (BoardSign s : this.signs) {
            if (!l.equals((Object)s.getLocation())) continue;
            return s;
        }
        return null;
    }

    public void addSign(Location loc, String board, int pos, TimedType type) {
        if (this.findSign(loc) != null) {
            return;
        }
        this.signs.add(new BoardSign(loc, board, pos, type));
        this.saveFile();
    }

    public void saveFile() {
        ArrayList<String> signsraw = new ArrayList<String>();
        for (BoardSign sign : this.signs) {
            if (sign.isRemoved()) continue;
            signsraw.add(sign.serialize());
        }
        this.cfg.set("signs", signsraw);
        try {
            this.cfg.save(this.cfgFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "An error occurred while saving signs to the file:", e);
        }
    }

    public void updateSigns() {
        this.updateNameCache();
        for (BoardSign sign : this.signs) {
            if (sign.isRemoved()) continue;
            this.updateSign(sign);
        }
    }

    public void updateNameCache() {
        List<String> namesraw = this.plugin.getAConfig().getStringList("value-names");
        for (String s : namesraw) {
            if (!s.contains("%")) continue;
            String[] parts = s.split("%");
            this.names.put(parts[0], parts[1]);
        }
    }

    public Map<String, String> getNames() {
        return new HashMap<String, String>(this.names);
    }

    public void updateSign(BoardSign sign) {
        if (!this.isSignChunkLoaded(sign)) {
            return;
        }
        try {
            if (!sign.isPlaced()) {
                return;
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            if (this.plugin.isShuttingDown()) {
                return;
            }
            this.plugin.getLogger().log(Level.SEVERE, "Interrupted while trying to check if sign is placed:", e);
        }
        String name = "";
        if (this.names.containsKey(sign.getBoard())) {
            name = this.names.get(sign.getBoard());
        }
        StatEntry r = this.plugin.getTopManager().getStat(sign.getPosition(), sign.getBoard(), sign.getType());
        Messages msgs = this.plugin.getMessages();
        String[] placeholders = Arrays.asList("POSITION:" + sign.getPosition(), "NAME:" + r.getPlayerName(), "VALUE:" + r.getScorePretty(), "FVALUE:" + r.getScoreFormatted(), "TVALUE:" + r.getTime(), "VALUENAME:" + Matcher.quoteReplacement(name), "TIMEDTYPE:" + sign.getType().lowerName()).toArray(new String[0]);
        List<Component> lines = msgs.hasMessage("signs.top." + sign.getBoard()) ? msgs.getComponentList("signs.top." + sign.getBoard(), placeholders) : msgs.getComponentList("signs.top.default", placeholders);
        ArrayList pLines = new ArrayList();
        lines.forEach(c -> pLines.add(LEGACY_SIGN_SERIALIZER.serialize((Component)c)));
        if (this.plugin.isShuttingDown()) {
            return;
        }
        if (r.hasPlayer()) {
            this.plugin.getHeadManager().search(sign, r.getPlayerName(), r.getPlayerID());
            if (this.plugin.isShuttingDown()) {
                return;
            }
            this.plugin.getArmorStandManager().search(sign, r.getPlayerName(), r.getPlayerID());
        }
        if (this.plugin.isShuttingDown()) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sign.setText((String)pLines.get(0), (String)pLines.get(1), (String)pLines.get(2), (String)pLines.get(3)));
    }

    public boolean isSignChunkLoaded(BoardSign sign) {
        return sign.getWorld().isChunkLoaded(sign.getX(), sign.getZ());
    }
}

