/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.formatting.formats;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.ajg0702.leaderboards.Debug;
import us.ajg0702.leaderboards.TimeUtils;
import us.ajg0702.leaderboards.formatting.Format;

public class Time
extends Format {
    private static final Pattern weekPattern = Pattern.compile("([1-9][0-9]*)w");
    private static final Pattern dayPattern = Pattern.compile("([1-9][0-9]*)d");
    private static final Pattern hourPattern = Pattern.compile("([1-9][0-9]*)h");
    private static final Pattern minutePattern = Pattern.compile("([1-9][0-9]*)m");
    private static final Pattern secondPattern = Pattern.compile("([1-9][0-9]*)s");
    private static final Pattern fullPattern = Pattern.compile("(([1-9][0-9]*)w)?(([1-9][0-9]*)d)?(([1-9][0-9]*)h)?(([1-9][0-9]*)m)?(([1-9][0-9]*)s)?");
    private static final Map<String, String> replaces = new HashMap<String, String>();
    private static final List<String> knownTimePlaceholders;

    @Override
    public boolean matches(String output, String placeholder) {
        if (knownTimePlaceholders.contains(placeholder.toLowerCase(Locale.ROOT))) {
            return true;
        }
        if (output == null) {
            return false;
        }
        if (output.isEmpty()) {
            return false;
        }
        String temp = output.replaceAll(",", "");
        for (Map.Entry<String, String> replacesEntry : replaces.entrySet()) {
            temp = temp.replace(replacesEntry.getKey(), replacesEntry.getValue());
        }
        boolean matches = fullPattern.matcher(temp.replaceAll(" ", "")).matches();
        Debug.info("[Format: Time] '" + output + "' matches: " + matches);
        return matches;
    }

    @Override
    public double toDouble(String input) {
        String temp = input.replaceAll(",", "");
        int seconds = -1;
        seconds = Time.getSeconds(temp, 604800, seconds, weekPattern);
        seconds = Time.getSeconds(temp, 86400, seconds, dayPattern);
        seconds = Time.getSeconds(temp, 3600, seconds, hourPattern);
        seconds = Time.getSeconds(temp, 60, seconds, minutePattern);
        if ((seconds = Time.getSeconds(temp, 1, seconds, secondPattern)) == -1) {
            throw new NumberFormatException("Unable to parse time from: '" + input + "'");
        }
        return seconds;
    }

    private static int getSeconds(String output, int multiplier, int seconds, Pattern pattern) {
        Matcher matcher = pattern.matcher(output);
        if (matcher.find()) {
            if (seconds == -1) {
                seconds = 0;
            }
            seconds += Integer.parseInt(matcher.group(1)) * multiplier;
        }
        return seconds;
    }

    @Override
    public String toFormat(double input) {
        return TimeUtils.formatTimeSeconds(Math.round(input));
    }

    @Override
    public String getName() {
        return "Time";
    }

    static {
        replaces.put("week", "w");
        replaces.put("weeks", "w");
        replaces.put("day", "d");
        replaces.put("days", "d");
        replaces.put("hour", "h");
        replaces.put("hours", "h");
        replaces.put("minute", "m");
        replaces.put("minutes", "m");
        replaces.put("second", "s");
        replaces.put("seconds", "s");
        knownTimePlaceholders = Arrays.asList("statistic_time_played", "statistic_time_since_death");
    }
}

