/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.slimjar.relocation.helper;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import us.ajg0702.leaderboards.libs.slimjar.downloader.strategy.FilePathStrategy;
import us.ajg0702.leaderboards.libs.slimjar.relocation.Relocator;
import us.ajg0702.leaderboards.libs.slimjar.relocation.helper.RelocationHelper;
import us.ajg0702.leaderboards.libs.slimjar.relocation.meta.MetaMediator;
import us.ajg0702.leaderboards.libs.slimjar.relocation.meta.MetaMediatorFactory;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.Dependency;

public final class VerifyingRelocationHelper
implements RelocationHelper {
    private final FilePathStrategy outputFilePathStrategy;
    private final Relocator relocator;
    private final String selfHash;
    private final MetaMediatorFactory mediatorFactory;

    public VerifyingRelocationHelper(String selfHash, FilePathStrategy outputFilePathStrategy, Relocator relocator, MetaMediatorFactory mediatorFactory) throws URISyntaxException, NoSuchAlgorithmException, IOException {
        this.mediatorFactory = mediatorFactory;
        this.outputFilePathStrategy = outputFilePathStrategy;
        this.relocator = relocator;
        this.selfHash = selfHash;
    }

    @Override
    public File relocate(Dependency dependency, File file) throws IOException, ReflectiveOperationException {
        File relocatedFile = this.outputFilePathStrategy.selectFileFor(dependency);
        MetaMediator metaMediator = this.mediatorFactory.create(relocatedFile.toPath());
        if (relocatedFile.exists()) {
            try {
                String ownerHash = metaMediator.readAttribute("slimjar.owner");
                if (this.selfHash != null && ownerHash != null && this.selfHash.trim().equals(ownerHash.trim())) {
                    return relocatedFile;
                }
            }
            catch (Exception exception) {
                relocatedFile.delete();
            }
        }
        this.relocator.relocate(file, relocatedFile);
        metaMediator.writeAttribute("slimjar.owner", this.selfHash);
        return relocatedFile;
    }
}

