/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.utils;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import us.ajg0702.leaderboards.LeaderboardPlugin;

public class OfflineUpdater {
    private final Deque<OfflinePlayer> offlinePlayerQueue = new ArrayDeque<OfflinePlayer>();
    private final LeaderboardPlugin plugin;
    private final int started;
    private final String board;

    public OfflineUpdater(LeaderboardPlugin plugin, String board, OfflinePlayer[] players) {
        this.plugin = plugin;
        this.board = board;
        this.offlinePlayerQueue.addAll(Arrays.asList(players));
        this.started = this.offlinePlayerQueue.size();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            while (!this.offlinePlayerQueue.isEmpty() && !plugin.isShuttingDown()) {
                OfflinePlayer player = this.offlinePlayerQueue.pop();
                plugin.getCache().updateStat(board, player);
            }
            if (plugin.isShuttingDown()) {
                plugin.getLogger().info("[OfflineUpdater] " + board + ": Canceling due to plugin shutdown");
            } else {
                plugin.getLogger().info("[OfflineUpdater] " + board + ": Done!");
            }
            plugin.getOfflineUpdaters().remove(board, this);
        });
    }

    public double getProgressPercent() {
        return (double)this.offlinePlayerQueue.size() / (double)this.started;
    }

    public int getRemainingPlayers() {
        return this.offlinePlayerQueue.size();
    }

    public int getDonePlayers() {
        return this.started - this.offlinePlayerQueue.size();
    }

    public int getStarted() {
        return this.started;
    }

    public boolean isDone() {
        return this.getRemainingPlayers() == 0;
    }

    public void progressLog() {
        this.plugin.getLogger().info("[OfflineUpdater] " + this.board + ": " + Math.round(this.getProgressPercent() * 1000.0) / 10L + "% done (" + this.getRemainingPlayers() + " / " + this.getStarted() + ")");
    }
}

