/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.jarrelocator;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.lucko.jarrelocator.Relocation;
import org.objectweb.asm.commons.Remapper;

final class RelocatingRemapper
extends Remapper {
    private static final Pattern CLASS_PATTERN = Pattern.compile("(\\[*)?L(.+);");
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(META-INF/versions/\\d+/)(.*)$");
    private final Collection<Relocation> rules;

    RelocatingRemapper(Collection<Relocation> rules) {
        this.rules = rules;
    }

    public Collection<Relocation> getRules() {
        return this.rules;
    }

    public String map(String name) {
        String relocatedName = this.relocate(name, false);
        if (relocatedName != null) {
            return relocatedName;
        }
        return super.map(name);
    }

    public Object mapValue(Object object) {
        String relocatedName;
        if (object instanceof String && (relocatedName = this.relocate((String)object, true)) != null) {
            return relocatedName;
        }
        return super.mapValue(object);
    }

    private String relocate(String name, boolean isStringValue) {
        Matcher m;
        String prefix = "";
        String suffix = "";
        if (isStringValue && (m = CLASS_PATTERN.matcher(name)).matches()) {
            prefix = m.group(1) + "L";
            name = m.group(2);
            suffix = ";";
        }
        if ((m = VERSION_PATTERN.matcher(name)).matches()) {
            prefix = m.group(1);
            name = m.group(2);
        }
        for (Relocation r : this.rules) {
            if (isStringValue && r.canRelocateClass(name)) {
                return prefix + r.relocateClass(name) + suffix;
            }
            if (!r.canRelocatePath(name)) continue;
            return prefix + r.relocatePath(name) + suffix;
        }
        return null;
    }
}

