/*
 * Decompiled with CFR 0.152.
 */
package ru.namerpro.BungeeCord.Utils;

import java.util.LinkedList;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import ru.namerpro.BungeeCord.Utils.ConfigManager;
import ru.namerpro.BungeeCord.Utils.Messages;

public class ErrorManager {
    private static LinkedList<String> errorsList = new LinkedList();

    private static void addErrorToList(String error) {
        errorsList.add(error);
    }

    private static void clearErrorsList() {
        errorsList.clear();
    }

    public static void printErrors() {
        ErrorManager.collectErrors();
        if (errorsList.isEmpty()) {
            return;
        }
        int i = 0;
        Messages.sendConsoleMessage("");
        Messages.sendConsoleMessage(ChatColor.WHITE + "AdvancedNMotd Error Detector!");
        Messages.sendConsoleMessage(ChatColor.YELLOW + "I have detected " + ChatColor.WHITE + errorsList.size() + ChatColor.YELLOW + " error(s).");
        Messages.sendConsoleMessage(ChatColor.DARK_GRAY + "-------------------------------------------------------------------");
        Messages.sendConsoleMessage(ChatColor.GRAY + "Errors list:");
        Messages.sendConsoleMessage("");
        for (String s : errorsList) {
            Messages.sendConsoleMessage(ChatColor.WHITE + "--------------------------------");
            Messages.sendConsoleMessage(ChatColor.WHITE + "Error " + ChatColor.YELLOW + ++i + ChatColor.WHITE + ":");
            Messages.sendConsoleMessage(ChatColor.RED + s);
            Messages.sendConsoleMessage(ChatColor.WHITE + "--------------------------------");
            Messages.sendConsoleMessage("");
        }
        Messages.sendConsoleMessage(ChatColor.DARK_GRAY + "-------------------------------------------------------------------");
        Messages.sendConsoleMessage(ChatColor.GRAY + "If you need help, contact the autor of the plugin on spigot via private message!");
        Messages.sendConsoleMessage("");
        ErrorManager.clearErrorsList();
    }

    private static void collectErrors() {
        List list1 = ConfigManager.strings.getStringList("Motd.LineOne");
        List list2 = ConfigManager.strings.getStringList("Motd.LineTwo");
        int line1 = list1.size() - 1;
        int line2 = list2.size() - 1;
        if (line1 == -1) {
            ErrorManager.addErrorToList("Cannot find a string to display in the 1st line of motd! Check Motd.LineOne section in Strings.yml file to fix this problem.");
        }
        if (line2 == -1) {
            ErrorManager.addErrorToList("Cannot find a string to display in the 2nd line of motd! Check Motd.LineTwo section in Strings.yml file to fix this problem.");
        }
        if (line1 != line2) {
            ErrorManager.addErrorToList("There must be same amount of lines in Motd.LineOne and Motd.LineTwo sections! Lines without pairs will be ignored! Check Motd section in Strings.yml file to fix this problem.");
        }
        if (!ConfigManager.data.getString("Data.FakeMaxPlayers").equals("")) {
            ErrorManager.addErrorToList("Cannot get a number from FakeMaxPlayers section. Check Data.FakeMaxPlayers section in Data.yml file to fix this problem.");
        }
        if (!ConfigManager.data.getString("Data.PlayerSpace").equals("")) {
            ErrorManager.addErrorToList("Cannot get a number from PlayerSpace section. Check Data.PlayerSpace section in Data.yml file to fix this problem.");
        }
        if (!ConfigManager.data.getString("Data.ExtraOnlinePlayers").equals("")) {
            ErrorManager.addErrorToList("Cannot get a number from ExtraOnlinePlayers section. Check Data.ExtraOnlinePlayers section in Data.yml file to fix this problem.");
        }
        try {
            if (ConfigManager.strings.getString("Version.VersionText").isEmpty()) {
                ErrorManager.addErrorToList("Cannot find a string to display in the version motd, because an emmpty string was found! Check Version.VersionText section in Strings.yml file to fix this problem!");
            }
        }
        catch (Exception e) {
            ErrorManager.addErrorToList("Cannot find a string to display in the version motd, because no string was found! Check Version.VersionText section in Strings.yml file to fix this problem!");
        }
        if (ConfigManager.strings.getStringList("HoverBox.HoverText").size() == 0) {
            ErrorManager.addErrorToList("Cannot find a text to display in the hover motd! Check HoverBox.HoverText section in Strings.yml file to fix this problem.");
        }
        try {
            if (ConfigManager.help.getString("FirstLine").isEmpty()) {
                ErrorManager.addErrorToList("Cannot find a string to display in the /anm help command on its 1st line, because an emmpty string was found! Check FirstLine section in Help.yml file to fix this problem!");
            }
        }
        catch (Exception e) {
            ErrorManager.addErrorToList("Cannot find a string to display in the /anm help command on its 1st line, because no string was found! Check FirstLine section in Help.yml file to fix this problem!");
        }
        try {
            if (ConfigManager.help.getString("SecondLine").isEmpty()) {
                ErrorManager.addErrorToList("Cannot find a string to display in the /anm help command on its 2nd line, because an emmpty string was found! Check SecondLine section in Help.yml file to fix this problem!");
            }
        }
        catch (Exception e) {
            ErrorManager.addErrorToList("Cannot find a string to display in the /anm help command on its 2nd line, because no string was found! Check SecondLine section in Help.yml file to fix this problem!");
        }
        try {
            if (ConfigManager.reload.getString("Success").isEmpty()) {
                ErrorManager.addErrorToList("Cannot find a string to display in the /anm reload command when a reload was success, because an emmpty string was found! Check Success section in Reload.yml file to fix this problem!");
            }
        }
        catch (Exception e) {
            ErrorManager.addErrorToList("Cannot find a string to display in the /anm reload command when a reload was success, because no string was found! Check Success section in Reload.yml file to fix this problem!");
        }
        try {
            if (ConfigManager.reload.getString("NoPermissions").isEmpty()) {
                ErrorManager.addErrorToList("Cannot find a string to display in the /anm reload command when a reload failed, because sender had no permissions to run it, because an emmpty string was found! Check NoPermissions section in Reload.yml file to fix this problem!");
            }
        }
        catch (Exception e) {
            ErrorManager.addErrorToList("Cannot find a string to display in the /anm reload command when a reload failed, because sender had no permissions to run it, because no string was found! Check NoPermissions section in Reload.yml file to fix this problem!");
        }
        try {
            if (ConfigManager.unknown.getString("Message").isEmpty()) {
                ErrorManager.addErrorToList("Cannot find a string to display when a wrong command was typed, because an emmpty string was found! Check Message section in UnknownCommand.yml file to fix this problem!");
            }
        }
        catch (Exception e) {
            ErrorManager.addErrorToList("Cannot find a string to display when a wrong command was typed, because no string was found! Check Message section in UnknownCommand.yml file to fix this problem!");
        }
    }
}

