/*
 * Decompiled with CFR 0.152.
 */
package ru.namerpro.BungeeCord.Utils;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import ru.namerpro.BungeeCord.Utils.ConfigManager;

public class Messages {
    public static final String prefix = ChatColor.RED + "A" + ChatColor.GOLD + "N" + ChatColor.RED + "M" + ChatColor.GRAY + ChatColor.BOLD + " | " + ChatColor.WHITE;
    private static final Pattern HEX_COLOR_PATTERN = Pattern.compile("%#([A-Fa-f0-9]){6}%");
    private static final Pattern HEX_GRADIENT_PATTERN = Pattern.compile("%#([A-Fa-f0-9]){6}->#([A-Fa-f0-9]){6}:[^%]*%");
    private static final ArrayList<Color> colors = new ArrayList();

    static {
        colors.add(new Color(0, 0, 0));
        colors.add(new Color(0, 0, 170));
        colors.add(new Color(0, 170, 0));
        colors.add(new Color(0, 170, 170));
        colors.add(new Color(170, 0, 0));
        colors.add(new Color(170, 0, 170));
        colors.add(new Color(255, 170, 0));
        colors.add(new Color(170, 170, 170));
        colors.add(new Color(85, 85, 85));
        colors.add(new Color(85, 85, 255));
        colors.add(new Color(85, 255, 85));
        colors.add(new Color(85, 255, 255));
        colors.add(new Color(255, 85, 85));
        colors.add(new Color(255, 85, 255));
        colors.add(new Color(255, 255, 85));
        colors.add(new Color(255, 255, 255));
    }

    public static void sendConsoleMessage(String message) {
        ProxyServer.getInstance().getConsole().sendMessage((BaseComponent)new TextComponent(message));
    }

    public static String replaceLegacyColorCodes(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static ChatColor getClosestLegacyColor(String color) {
        List colorReplacements = ConfigManager.colors.getSection("Replacements").getKeys().stream().collect(Collectors.toList());
        if (colorReplacements.contains(color)) {
            return ChatColor.getByChar((char)ConfigManager.colors.getString("Replacements.".concat(color)).charAt(1));
        }
        int r1 = Integer.valueOf(color.substring(1, 3), 16);
        int g1 = Integer.valueOf(color.substring(3, 5), 16);
        int b1 = Integer.valueOf(color.substring(5, 7), 16);
        int bestDistance = 195100;
        Color bestColor = null;
        int i = 0;
        while (i < colors.size()) {
            int distance = (r1 - colors.get(i).getRed()) * (r1 - colors.get(i).getRed()) + (g1 - colors.get(i).getGreen()) * (g1 - colors.get(i).getGreen()) + (b1 - colors.get(i).getBlue()) * (b1 - colors.get(i).getBlue());
            if (distance < bestDistance) {
                bestColor = colors.get(i);
                bestDistance = distance;
            }
            ++i;
        }
        if (bestColor == null) {
            return ChatColor.BLACK;
        }
        switch (bestColor.getRed()) {
            case 0: {
                switch (bestColor.getGreen()) {
                    case 0: {
                        switch (bestColor.getBlue()) {
                            case 0: {
                                return ChatColor.BLACK;
                            }
                            case 170: {
                                return ChatColor.DARK_BLUE;
                            }
                        }
                    }
                    case 170: {
                        switch (bestColor.getBlue()) {
                            case 0: {
                                return ChatColor.DARK_GREEN;
                            }
                            case 170: {
                                return ChatColor.DARK_AQUA;
                            }
                        }
                    }
                }
            }
            case 170: {
                switch (bestColor.getGreen()) {
                    case 0: {
                        switch (bestColor.getBlue()) {
                            case 0: {
                                return ChatColor.DARK_RED;
                            }
                            case 170: {
                                return ChatColor.DARK_PURPLE;
                            }
                        }
                    }
                    case 170: {
                        return ChatColor.GRAY;
                    }
                }
            }
            case 255: {
                switch (bestColor.getGreen()) {
                    case 170: {
                        return ChatColor.GOLD;
                    }
                    case 85: {
                        switch (bestColor.getBlue()) {
                            case 85: {
                                return ChatColor.RED;
                            }
                            case 255: {
                                return ChatColor.LIGHT_PURPLE;
                            }
                        }
                    }
                    case 255: {
                        switch (bestColor.getBlue()) {
                            case 85: {
                                return ChatColor.YELLOW;
                            }
                            case 255: {
                                return ChatColor.WHITE;
                            }
                        }
                    }
                }
            }
            case 85: {
                switch (bestColor.getGreen()) {
                    case 85: {
                        switch (bestColor.getBlue()) {
                            case 85: {
                                return ChatColor.DARK_GRAY;
                            }
                            case 255: {
                                return ChatColor.BLUE;
                            }
                        }
                    }
                    case 255: {
                        switch (bestColor.getBlue()) {
                            case 85: {
                                return ChatColor.GREEN;
                            }
                            case 255: {
                                return ChatColor.AQUA;
                            }
                        }
                    }
                }
            }
        }
        return ChatColor.BLACK;
    }

    private static TextComponent colorToComponent(String message, int startIndex, boolean isLegacy) {
        message = message.trim();
        TextComponent afterComponent = new TextComponent(Messages.replaceLegacyColorCodes(message.substring(startIndex + 9).split("%#([A-Fa-f0-9]){6}%|%#([A-Fa-f0-9]){6}->#([A-Fa-f0-9]){6}:[^%]*%")[0]));
        if (!isLegacy) {
            afterComponent.setColor(ChatColor.of((String)message.substring(startIndex + 1, startIndex + 8)));
        } else {
            afterComponent.setColor(Messages.getClosestLegacyColor(message.substring(startIndex + 1, startIndex + 8)));
        }
        return afterComponent;
    }

    private static TextComponent gradientToComponent(String placeholder, boolean isLegacy) {
        boolean isObfuscated;
        boolean isStrikethrough;
        boolean isUnderline;
        boolean isItalic;
        boolean isBold;
        int b2;
        int b1;
        int g2;
        int g1;
        int r2;
        int r1;
        String from;
        String message;
        block97: {
            placeholder = placeholder.trim();
            message = placeholder.substring(18, placeholder.length() - 1);
            from = placeholder.substring(1, 8);
            String to = placeholder.substring(10, 17);
            r1 = Integer.valueOf(from.substring(1, 3), 16);
            r2 = Integer.valueOf(to.substring(1, 3), 16);
            g1 = Integer.valueOf(from.substring(3, 5), 16);
            g2 = Integer.valueOf(to.substring(3, 5), 16);
            b1 = Integer.valueOf(from.substring(5, 7), 16);
            b2 = Integer.valueOf(to.substring(5, 7), 16);
            isBold = false;
            isItalic = false;
            isUnderline = false;
            isStrikethrough = false;
            isObfuscated = false;
            if (message.length() <= 3 || !message.substring(message.length() - 3).matches(";&[klmnor]")) break block97;
            switch (message.substring(message.length() - 1)) {
                case "k": {
                    isObfuscated = true;
                    break;
                }
                case "l": {
                    isBold = true;
                    break;
                }
                case "m": {
                    isStrikethrough = true;
                    break;
                }
                case "n": {
                    isUnderline = true;
                    break;
                }
                case "o": {
                    isItalic = true;
                }
            }
            message = message.substring(0, message.length() - 3);
            if (!message.substring(message.length() - 3).matches(";&[klmnor]")) break block97;
            switch (message.substring(message.length() - 1)) {
                case "k": {
                    isObfuscated = true;
                    break;
                }
                case "l": {
                    isBold = true;
                    break;
                }
                case "m": {
                    isStrikethrough = true;
                    break;
                }
                case "n": {
                    isUnderline = true;
                    break;
                }
                case "o": {
                    isItalic = true;
                }
            }
            message = message.substring(0, message.length() - 3);
            if (!message.substring(message.length() - 3).matches(";&[klmnor]")) break block97;
            switch (message.substring(message.length() - 1)) {
                case "k": {
                    isObfuscated = true;
                    break;
                }
                case "l": {
                    isBold = true;
                    break;
                }
                case "m": {
                    isStrikethrough = true;
                    break;
                }
                case "n": {
                    isUnderline = true;
                    break;
                }
                case "o": {
                    isItalic = true;
                }
            }
            message = message.substring(0, message.length() - 3);
            if (!message.substring(message.length() - 3).matches(";&[klmnor]")) break block97;
            switch (message.substring(message.length() - 1)) {
                case "k": {
                    isObfuscated = true;
                    break;
                }
                case "l": {
                    isBold = true;
                    break;
                }
                case "m": {
                    isStrikethrough = true;
                    break;
                }
                case "n": {
                    isUnderline = true;
                    break;
                }
                case "o": {
                    isItalic = true;
                }
            }
            message = message.substring(0, message.length() - 3);
            if (!message.substring(message.length() - 3).matches(";&[klmnor]")) break block97;
            switch (message.substring(message.length() - 1)) {
                case "k": {
                    isObfuscated = true;
                    break;
                }
                case "l": {
                    isBold = true;
                    break;
                }
                case "m": {
                    isStrikethrough = true;
                    break;
                }
                case "n": {
                    isUnderline = true;
                    break;
                }
                case "o": {
                    isItalic = true;
                }
            }
            message = message.substring(0, message.length() - 3);
        }
        if (isLegacy) {
            TextComponent legacyGradientComponent = new TextComponent(message);
            legacyGradientComponent.setColor(Messages.getClosestLegacyColor(from));
            legacyGradientComponent.setBold(Boolean.valueOf(isBold));
            legacyGradientComponent.setItalic(Boolean.valueOf(isItalic));
            legacyGradientComponent.setUnderlined(Boolean.valueOf(isUnderline));
            legacyGradientComponent.setStrikethrough(Boolean.valueOf(isStrikethrough));
            legacyGradientComponent.setObfuscated(Boolean.valueOf(isObfuscated));
            return legacyGradientComponent;
        }
        char[] messageToLetters = message.toCharArray();
        int j = 0;
        double l = 1.0 / (double)message.length();
        TextComponent gradientComponent = new TextComponent("");
        double i = 0.0;
        while (i < 1.0) {
            if (j >= messageToLetters.length) break;
            int r = (int)((double)r1 * (1.0 - i) + (double)r2 * i);
            int g = (int)((double)g1 * (1.0 - i) + (double)g2 * i);
            int b = (int)((double)b1 * (1.0 - i) + (double)b2 * i);
            TextComponent preGradientComponent = new TextComponent(Messages.replaceLegacyColorCodes(String.valueOf(messageToLetters[j])));
            preGradientComponent.setColor(ChatColor.of((String)String.format("#%02X%02X%02X", r, g, b)));
            gradientComponent.addExtra((BaseComponent)preGradientComponent);
            ++j;
            i += l;
        }
        gradientComponent.setBold(Boolean.valueOf(isBold));
        gradientComponent.setItalic(Boolean.valueOf(isItalic));
        gradientComponent.setUnderlined(Boolean.valueOf(isUnderline));
        gradientComponent.setStrikethrough(Boolean.valueOf(isStrikethrough));
        gradientComponent.setObfuscated(Boolean.valueOf(isObfuscated));
        return gradientComponent;
    }

    public static TextComponent replaceColorCodes(String message, boolean isLegacy) {
        message = "&r" + message;
        String preResult = message.replace("&r", "%#808080%");
        TextComponent result = new TextComponent("");
        if (ConfigManager.config.getBoolean("AdvancedNMotd.Configuration.Colors")) {
            List colorPlaceholders = ConfigManager.colors.getSection("Placeholders").getKeys().stream().collect(Collectors.toList());
            int i = 0;
            while (i < colorPlaceholders.size()) {
                preResult = preResult.replaceAll("%" + (String)colorPlaceholders.get(i) + "%", "%" + ConfigManager.colors.getString("Placeholders." + (String)colorPlaceholders.get(i)) + "%");
                ++i;
            }
        }
        Matcher matcher = HEX_COLOR_PATTERN.matcher(preResult);
        Matcher matcher2 = HEX_GRADIENT_PATTERN.matcher(preResult);
        boolean hasColorPlaceholder = matcher.find();
        boolean hasGradientPlaceholder = matcher2.find();
        while (hasColorPlaceholder || hasGradientPlaceholder) {
            int startIndex;
            String placeholder;
            if (!hasGradientPlaceholder) {
                result.addExtra((BaseComponent)Messages.colorToComponent(preResult, matcher.start(), isLegacy));
                hasColorPlaceholder = matcher.find();
                continue;
            }
            if (!hasColorPlaceholder) {
                placeholder = matcher2.group();
                result.addExtra((BaseComponent)Messages.gradientToComponent(placeholder, isLegacy));
                startIndex = matcher2.end();
                hasGradientPlaceholder = matcher2.find();
                if (hasGradientPlaceholder) {
                    result.addExtra(Messages.replaceLegacyColorCodes(preResult.substring(startIndex, matcher2.start())));
                    continue;
                }
                result.addExtra(Messages.replaceLegacyColorCodes(preResult.substring(startIndex, preResult.length())));
                continue;
            }
            if (matcher.start() < matcher2.start()) {
                result.addExtra((BaseComponent)Messages.colorToComponent(preResult, matcher.start(), isLegacy));
                hasColorPlaceholder = matcher.find();
                continue;
            }
            placeholder = matcher2.group();
            result.addExtra((BaseComponent)Messages.gradientToComponent(placeholder, isLegacy));
            startIndex = matcher2.end();
            hasGradientPlaceholder = matcher2.find();
            if (hasGradientPlaceholder) {
                if (matcher2.start() < matcher.start()) {
                    result.addExtra(Messages.replaceLegacyColorCodes(preResult.substring(startIndex, matcher2.start())));
                    continue;
                }
                result.addExtra(Messages.replaceLegacyColorCodes(preResult.substring(startIndex, matcher.start())));
                continue;
            }
            result.addExtra(Messages.replaceLegacyColorCodes(preResult.substring(startIndex, matcher.start())));
        }
        return result;
    }

    public static String replacePlaceholders(String message) {
        String res = message.replaceAll("%online%", String.valueOf(ProxyServer.getInstance().getPlayers().size())).replaceAll("%maxplayers%", String.valueOf(ProxyServer.getInstance().getOnlineCount()));
        if (ConfigManager.config.getBoolean("AdvancedNMotd.Configuration.Data")) {
            int online = ProxyServer.getInstance().getPlayers().size() * ConfigManager.data.getInt("Data.PlayerSpace") + ConfigManager.data.getInt("Data.ExtraOnlinePlayers");
            int maxPlayers = ConfigManager.data.getInt("Data.FakeMaxPlayers");
            if (ConfigManager.data.getBoolean("Data.OnlineIsBiggerThenSlotsProtection") && online > maxPlayers) {
                online = maxPlayers;
            }
            res = res.replaceAll("%fakeOnline%", String.valueOf(online)).replaceAll("%fakeMaxplayers%", String.valueOf(maxPlayers));
        }
        return res;
    }
}

