/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.papi.expansion.server;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import org.bukkit.Bukkit;

public final class ServerUtils {
    private String version = null;
    private String build = null;
    private String variant = null;
    private final Map<String, String> variants = new HashMap<String, String>();
    private Object craftServer = null;
    private Field tps = null;
    private boolean hasTpsMethod = false;

    public ServerUtils() {
        this.variants.put("org.spigotmc.SpigotConfig", "Spigot");
        this.variants.put("io.papermc.paper.configuration.ConfigurationLoaders", "Paper");
        this.variants.put("com.destroystokyo.paper.PaperConfig", "Paper");
        this.variants.put("com.tuinity.tuinity.config.TuinityConfig", "Tuinity");
        this.variants.put("gg.airplane.AirplaneConfig", "Airplane");
        this.variants.put("net.pl3x.purpur.PurpurConfig", "Purpur");
        this.resolveTPSHandler();
    }

    public String getServerVariant() {
        if (this.variant != null) {
            return this.variant;
        }
        for (Map.Entry<String, String> variant : this.variants.entrySet()) {
            try {
                Class.forName(variant.getKey());
                this.variant = variant.getValue();
                return this.variant;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        this.variant = "Unknown";
        return "Unknown";
    }

    public String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        this.version = Bukkit.getBukkitVersion().split("-")[0];
        return this.version;
    }

    public String getBuild() {
        if (this.build != null) {
            return this.build;
        }
        String[] buildParts = Bukkit.getVersion().split("-");
        switch (this.getServerVariant().toLowerCase(Locale.ROOT)) {
            case "spigot": 
            case "tuinity": 
            case "airplane": 
            case "purpur": {
                this.build = buildParts[0];
                return this.build;
            }
            case "paper": {
                if (buildParts.length >= 3) {
                    if (buildParts[2].contains(" ")) {
                        this.build = buildParts[2].substring(0, buildParts[2].indexOf(" "));
                        return this.build;
                    }
                    this.build = buildParts[2];
                    return this.build;
                }
                this.build = "Unknown";
                return "Unknown";
            }
        }
        this.build = "Unknown";
        return "Unknown";
    }

    public double[] getTps() {
        if (this.hasTpsMethod) {
            return Bukkit.getTPS();
        }
        if (this.craftServer == null || this.tps == null) {
            return new double[]{0.0, 0.0, 0.0};
        }
        try {
            return (double[])this.tps.get(this.craftServer);
        }
        catch (IllegalAccessException ignored) {
            return new double[]{0.0, 0.0, 0.0};
        }
    }

    private void resolveTPSHandler() {
        try {
            Bukkit.class.getMethod("getTPS", new Class[0]);
            this.hasTpsMethod = true;
        }
        catch (NoSuchMethodException ignored) {
            String mcVersion = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
            try {
                this.craftServer = this.getMajorVersion() >= 17 ? Class.forName("net.minecraft.server.MinecraftServer").getMethod("getServer", new Class[0]).invoke(null, new Object[0]) : Class.forName("net.minecraft.server." + mcVersion + ".MinecraftServer").getMethod("getServer", new Class[0]).invoke(null, new Object[0]);
                this.tps = this.craftServer.getClass().getField("recentTps");
            }
            catch (Exception ex) {
                PlaceholderAPIPlugin.getInstance().getLogger().warning("Could not resolve TPS handling!");
                ex.printStackTrace();
            }
        }
    }

    private int getMajorVersion() {
        Matcher matcher = Pattern.compile("\\(MC: (\\d)\\.(\\d+)\\.?(\\d+?)?\\)").matcher(Bukkit.getVersion());
        if (matcher.find()) {
            try {
                return Integer.parseInt(matcher.toMatchResult().group(2), 10);
            }
            catch (NumberFormatException ignored) {
                return -1;
            }
        }
        return -1;
    }
}

