/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.pht64kd;

import ch.ethz.globis.pht64kd.MaxKTreeI;
import clib.phtree.v11.nt.NodeTreeV11;

public class MaxKTree<T>
implements MaxKTreeI {
    private final long[] dummy;
    private final NodeTreeV11<T> tree;
    private final int depth;

    private MaxKTree(int dims, int depth) {
        this.tree = NodeTreeV11.create(dims * depth);
        this.dummy = new long[dims * depth];
        if (this.getKeyBitWidth() > 62) {
            System.err.println("Warning: dims=" + this.getKeyBitWidth());
        }
        this.depth = depth;
    }

    public static <T> MaxKTree<T> create(int dims, int depth) {
        return new MaxKTree<T>(dims, depth);
    }

    private long key2hcPos(long[] key) {
        long ret = 0L;
        for (int i = 0; i < key.length; ++i) {
            ret <<= this.depth;
            ret |= key[i];
        }
        return ret;
    }

    public T put(long[] key, T value) {
        return this.tree.put(this.key2hcPos(key), this.dummy, value);
    }

    public boolean insert(long ... key) {
        return this.tree.putB(this.key2hcPos(key), this.dummy);
    }

    public boolean contains(long ... key) {
        return this.tree.contains(this.key2hcPos(key), this.dummy);
    }

    public T get(long ... key) {
        return this.tree.get(this.key2hcPos(key), this.dummy);
    }

    public T remove(long ... key) {
        return this.tree.remove(this.key2hcPos(key));
    }

    public boolean delete(long[] key) {
        return this.tree.removeB(this.key2hcPos(key));
    }

    public String toStringTree() {
        return this.tree.toStringTree();
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    @Override
    public int getKeyBitWidth() {
        return this.tree.getKeyBitWidth();
    }

    @Override
    public Object getRoot() {
        return this.tree.getRoot();
    }
}

