/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.pht64kd;

import java.util.Arrays;
import java.util.Iterator;

public interface MaxKTreeHdI {
    public int size();

    public int getKeyBitWidth();

    public Object getRoot();

    public static class NtEntry<T> {
        private long[] key;
        private long[] kdKey;
        private T value;

        public NtEntry(long[] key, long[] kdKey, T value) {
            this.key = key;
            this.kdKey = kdKey;
            this.value = value;
        }

        public NtEntry(NtEntry<T> e) {
            this.key = e.getKey();
            this.kdKey = Arrays.copyOf(e.getKdKey(), e.getKdKey().length);
            this.value = e.getValue();
        }

        public long[] getKey() {
            return this.key;
        }

        public long[] getKdKey() {
            return this.kdKey;
        }

        public T getValue() {
            return this.value;
        }

        protected void set(long[] key, long[] kdKey, T value) {
            this.key = key;
            this.kdKey = kdKey;
            this.value = value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public String toString() {
            return Arrays.toString(this.key);
        }

        public long[] key() {
            return this.getKey();
        }

        public T value() {
            return this.getValue();
        }

        public void setKey(long[] key) {
            this.key = key;
        }
    }

    public static interface PhIterator64<T>
    extends Iterator<T> {
        public long[] nextKey();

        public long[] nextKdKey();

        public T nextValue();

        public NtEntry<T> nextEntry();

        public NtEntry<T> nextEntryReuse();

        public void reset(MaxKTreeHdI var1, long[] var2, long[] var3);

        public void reset(MaxKTreeHdI var1);
    }
}

