/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree;

import clib.phtree.PhEntry;
import java.util.Comparator;

public class PhEntryDist<T>
extends PhEntry<T> {
    public static final Comparator<PhEntryDist<?>> COMP = (o1, o2) -> {
        double d = o1.dist - o2.dist;
        return d > 0.0 ? 1 : (d < 0.0 ? -1 : 0);
    };
    private double dist;

    public PhEntryDist(long[] key, T value, double dist) {
        super(key, value);
        this.dist = dist;
    }

    public PhEntryDist(PhEntry<T> e, double dist) {
        super(e);
        this.dist = dist;
    }

    public PhEntryDist(PhEntryDist<T> e) {
        super(e);
        this.dist = e.dist();
    }

    public void setCopyKey(long[] key, T val, double dist) {
        System.arraycopy(key, 0, this.getKey(), 0, this.getKey().length);
        this.set(val, dist);
    }

    public void set(PhEntry<T> e, double dist) {
        super.setValue(e.getValue());
        System.arraycopy(e.getKey(), 0, this.getKey(), 0, this.getKey().length);
        this.dist = dist;
    }

    public void set(T val, double dist) {
        super.setValue(val);
        this.dist = dist;
    }

    public void clear() {
        this.dist = Double.MAX_VALUE;
    }

    public double dist() {
        return this.dist;
    }

    public void setDist(double dist) {
        this.dist = dist;
    }

    @Override
    public String toString() {
        return super.toString() + " dist=" + this.dist;
    }
}

