/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree;

import clib.phtree.PhDistance;
import clib.phtree.PhFilter;

public class PhFilterDistance
implements PhFilter {
    private static final long serialVersionUID = 1L;
    private long[] v;
    private PhDistance dist;
    private double maxDist;

    public void set(long[] v, PhDistance dist, double maxDist) {
        this.v = v;
        this.dist = dist;
        this.maxDist = maxDist;
    }

    public void setMaxDist(double maxDist) {
        this.maxDist = maxDist;
    }

    @Override
    public boolean isValid(long[] key) {
        return this.dist.dist(this.v, key) <= this.maxDist;
    }

    @Override
    public boolean isValid(int bitsToIgnore, long[] prefix) {
        long maskMin = -1L << bitsToIgnore;
        long maskMax = maskMin ^ 0xFFFFFFFFFFFFFFFFL;
        long[] buf = new long[prefix.length];
        for (int i = 0; i < buf.length; ++i) {
            long min = prefix[i] & maskMin;
            long max = prefix[i] | maskMax;
            buf[i] = min > this.v[i] ? min : (max < this.v[i] ? max : this.v[i]);
        }
        return this.dist.dist(this.v, buf) <= this.maxDist;
    }

    public PhDistance getDistance() {
        return this.dist;
    }

    public long[] getCenter() {
        return this.v;
    }

    public double getMaxDist() {
        return this.maxDist;
    }
}

