/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree;

import clib.phtree.PhEntry;
import clib.phtree.PhTree;
import clib.phtree.pre.PreProcessorRange;
import clib.phtree.util.PhIteratorBase;
import clib.phtree.util.PhTreeStats;
import java.util.Arrays;
import java.util.function.BiFunction;

public class PhTreeSolid<T>
implements Iterable<T> {
    private final int dims;
    private final PhTree<T> pht;
    private final PreProcessorRange pre;
    private final long[] qMIN;
    private final long[] qMAX;

    private PhTreeSolid(int dim) {
        this(PhTree.create(dim * 2));
    }

    public PhTreeSolid(PhTree<T> tree) {
        this.dims = tree.getDim() / 2;
        if (this.dims * 2 != tree.getDim()) {
            throw new IllegalArgumentException("The backing tree's DIM must be a multiple of 2");
        }
        this.pht = tree;
        this.pre = new PreProcessorRange.Simple();
        this.qMIN = new long[this.dims];
        Arrays.fill(this.qMIN, Long.MIN_VALUE);
        this.qMAX = new long[this.dims];
        Arrays.fill(this.qMAX, Long.MAX_VALUE);
    }

    public static <T> PhTreeSolid<T> wrap(PhTree<T> tree) {
        return new PhTreeSolid<T>(tree);
    }

    public static <T> PhTreeSolid<T> create(int dim) {
        return new PhTreeSolid<T>(dim);
    }

    public T put(long[] lower, long[] upper, T value) {
        long[] lVal = new long[lower.length * 2];
        this.pre.pre(lower, upper, lVal);
        return this.pht.put(lVal, value);
    }

    public T remove(long[] lower, long[] upper) {
        long[] lVal = new long[lower.length * 2];
        this.pre.pre(lower, upper, lVal);
        return this.pht.remove(lVal);
    }

    public boolean contains(long[] lower, long[] upper) {
        long[] lVal = new long[lower.length * 2];
        this.pre.pre(lower, upper, lVal);
        return this.pht.contains(lVal);
    }

    public T get(long[] lower, long[] upper) {
        long[] lVal = new long[lower.length * 2];
        this.pre.pre(lower, upper, lVal);
        return this.pht.get(lVal);
    }

    public T put(PhEntryS<T> e) {
        return this.put(e.lower(), e.upper(), e.value());
    }

    public T remove(PhEntryS<T> e) {
        return this.remove(e.lower(), e.upper());
    }

    public boolean contains(PhEntryS<T> e) {
        return this.contains(e.lower(), e.upper());
    }

    public PhQueryS<T> queryInclude(PhEntryS<T> e) {
        return this.queryInclude(e.lower(), e.upper());
    }

    public PhQueryS<T> queryIntersect(PhEntryS<T> e) {
        return this.queryIntersect(e.lower(), e.upper());
    }

    public PhQueryS<T> queryInclude(long[] lower, long[] upper) {
        long[] lUpp = new long[lower.length << 1];
        long[] lLow = new long[lower.length << 1];
        this.pre.pre(lower, lower, lLow);
        this.pre.pre(upper, upper, lUpp);
        return new PhQueryS(this.pht.query(lLow, lUpp), this.dims, this.pre, false);
    }

    public PhQueryS<T> queryIntersect(long[] lower, long[] upper) {
        long[] lUpp = new long[lower.length << 1];
        long[] lLow = new long[lower.length << 1];
        this.pre.pre(this.qMIN, lower, lLow);
        this.pre.pre(upper, this.qMAX, lUpp);
        return new PhQueryS(this.pht.query(lLow, lUpp), this.dims, this.pre, true);
    }

    @Override
    public PhIteratorS<T> iterator() {
        return new PhIteratorS(this.pht.queryExtent(), this.dims, this.pre);
    }

    public T update(long[] lo1, long[] up1, long[] lo2, long[] up2) {
        long[] pOld = new long[lo1.length << 1];
        long[] pNew = new long[lo1.length << 1];
        this.pre.pre(lo1, up1, pOld);
        this.pre.pre(lo2, up2, pNew);
        return this.pht.update(pOld, pNew);
    }

    public int size() {
        return this.pht.size();
    }

    public void clear() {
        this.pht.clear();
    }

    public int getDim() {
        return this.dims;
    }

    public PhTreeStats getStats() {
        return this.pht.getStats();
    }

    public String toStringTree() {
        return this.pht.toStringTree();
    }

    public T getOrDefault(long[] lower, long[] upper, T defaultValue) {
        T t = this.get(lower, upper);
        return t == null ? defaultValue : t;
    }

    public T putIfAbsent(long[] lower, long[] upper, T value) {
        long[] key = new long[lower.length * 2];
        this.pre.pre(lower, upper, key);
        return this.pht.putIfAbsent(key, value);
    }

    public boolean remove(long[] lower, long[] upper, T value) {
        long[] key = new long[lower.length * 2];
        this.pre.pre(lower, upper, key);
        return this.pht.remove(key, value);
    }

    public boolean replace(long[] lower, long[] upper, T oldValue, T newValue) {
        long[] key = new long[lower.length * 2];
        this.pre.pre(lower, upper, key);
        return this.pht.replace(key, oldValue, newValue);
    }

    public T replace(long[] lower, long[] upper, T value) {
        long[] key = new long[lower.length * 2];
        this.pre.pre(lower, upper, key);
        return this.pht.replace(key, value);
    }

    public T computeIfAbsent(long[] lower, long[] upper, BiFunction<long[], long[], ? extends T> mappingFunction) {
        long[] key = new long[lower.length * 2];
        this.pre.pre(lower, upper, key);
        return (T)this.pht.computeIfAbsent(key, longs -> mappingFunction.apply(lower, upper));
    }

    public T computeIfPresent(long[] lower, long[] upper, SolidBiFunction<long[], ? super T, ? extends T> remappingFunction) {
        long[] key = new long[lower.length * 2];
        this.pre.pre(lower, upper, key);
        return (T)this.pht.computeIfPresent(key, (longs, value) -> remappingFunction.apply(lower, upper, (Object)value));
    }

    public T compute(long[] lower, long[] upper, SolidBiFunction<long[], ? super T, ? extends T> remappingFunction) {
        long[] key = new long[lower.length * 2];
        this.pre.pre(lower, upper, key);
        return (T)this.pht.compute(key, (longs, value) -> remappingFunction.apply(lower, upper, (Object)value));
    }

    public static class PhEntryS<T> {
        private final long[] lower;
        private final long[] upper;
        private T value;

        public PhEntryS(long[] lower, long[] upper, T value) {
            this.lower = lower;
            this.upper = upper;
            this.value = value;
        }

        public PhEntryS(PhEntryS<T> e) {
            this.lower = Arrays.copyOf(e.lower, e.lower.length);
            this.upper = Arrays.copyOf(e.upper, e.upper.length);
            this.value = e.value;
        }

        public T value() {
            return this.value;
        }

        public long[] lower() {
            return this.lower;
        }

        public long[] upper() {
            return this.upper;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PhEntryS)) {
                return false;
            }
            PhEntryS e = (PhEntryS)obj;
            return Arrays.equals(this.lower, e.lower) && Arrays.equals(this.upper, e.upper);
        }

        public int hashCode() {
            return Arrays.hashCode(this.lower) ^ Arrays.hashCode(this.upper);
        }

        public String toString() {
            return "{" + Arrays.toString(this.lower) + "," + Arrays.toString(this.upper) + "} => " + this.value;
        }
    }

    public static class PhQueryS<T>
    extends PhIteratorS<T> {
        private final long[] lLow;
        private final long[] lUpp;
        private final PhTree.PhQuery<T> q;
        private final long[] qMIN;
        private final long[] qMAX;
        private final boolean intersect;

        private PhQueryS(PhTree.PhQuery<T> iter, int dims, PreProcessorRange pre, boolean intersect) {
            super(iter, dims, pre);
            this.q = iter;
            this.qMIN = new long[dims];
            Arrays.fill(this.qMIN, Long.MIN_VALUE);
            this.qMAX = new long[dims];
            Arrays.fill(this.qMAX, Long.MAX_VALUE);
            this.intersect = intersect;
            this.lLow = new long[dims * 2];
            this.lUpp = new long[dims * 2];
        }

        public void reset(long[] lower, long[] upper) {
            if (this.intersect) {
                this.pre.pre(this.qMIN, lower, this.lLow);
                this.pre.pre(upper, this.qMAX, this.lUpp);
            } else {
                this.pre.pre(lower, lower, this.lLow);
                this.pre.pre(upper, upper, this.lUpp);
            }
            this.q.reset(this.lLow, this.lUpp);
        }
    }

    public static class PhIteratorS<T>
    implements PhIteratorBase<T, PhEntryS<T>> {
        private final PhTree.PhIterator<T> iter;
        private final int dims;
        protected final PreProcessorRange pre;
        private final PhEntryS<T> buffer;

        private PhIteratorS(PhTree.PhIterator<T> iter, int dims, PreProcessorRange pre) {
            this.iter = iter;
            this.dims = dims;
            this.pre = pre;
            this.buffer = new PhEntryS<Object>(new long[dims], new long[dims], null);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public T next() {
            return this.nextValue();
        }

        @Override
        public T nextValue() {
            return (T)this.iter.nextValue();
        }

        @Override
        public PhEntryS<T> nextEntry() {
            long[] lower = new long[this.dims];
            long[] upper = new long[this.dims];
            Object pvEntry = this.iter.nextEntryReuse();
            this.pre.post(((PhEntry)pvEntry).getKey(), lower, upper);
            return new PhEntryS(lower, upper, ((PhEntry)pvEntry).getValue());
        }

        @Override
        public PhEntryS<T> nextEntryReuse() {
            Object pvEntry = this.iter.nextEntryReuse();
            this.pre.post(((PhEntry)pvEntry).getKey(), ((PhEntryS)this.buffer).lower, ((PhEntryS)this.buffer).upper);
            this.buffer.setValue(((PhEntry)pvEntry).getValue());
            return this.buffer;
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    @FunctionalInterface
    public static interface SolidBiFunction<T, U, R> {
        public R apply(T var1, T var2, U var3);
    }
}

