/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.pre;

import clib.phtree.util.BitTools;

public interface PreProcessorRangeF {
    public void pre(double[] var1, double[] var2, long[] var3);

    public void pre(double[] var1, int var2, double[] var3, int var4, long[] var5);

    public void post(long[] var1, double[] var2, double[] var3);

    public static class ShiftMulIPP
    implements PreProcessorRangeF {
        private final int dims;
        private final double mul;
        private final double div;
        private final double shift;

        public ShiftMulIPP(int dims, double preMul, double preShift) {
            this.dims = dims;
            this.mul = preMul;
            this.div = 1.0 / preMul;
            this.shift = preShift;
        }

        @Override
        public void pre(double[] raw1, double[] raw2, long[] pre) {
            for (int i = 0; i < this.dims; ++i) {
                pre[i] = (long)((raw1[i] + this.shift) * this.mul);
                pre[i + this.dims] = (long)((raw2[i] + this.shift) * this.mul);
            }
        }

        @Override
        public void pre(double[] raw1, int pos1, double[] raw2, int pos2, long[] pre) {
            for (int i = 0; i < this.dims; ++i) {
                pre[i] = (long)((raw1[pos1 + i] + this.shift) * this.mul);
                pre[i + this.dims] = (long)((raw2[pos2 + i] + this.shift) * this.mul);
            }
        }

        @Override
        public void post(long[] pre, double[] post1, double[] post2) {
            for (int i = 0; i < this.dims; ++i) {
                post1[i] = (double)pre[i] * this.div - this.shift;
                post2[i] = (double)pre[i + this.dims] * this.div - this.shift;
            }
        }
    }

    public static class ShiftIEEE
    implements PreProcessorRangeF {
        private final int dims;
        private final double shift;

        public ShiftIEEE(int dims, double preShift) {
            this.dims = dims;
            this.shift = preShift;
        }

        @Override
        public void pre(double[] raw1, double[] raw2, long[] pre) {
            for (int i = 0; i < this.dims; ++i) {
                pre[i] = BitTools.toSortableLong(raw1[i] + this.shift);
                pre[i + this.dims] = BitTools.toSortableLong(raw2[i] + this.shift);
            }
        }

        @Override
        public void pre(double[] raw1, int pos1, double[] raw2, int pos2, long[] pre) {
            for (int i = 0; i < this.dims; ++i) {
                pre[i] = BitTools.toSortableLong(raw1[pos1 + i] + this.shift);
                pre[i + this.dims] = BitTools.toSortableLong(raw2[pos2 + i] + this.shift);
            }
        }

        @Override
        public void post(long[] pre, double[] post1, double[] post2) {
            for (int i = 0; i < this.dims; ++i) {
                post1[i] = BitTools.toDouble(pre[i]) - this.shift;
                post2[i] = BitTools.toDouble(pre[i + this.dims]) - this.shift;
            }
        }
    }

    public static class Multiply
    implements PreProcessorRangeF {
        private final int dims;
        private final double mul;
        private final double div;

        public Multiply(int dims, double pre) {
            this.dims = dims;
            this.mul = pre;
            this.div = 1.0 / pre;
        }

        @Override
        public void pre(double[] raw1, double[] raw2, long[] pre) {
            for (int i = 0; i < this.dims; ++i) {
                pre[i] = (long)(raw1[i] * this.mul);
                pre[i + this.dims] = (long)(raw2[i] * this.mul);
            }
        }

        @Override
        public void pre(double[] raw1, int pos1, double[] raw2, int pos2, long[] pre) {
            for (int i = 0; i < this.dims; ++i) {
                pre[i] = (long)(raw1[pos1 + i] * this.mul);
                pre[i + this.dims] = (long)(raw2[pos2 + i] * this.mul);
            }
        }

        @Override
        public void post(long[] pre, double[] post1, double[] post2) {
            for (int i = 0; i < this.dims; ++i) {
                post1[i] = (double)pre[i] * this.div;
                post2[i] = (double)pre[i + this.dims] * this.div;
            }
        }
    }

    public static class IEEE
    implements PreProcessorRangeF {
        private final int dims;

        public IEEE(int dims) {
            this.dims = dims;
        }

        @Override
        public void pre(double[] raw1, double[] raw2, long[] pre) {
            int pDIM = raw1.length;
            for (int d = 0; d < pDIM; ++d) {
                pre[d] = BitTools.toSortableLong(raw1[d]);
                pre[d + pDIM] = BitTools.toSortableLong(raw2[d]);
            }
        }

        @Override
        public void pre(double[] raw1, int pos1, double[] raw2, int pos2, long[] pre) {
            for (int d = 0; d < this.dims; ++d) {
                pre[d] = BitTools.toSortableLong(raw1[pos1 + d]);
                pre[d + this.dims] = BitTools.toSortableLong(raw2[pos2 + d]);
            }
        }

        @Override
        public void post(long[] pre, double[] post1, double[] post2) {
            int pDIM = post1.length;
            for (int d = 0; d < pDIM; ++d) {
                post1[d] = BitTools.toDouble(pre[d]);
                post2[d] = BitTools.toDouble(pre[d + pDIM]);
            }
        }
    }
}

