/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.util;

public class BitsByte {
    public static final int UNIT_3 = 3;
    public static final int UNIT_BITS = 8;
    public static final int UNIT_0x07 = 7;
    public static final int UNIT_0xFF = 255;
    public static final int UNIT_0xFF00 = 65280;

    public static long readArray(byte[] ba, int offsetBit, int entryLen) {
        int pA = offsetBit >>> 3;
        int startBit = 8 - (offsetBit & 7);
        long ret = 0L;
        int bitsRead = 0;
        while (bitsRead < entryLen) {
            int mask = (1 << startBit) - 1;
            if (bitsRead + startBit > entryLen) {
                int bitsToIgnore = bitsRead + startBit - entryLen;
                int mask2 = (1 << bitsToIgnore) - 1;
                bitsRead += 100000;
                ret <<= 8 - bitsToIgnore;
                ret |= (long)((ba[pA] & (mask &= ~mask2)) >>> bitsToIgnore);
            } else {
                bitsRead += startBit;
                ret <<= 8;
                ret |= (long)(ba[pA] & mask);
            }
            startBit = 8;
            ++pA;
        }
        return ret;
    }

    public static void writeArray(byte[] ba, int offsetBit, int entryLen, long val) {
        int bitsToWrite;
        int pA = offsetBit >>> 3;
        int startBit = 8 - (offsetBit & 7);
        for (int bitsWritten = 0; bitsWritten < entryLen; bitsWritten += bitsToWrite) {
            int eraseMask = (1 << startBit) - 1;
            bitsToWrite = startBit;
            if (bitsWritten + bitsToWrite > entryLen) {
                int bitsToIgnore = bitsWritten + startBit - entryLen;
                int mask2 = (1 << bitsToIgnore) - 1;
                eraseMask &= ~mask2;
                bitsToWrite -= bitsToIgnore;
            }
            int n = pA;
            ba[n] = (byte)(ba[n] & ~eraseMask);
            int toShift = entryLen - (bitsWritten + startBit);
            long infTemp = toShift > 0 ? val >>> toShift : val << -toShift;
            long maskToCutOfHeadingBits = (1L << startBit) - 1L;
            int n2 = pA++;
            ba[n2] = (byte)((long)ba[n2] | (infTemp &= maskToCutOfHeadingBits));
            startBit = 8;
        }
    }

    public static void insertBits(byte[] ba, int start, int nBits) {
        if (nBits == 0) {
            return;
        }
        if (nBits < 0) {
            throw new IllegalArgumentException();
        }
        int bitsToShift = ba.length * 8 - start - nBits;
        for (int i = 0; i < bitsToShift; ++i) {
            int srcBit = ba.length * 8 - nBits - i - 1;
            int trgBit = ba.length * 8 - i - 1;
            BitsByte.setBit(ba, trgBit, BitsByte.getBit(ba, srcBit));
        }
    }

    public static void removeBits(byte[] ba, int start, int nBits) {
        if (nBits == 0) {
            return;
        }
        if (nBits < 0) {
            throw new IllegalArgumentException();
        }
        BitsByte.copyBitsLeft(ba, start + nBits, ba, start, ba.length * 8 - start - nBits);
    }

    public static void copyBitsLeft(byte[] src, int posSrc, byte[] trg, int posTrg) {
        int len = src.length * 8 - posSrc;
        BitsByte.copyBitsLeft(src, posSrc, trg, posTrg, len);
    }

    public static void copyBitsLeft(byte[] src, int posSrc, byte[] trg, int posTrg, int len) {
        if (len == 0) {
            return;
        }
        boolean DBG = false;
        if (posSrc < 0 || posTrg < 0) {
            throw new IllegalArgumentException("s=" + posSrc + " t=" + posTrg);
        }
        if (posSrc + len > src.length * 8 || posTrg + len > trg.length * 8) {
            throw new IllegalArgumentException("s=" + posSrc + " t=" + posTrg + " len=" + len);
        }
        long buf = 0L;
        int psA = posSrc >>> 3;
        int startBitS = 8 - (posSrc & 7);
        int ptA = posTrg >>> 3;
        int startBitT_lr = posTrg & 7;
        int startBitT = 8 - (posTrg & 7);
        int bitsInBuffer = 0;
        int bitsToCopy = len;
        int bitsRead = 0;
        int bitsWritten = 0;
        if (startBitS != 8) {
            int mask = (1 << startBitS) - 1;
            buf |= (long)(src[psA] & mask);
            bitsInBuffer = startBitS;
            bitsRead = startBitS;
            ++psA;
            if (bitsRead > bitsToCopy) {
                buf >>>= bitsRead - bitsToCopy;
                bitsRead = bitsToCopy;
                bitsInBuffer = bitsToCopy;
            }
        }
        int eraseMask = (1 << startBitT) - 1;
        eraseMask ^= 0xFFFFFFFF;
        int bitsToWriteThisRound = startBitT < len ? startBitT : len;
        boolean readingFinished = false;
        boolean writingFinished = false;
        while (!readingFinished || !writingFinished) {
            if (bitsRead < bitsToCopy) {
                buf <<= 8;
                buf |= (long)(src[psA] & 0xFF);
                bitsInBuffer += 8;
                if ((bitsRead += 8) >= bitsToCopy) {
                    readingFinished = true;
                    if (bitsRead > bitsToCopy) {
                        int d = bitsRead - bitsToCopy;
                        buf >>>= d;
                        bitsRead -= d;
                        bitsInBuffer -= d;
                    }
                }
            } else {
                readingFinished = true;
            }
            if (startBitT_lr + bitsInBuffer < 8) break;
            long buf2 = buf;
            buf2 >>>= bitsInBuffer - bitsToWriteThisRound;
            int n = ptA;
            trg[n] = (byte)(trg[n] & eraseMask);
            startBitT = 8;
            int n2 = ptA++;
            trg[n2] = (byte)((long)trg[n2] | (buf2 &= 0xFFL));
            eraseMask = 0;
            bitsInBuffer -= bitsToWriteThisRound;
            bitsToWriteThisRound = 8;
            ++psA;
            if (bitsToCopy - (bitsWritten += bitsToWriteThisRound) > 8) continue;
            writingFinished = true;
        }
        if (bitsWritten < bitsToCopy) {
            int bitsToWrite = bitsToCopy - bitsWritten;
            if (bitsWritten == 0) {
                eraseMask = 255 >>> bitsToWrite | 0xFF00;
                eraseMask >>>= 8 - startBitT;
                buf <<= startBitT - bitsToWrite;
            } else {
                eraseMask = 255 >>> bitsToWrite;
                buf <<= 8 - bitsToWrite;
            }
            int n = ptA;
            trg[n] = (byte)(trg[n] & eraseMask);
            int n3 = ptA;
            trg[n3] = (byte)((long)trg[n3] | buf);
        }
    }

    public static void copyBitsRight(byte[] src, int posSrc, byte[] trg, int posTrg, int len) {
        if (len == 0) {
            return;
        }
        boolean DBG = false;
        if (posSrc < 0 || posTrg < 0) {
            throw new IllegalArgumentException("s=" + posSrc + " t=" + posTrg);
        }
        if (posSrc + len > src.length * 8 || posTrg + len > trg.length * 8) {
            throw new IllegalArgumentException("s=" + posSrc + " t=" + posTrg + " len=" + len);
        }
        long buf = 0L;
        int startBitS = 8 - (posSrc & 7);
        int startBitT_lr = posTrg & 7;
        int startBitT = 8 - (posTrg & 7);
        boolean bitsInBuffer = false;
        int bitsToCopy = len;
        boolean bitsRead = false;
        boolean bitsWritten = false;
        int psA = posSrc + len - 1 >>> 3;
        int ptA = posTrg + len - 1 >>> 3;
        int endBitS = posSrc + len - 1 & 7;
        int endBitT = posTrg + len - 1 & 7;
        if (endBitS != 7 && endBitS + 1 - bitsToCopy >= 0) {
            buf = src[psA] & 0xFF;
            long eraseMask = 255 >>> len | 0xFF00;
            buf >>>= endBitT - endBitS;
            int n = ptA;
            trg[n] = (byte)((long)trg[n] & eraseMask);
            int n2 = ptA;
            trg[n2] = (byte)((long)trg[n2] | (buf &= (eraseMask >>>= endBitT + 1 - len) ^ 0xFFFFFFFFFFFFFFFFL));
            return;
        }
        throw new RuntimeException();
    }

    public static boolean getBit(byte[] ba, int posBit) {
        int pA = posBit >>> 3;
        return ((long)ba[pA] & 1L << 7 - (posBit &= 7)) != 0L;
    }

    public static void setBit(byte[] ba, int posBit, boolean b) {
        int pA = posBit >>> 3;
        posBit &= 7;
        if (b) {
            int n = pA;
            ba[n] = (byte)((long)ba[n] | 1L << 7 - posBit);
        } else {
            int n = pA;
            ba[n] = (byte)((long)ba[n] & (1L << 7 - posBit ^ 0xFFFFFFFFFFFFFFFFL));
        }
    }

    public static int binarySearch(byte[] ba, int startBit, int nValues, int val, int valWidth) {
        int min = 0;
        int max = nValues - 1;
        while (min <= max) {
            int mid = min + max >>> 1;
            long midVal = BitsByte.readArray(ba, mid * valWidth + startBit, valWidth);
            if (midVal < (long)val) {
                min = mid + 1;
                continue;
            }
            if (midVal > (long)val) {
                max = mid - 1;
                continue;
            }
            return mid;
        }
        return -(min + 1);
    }

    public static String toBinary(byte[] ba) {
        StringBuilder sb = new StringBuilder();
        for (byte l : ba) {
            for (int i = 0; i < 8; ++i) {
                long mask = 1L << (int)((long)(8 - i - 1));
                if (((long)l & mask) != 0L) {
                    sb.append("1");
                    continue;
                }
                sb.append("0");
            }
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toBinary(long l) {
        int DEPTH = 32;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 32; ++i) {
            long mask = 1L << (int)((long)(32 - i - 1));
            if ((l & mask) != 0L) {
                sb.append("1");
            } else {
                sb.append("0");
            }
            if (i % 8 != 0) continue;
            sb.append('.');
        }
        return sb.toString();
    }
}

