/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.util;

import clib.phtree.PhTreeHelper;
import clib.phtree.util.BitTools;
import clib.phtree.util.Bits;
import clib.phtree.util.unsynced.LongArrayOps;
import java.util.Arrays;

public class BitsLong
extends LongArrayOps {
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    static final int UNIT_3 = 6;
    static final int UNIT_BITS = 64;
    private static final int UNIT_0x1F = 63;
    private static final long UNIT_0xFF = -1L;
    private static final long UNIT_0x8000 = Long.MIN_VALUE;
    private static final int BYTES_PER_UNIT = 8;
    static int statACreate = 0;
    static int statAExpand = 0;
    static int statATrim = 0;
    static int statOldRightShift = 0;
    static int statOldRightShiftTime = 0;
    public static final ArrayPool POOL = new ArrayPool(PhTreeHelper.ARRAY_POOLING_MAX_ARRAY_SIZE, PhTreeHelper.ARRAY_POOLING_POOL_SIZE);

    public static int calcArraySize(int nBits) {
        int arraySize = nBits + PhTreeHelper.ALLOC_BATCH_SIZE_LONG >>> 6;
        int size = PhTreeHelper.ALLOC_BATCH_SIZE;
        arraySize = arraySize / size * size;
        return arraySize;
    }

    public static long[] arrayExpand(long[] oldA, int newSizeBits) {
        long[] newA = POOL.getArray(BitsLong.calcArraySize(newSizeBits));
        if (newSizeBits > 0) {
            System.arraycopy(oldA, 0, newA, 0, oldA.length);
        }
        POOL.offer(oldA);
        ++statAExpand;
        return newA;
    }

    public static long[] arrayCreate(int nBits) {
        long[] newA = POOL.getArray(BitsLong.calcArraySize(nBits));
        ++statACreate;
        return newA;
    }

    public static long[] arrayReplace(long[] oldA, long[] newA) {
        POOL.offer(oldA);
        return newA;
    }

    public static long[] arrayClone(long[] oldA) {
        long[] newA = POOL.getArray(oldA.length);
        System.arraycopy(oldA, 0, newA, 0, oldA.length);
        ++statACreate;
        return newA;
    }

    public static long[] arrayEnsureSize(long[] oldA, int requiredBits) {
        if (BitsLong.isCapacitySufficient(oldA, requiredBits)) {
            return oldA;
        }
        return BitsLong.arrayExpand(oldA, requiredBits);
    }

    public static boolean isCapacitySufficient(long[] a, int requiredBits) {
        return a.length * 64 >= requiredBits;
    }

    public static long[] arrayTrim(long[] oldA, int requiredBits) {
        int reqSize = BitsLong.calcArraySize(requiredBits);
        if (oldA.length == reqSize) {
            return oldA;
        }
        if (reqSize == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] newA = POOL.getArray(reqSize);
        System.arraycopy(oldA, 0, newA, 0, reqSize);
        POOL.offer(oldA);
        ++statATrim;
        return newA;
    }

    public static int arraySizeInByte(long[] ba) {
        return ba.length * 8;
    }

    public static int arraySizeInByte(int arrayLength) {
        return arrayLength * 8;
    }

    public static String toBinary(long l) {
        return BitsLong.toBinary(l, 64);
    }

    public static String toBinary(long l, int DEPTH) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < DEPTH; ++i) {
            long mask = 1L << (int)((long)(DEPTH - i - 1));
            if ((l & mask) != 0L) {
                sb.append("1");
            } else {
                sb.append("0");
            }
            if ((i + 1) % 8 == 0 && i + 1 < DEPTH) {
                sb.append('.');
            }
            mask >>>= 1;
        }
        return sb.toString();
    }

    public static String toBinary(long[] la, int DEPTH) {
        StringBuilder sb = new StringBuilder();
        for (long l : la) {
            sb.append(BitsLong.toBinary(l, DEPTH));
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toBinary(int[] la, int DEPTH) {
        StringBuilder sb = new StringBuilder();
        int[] nArray = la;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long l = nArray[i];
            sb.append(BitsLong.toBinary(l, DEPTH));
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toBinary(long[] ba) {
        StringBuilder sb = new StringBuilder();
        for (long l : ba) {
            sb.append(BitsLong.toBinary(l, 64));
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toBinary(double[] ba) {
        StringBuilder sb = new StringBuilder();
        for (double d : ba) {
            sb.append(BitsLong.toBinary(BitTools.toSortableLong(d), 64));
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String getStats() {
        return "Array create: " + Bits.statACreate + "  exp:" + Bits.statAExpand + "  trm:" + Bits.statATrim + "  oldRS:" + Bits.statOldRightShift + " / " + Bits.statOldRightShiftTime;
    }

    public static class ArrayPool {
        private final int maxArraySize;
        private final int maxArrayCount;
        long[][][] pool;
        int[] poolSize;
        int[] poolStatsNew;

        ArrayPool(int maxArraySize, int maxArrayCount) {
            this.maxArraySize = maxArraySize;
            this.maxArrayCount = maxArrayCount;
            this.pool = new long[maxArraySize + 1][maxArrayCount][];
            this.poolSize = new int[maxArraySize + 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long[] getArray(int size) {
            if (size == 0) {
                return EMPTY_LONG_ARRAY;
            }
            if (PhTreeHelper.ARRAY_POOLING) {
                if (size > this.maxArraySize) {
                    return new long[size];
                }
                ArrayPool arrayPool = this;
                synchronized (arrayPool) {
                    int ps = this.poolSize[size];
                    if (ps > 0) {
                        int n = size;
                        this.poolSize[n] = this.poolSize[n] - 1;
                        long[] ret = this.pool[size][ps - 1];
                        Arrays.fill(ret, 0L);
                        return ret;
                    }
                }
            }
            return new long[size];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void offer(long[] a) {
            if (PhTreeHelper.ARRAY_POOLING) {
                int size = a.length;
                if (size == 0 || size > this.maxArraySize) {
                    return;
                }
                ArrayPool arrayPool = this;
                synchronized (arrayPool) {
                    int ps = this.poolSize[size];
                    if (ps < this.maxArrayCount) {
                        this.pool[size][ps] = a;
                        int n = size;
                        this.poolSize[n] = this.poolSize[n] + 1;
                    }
                }
            }
        }

        public String print() {
            String r = "";
            int total = 0;
            for (int i = 0; i < this.poolSize.length; ++i) {
                r = r + "" + i + ":" + this.poolSize[i] + " ";
                total += i * this.poolSize[i];
            }
            return r;
        }
    }
}

