/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.util;

import clib.phtree.util.StringBuilderLn;
import java.util.Arrays;

public final class PhTreeStats {
    private final int bitWidth;
    public int nNodes;
    public int nAHC;
    public int nNtNodes;
    public int nNT;
    public int nTotalChildren;
    public long size;
    public int q_totalDepth;
    public int[] q_nPostFixN;
    public int[] infixHist = new int[64];
    public int[] nodeDepthHist = new int[64];
    public int[] nodeSizeLogHist = new int[32];

    public PhTreeStats() {
        this(64);
    }

    public PhTreeStats(int bitWidth) {
        this.bitWidth = bitWidth;
        this.q_nPostFixN = new int[bitWidth];
    }

    public String toString() {
        StringBuilderLn r = new StringBuilderLn();
        r.appendLn("  nNodes = " + this.nNodes);
        r.appendLn("  avgNodeDepth = " + (double)this.q_totalDepth / (double)this.nNodes);
        r.appendLn("  AHC=" + this.nAHC + "  NI=" + this.nNT + "  nNtNodes=" + this.nNtNodes);
        double apl = this.getAvgPostlen(r);
        r.appendLn("  avgPostLen = " + apl + " (" + ((double)this.bitWidth - apl) + ")");
        return r.toString();
    }

    public String toStringHist() {
        StringBuilderLn r = new StringBuilderLn();
        r.appendLn("  infixLen      = " + Arrays.toString(this.infixHist));
        r.appendLn("  nodeSizeLog   = " + Arrays.toString(this.nodeSizeLogHist));
        r.appendLn("  nodeDepthHist = " + Arrays.toString(this.nodeDepthHist));
        r.appendLn("  depthHist     = " + Arrays.toString(this.q_nPostFixN));
        return r.toString();
    }

    public double getAvgPostlen(StringBuilderLn r) {
        long total = 0L;
        int nEntry = 0;
        for (int i = 0; i < this.bitWidth; ++i) {
            if (r != null) {
                // empty if block
            }
            total += (long)(this.bitWidth - i) * (long)this.q_nPostFixN[i];
            nEntry += this.q_nPostFixN[i];
        }
        return (double)total / (double)nEntry;
    }

    public int getNodeCount() {
        return this.nNodes;
    }

    public int getAhcCount() {
        return this.nAHC;
    }

    public int getNtInternalNodeCount() {
        return this.nNtNodes;
    }

    public int getNtCount() {
        return this.nNT;
    }

    public long getCalculatedMemSize() {
        return this.size;
    }

    public int getBitDepth() {
        return this.bitWidth;
    }
}

