/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.util;

import clib.phtree.PhTreeHelper;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

public class RefsByte {
    private static final byte[] EMPTY_REF_ARRAY = new byte[0];
    private static final ArrayPoolN POOL = new ArrayPoolN(PhTreeHelper.ARRAY_POOLING_MAX_ARRAY_SIZE, PhTreeHelper.ARRAY_POOLING_POOL_SIZE);

    private RefsByte() {
    }

    private static int calcArraySize(int nLong) {
        return nLong + 7 & 0xFFFFFFF8;
    }

    public static byte[] arrayCreate(int size) {
        return POOL.getArray(RefsByte.calcArraySize(size));
    }

    public static byte[] arrayReplace(byte[] oldA, byte[] newA) {
        if (oldA != null) {
            POOL.offer(oldA);
        }
        return newA;
    }

    public static byte[] arrayClone(byte[] oldA) {
        byte[] newA = RefsByte.arrayCreate(oldA.length);
        RefsByte.arraycopy(oldA, 0, newA, 0, oldA.length);
        return newA;
    }

    public static byte[] insertSpaceAtPos(byte[] values, int pos, int requiredSize) {
        byte[] dst = values;
        if (requiredSize > values.length) {
            dst = RefsByte.arrayCreate(requiredSize);
            RefsByte.copyRight(values, 0, dst, 0, pos);
        }
        RefsByte.copyRight(values, pos, dst, pos + 1, requiredSize - 1 - pos);
        return dst;
    }

    public static byte[] removeSpaceAtPos(byte[] values, int pos, int requiredSize) {
        int reqSize = RefsByte.calcArraySize(requiredSize);
        byte[] dst = values;
        if (reqSize < values.length) {
            dst = POOL.getArray(reqSize);
            RefsByte.copyLeft(values, 0, dst, 0, pos);
        }
        if (pos < values.length - 1) {
            RefsByte.copyLeft(values, pos + 1, dst, pos, requiredSize - pos);
        }
        return dst;
    }

    private static void copyLeft(byte[] src, int srcPos, byte[] dst, int dstPos, int len) {
        if (len >= 7) {
            System.arraycopy(src, srcPos, dst, dstPos, len);
        } else {
            for (int i = 0; i < len; ++i) {
                dst[dstPos + i] = src[srcPos + i];
            }
        }
    }

    private static void copyRight(byte[] src, int srcPos, byte[] dst, int dstPos, int len) {
        if (len >= 7) {
            System.arraycopy(src, srcPos, dst, dstPos, len);
        } else {
            for (int i = len - 1; i >= 0; --i) {
                dst[dstPos + i] = src[srcPos + i];
            }
        }
    }

    public static void writeArray(byte[] src, byte[] dst, int dstPos) {
        RefsByte.arraycopy(src, 0, dst, dstPos, src.length);
    }

    public static void writeArray(byte[] src, int srcPos, byte[] dst, int dstPos, int length) {
        RefsByte.arraycopy(src, srcPos, dst, dstPos, length);
    }

    public static void readArray(byte[] src, int srcPos, byte[] dst) {
        RefsByte.arraycopy(src, srcPos, dst, 0, dst.length);
    }

    public static byte[] insertArray(byte[] oldA, byte[] insertA, int dstPos) {
        byte[] ret = RefsByte.arrayCreate(oldA.length + insertA.length);
        RefsByte.arraycopy(oldA, 0, ret, 0, dstPos);
        RefsByte.arraycopy(insertA, 0, ret, dstPos, insertA.length);
        RefsByte.arraycopy(oldA, dstPos, ret, dstPos + insertA.length, oldA.length - dstPos);
        POOL.offer(oldA);
        return ret;
    }

    public static byte[] arrayRemove(byte[] oldA, int dstPos, int length) {
        byte[] ret = RefsByte.arrayCreate(oldA.length - length);
        RefsByte.arraycopy(oldA, 0, ret, 0, dstPos);
        RefsByte.arraycopy(oldA, dstPos + length, ret, dstPos, ret.length - dstPos);
        POOL.offer(oldA);
        return ret;
    }

    public static void arraycopy(byte[] src, int srcPos, byte[] dst, int dstPos, int len) {
        if (len < 10) {
            for (int i = 0; i < len; ++i) {
                dst[dstPos + i] = src[srcPos + i];
            }
        } else {
            System.arraycopy(src, srcPos, dst, dstPos, len);
        }
    }

    public static void write(byte[] a, ObjectOutput out) throws IOException {
        out.writeInt(a.length);
        for (int i = 0; i < a.length; ++i) {
            out.writeByte(a[i]);
        }
    }

    public static byte[] read(ObjectInput in) throws IOException {
        int size = in.readInt();
        byte[] ret = POOL.getArray(size);
        in.readFully(ret);
        return ret;
    }

    private static class ArrayPoolN {
        private final int maxArraySize;
        private final int maxArrayCount;
        byte[][][] pool;
        int[] poolSize;

        ArrayPoolN(int maxArraySize, int maxArrayCount) {
            this.maxArraySize = maxArraySize;
            this.maxArrayCount = maxArrayCount;
            this.pool = new byte[maxArraySize + 1][maxArrayCount][];
            this.poolSize = new int[maxArraySize + 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        byte[] getArray(int size) {
            if (size == 0) {
                return EMPTY_REF_ARRAY;
            }
            if (size > this.maxArraySize || !PhTreeHelper.ARRAY_POOLING) {
                return new byte[size];
            }
            ArrayPoolN arrayPoolN = this;
            synchronized (arrayPoolN) {
                int ps = this.poolSize[size];
                if (ps > 0) {
                    int n = size;
                    this.poolSize[n] = this.poolSize[n] - 1;
                    byte[] ret = this.pool[size][ps - 1];
                    Arrays.fill(ret, (byte)0);
                    return ret;
                }
            }
            return new byte[size];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void offer(byte[] a) {
            int size = a.length;
            if (size == 0 || size > this.maxArraySize || !PhTreeHelper.ARRAY_POOLING) {
                return;
            }
            ArrayPoolN arrayPoolN = this;
            synchronized (arrayPoolN) {
                int ps = this.poolSize[size];
                if (ps < this.maxArrayCount) {
                    this.pool[size][ps] = a;
                    int n = size;
                    this.poolSize[n] = this.poolSize[n] + 1;
                }
            }
        }
    }
}

