/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.util.unsynced;

import clib.phtree.PhTreeHelper;
import java.util.Arrays;

public class LongArrayPool {
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final int UNIT_3 = 6;
    private static final int UNIT_BITS = 64;
    private final int maxArraySize;
    private final int maxArrayCount;
    private long[][][] pool;
    private int[] poolSize;
    private int[] poolStatsNew;

    public static LongArrayPool create() {
        if (PhTreeHelper.ARRAY_POOLING) {
            return new LongArrayPool(PhTreeHelper.ARRAY_POOLING_MAX_ARRAY_SIZE, PhTreeHelper.ARRAY_POOLING_POOL_SIZE);
        }
        return new LongArrayPool(0, 0);
    }

    public static LongArrayPool create(int maxArraySize, int maxArrayCount) {
        if (PhTreeHelper.ARRAY_POOLING) {
            return new LongArrayPool(maxArraySize, maxArrayCount);
        }
        return new LongArrayPool(0, 0);
    }

    private LongArrayPool(int maxArraySize, int maxArrayCount) {
        this.maxArraySize = maxArraySize;
        this.maxArrayCount = maxArrayCount;
        this.pool = new long[maxArraySize + 1][maxArrayCount][];
        this.poolSize = new int[maxArraySize + 1];
    }

    public long[] getArray(int size) {
        if (size == 0) {
            return EMPTY_LONG_ARRAY;
        }
        if (size > this.maxArraySize) {
            return new long[size];
        }
        int ps = this.poolSize[size];
        if (ps > 0) {
            int n = size;
            this.poolSize[n] = this.poolSize[n] - 1;
            long[] ret = this.pool[size][ps - 1];
            Arrays.fill(ret, 0L);
            return ret;
        }
        return new long[size];
    }

    public void offer(long[] a) {
        int size = a.length;
        if (size == 0 || size > this.maxArraySize) {
            return;
        }
        int ps = this.poolSize[size];
        if (ps < this.maxArrayCount) {
            this.pool[size][ps] = a;
            int n = size;
            this.poolSize[n] = this.poolSize[n] + 1;
        }
    }

    public static int calcArraySize(int nBits) {
        int arraySize = nBits + PhTreeHelper.ALLOC_BATCH_SIZE_LONG >>> 6;
        int size = PhTreeHelper.ALLOC_BATCH_SIZE;
        arraySize = arraySize / size * size;
        return arraySize;
    }

    public long[] arrayExpand(long[] oldA, int newSizeBits) {
        long[] newA = this.getArray(LongArrayPool.calcArraySize(newSizeBits));
        if (newSizeBits > 0) {
            System.arraycopy(oldA, 0, newA, 0, oldA.length);
        }
        this.offer(oldA);
        return newA;
    }

    public long[] arrayCreate(int nBits) {
        return this.getArray(LongArrayPool.calcArraySize(nBits));
    }

    public long[] arrayReplace(long[] oldA, long[] newA) {
        this.offer(oldA);
        return newA;
    }

    public long[] arrayClone(long[] oldA) {
        long[] newA = this.getArray(oldA.length);
        System.arraycopy(oldA, 0, newA, 0, oldA.length);
        return newA;
    }

    public long[] arrayEnsureSize(long[] oldA, int requiredBits) {
        if (this.isCapacitySufficient(oldA, requiredBits)) {
            return oldA;
        }
        return this.arrayExpand(oldA, requiredBits);
    }

    private boolean isCapacitySufficient(long[] a, int requiredBits) {
        return a.length * 64 >= requiredBits;
    }

    public long[] arrayTrim(long[] oldA, int requiredBits) {
        int reqSize = LongArrayPool.calcArraySize(requiredBits);
        if (oldA.length == reqSize) {
            return oldA;
        }
        if (reqSize == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] newA = this.getArray(reqSize);
        System.arraycopy(oldA, 0, newA, 0, reqSize);
        this.offer(oldA);
        return newA;
    }
}

