/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.util.unsynced;

import clib.phtree.PhTreeHelper;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.function.IntFunction;

public class ObjectArrayPool<T> {
    private final T[] EMPTY_REF_ARRAY = new Object[0];
    private final int maxArraySize;
    private final int maxArrayCount;
    private T[][][] pool;
    private int[] poolSize;
    private final IntFunction<T[]> constructor;

    public static <T> ObjectArrayPool<T> create() {
        return new ObjectArrayPool<T>(PhTreeHelper.ARRAY_POOLING_MAX_ARRAY_SIZE, PhTreeHelper.ARRAY_POOLING_POOL_SIZE, Object[]::new);
    }

    public static <T> ObjectArrayPool<T> create(IntFunction<T[]> constructor) {
        return new ObjectArrayPool<T>(PhTreeHelper.ARRAY_POOLING_MAX_ARRAY_SIZE, PhTreeHelper.ARRAY_POOLING_POOL_SIZE, constructor);
    }

    private ObjectArrayPool(int maxArraySize, int maxArrayCount, IntFunction<T[]> constructor) {
        this.constructor = constructor;
        this.maxArraySize = PhTreeHelper.ARRAY_POOLING ? maxArraySize : 0;
        this.maxArrayCount = PhTreeHelper.ARRAY_POOLING ? maxArrayCount : 0;
        this.pool = new Object[maxArraySize + 1][maxArrayCount][];
        this.poolSize = new int[maxArraySize + 1];
    }

    public T[] getArray(int size) {
        if (size == 0) {
            return this.EMPTY_REF_ARRAY;
        }
        if (size > this.maxArraySize) {
            return this.constructor.apply(size);
        }
        int ps = this.poolSize[size];
        if (ps > 0) {
            int n = size;
            this.poolSize[n] = this.poolSize[n] - 1;
            T[] ret = this.pool[size][ps - 1];
            this.pool[size][ps - 1] = null;
            return ret;
        }
        return this.constructor.apply(size);
    }

    public void offer(T[] a) {
        int size = a.length;
        if (size == 0 || size > this.maxArraySize) {
            return;
        }
        int ps = this.poolSize[size];
        if (ps < this.maxArrayCount) {
            Arrays.fill(a, null);
            this.pool[size][ps] = a;
            int n = size;
            this.poolSize[n] = this.poolSize[n] + 1;
        }
    }

    public int calcArraySize(int nObjects) {
        int arraySize = nObjects + PhTreeHelper.ALLOC_BATCH_REF;
        int size = PhTreeHelper.ALLOC_BATCH_SIZE * 2;
        arraySize = arraySize / size * size;
        return arraySize;
    }

    public T[] arrayExpand(T[] oldA, int newSize) {
        T[] newA = this.arrayCreate(newSize);
        System.arraycopy(oldA, 0, newA, 0, oldA.length);
        this.offer(oldA);
        return newA;
    }

    public T[] arrayExpandPrecise(T[] oldA, int newSize) {
        T[] newA = this.getArray(newSize);
        System.arraycopy(oldA, 0, newA, 0, oldA.length);
        this.offer(oldA);
        return newA;
    }

    public T[] arrayCreate(int size) {
        return this.getArray(this.calcArraySize(size));
    }

    public T[] arrayReplace(T[] oldA, T[] newA) {
        if (oldA != null) {
            this.offer(oldA);
        }
        return newA;
    }

    public void arrayDiscard(T[] oldA) {
        if (oldA != null) {
            this.offer(oldA);
        }
    }

    public T[] arrayClone(T[] oldA) {
        T[] newA = this.arrayCreate(oldA.length);
        System.arraycopy(oldA, 0, newA, 0, oldA.length);
        return newA;
    }

    public T[] insertSpaceAtPos(T[] values, int pos, int requiredSize) {
        T[] dst = values;
        if (requiredSize > values.length) {
            dst = this.arrayCreate(requiredSize);
            this.copyRight(values, 0, dst, 0, pos);
        }
        this.copyRight(values, pos, dst, pos + 1, requiredSize - 1 - pos);
        return dst;
    }

    public T[] removeSpaceAtPos(T[] values, int pos, int requiredSize) {
        int reqSize = this.calcArraySize(requiredSize);
        T[] dst = values;
        if (reqSize < values.length) {
            dst = this.getArray(reqSize);
            this.copyLeft(values, 0, dst, 0, pos);
        }
        this.copyLeft(values, pos + 1, dst, pos, requiredSize - pos);
        return dst;
    }

    private void copyLeft(T[] src, int srcPos, T[] dst, int dstPos, int len) {
        if (len >= 7) {
            System.arraycopy(src, srcPos, dst, dstPos, len);
        } else {
            for (int i = 0; i < len; ++i) {
                dst[dstPos + i] = src[srcPos + i];
            }
        }
    }

    private void copyRight(T[] src, int srcPos, T[] dst, int dstPos, int len) {
        if (len >= 7) {
            System.arraycopy(src, srcPos, dst, dstPos, len);
        } else {
            for (int i = len - 1; i >= 0; --i) {
                dst[dstPos + i] = src[srcPos + i];
            }
        }
    }

    public void write(T[] a, ObjectOutput out) throws IOException {
        out.writeInt(a.length);
        for (int i = 0; i < a.length; ++i) {
            out.writeObject(a[i]);
        }
    }

    public T[] read(ObjectInput in) throws IOException {
        int size = in.readInt();
        T[] ret = this.getArray(size);
        try {
            for (int i = 0; i < size; ++i) {
                ret[i] = in.readObject();
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return ret;
    }
}

