/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.util.unsynced;

import clib.phtree.PhTreeHelper;
import java.util.function.Supplier;

public class ObjectPool<T> {
    public static int DEFAULT_POOL_SIZE = PhTreeHelper.MAX_OBJECT_POOL_SIZE;
    private final T[] pool;
    private int poolSize;
    private final Supplier<T> constructor;

    private ObjectPool(int maxPoolSize, Supplier<T> constructor) {
        this.constructor = constructor != null ? constructor : () -> null;
        int size = PhTreeHelper.ARRAY_POOLING ? maxPoolSize : 0;
        this.pool = new Object[size];
    }

    public static <T> ObjectPool<T> create(Supplier<T> constructor) {
        return new ObjectPool<T>(DEFAULT_POOL_SIZE, constructor);
    }

    public static <T> ObjectPool<T> create(int maxPoolSize, Supplier<T> constructor) {
        return new ObjectPool<T>(maxPoolSize, constructor);
    }

    public T get() {
        return this.poolSize > 0 ? this.pool[--this.poolSize] : this.constructor.get();
    }

    public void offer(T node) {
        if (this.poolSize < this.pool.length) {
            this.pool[this.poolSize++] = node;
        }
    }
}

