/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v11;

import ch.ethz.globis.pht64kd.MaxKTreeI;
import clib.phtree.PhEntry;
import clib.phtree.PhTreeHelper;
import clib.phtree.util.Refs;
import clib.phtree.util.RefsLong;
import clib.phtree.v11.Bits;
import clib.phtree.v11.NodePool;
import clib.phtree.v11.PhTree11;
import clib.phtree.v11.nt.NodeTreeV11;
import clib.phtree.v11.nt.NtIteratorMask;
import clib.phtree.v11.nt.NtIteratorMinMax;
import clib.phtree.v11.nt.NtNode;
import clib.phtree.v11.nt.NtNodePool;

public class Node {
    private static final int REF_BITS = 32;
    private static final int HC_BITS = 0;
    private static final int INN_HC_WIDTH = 0;
    public static final double AHC_LHC_BIAS = 2.0;
    public static final int NT_THRESHOLD = 150;
    private Object[] values;
    private int entryCnt = 0;
    long[] ba = null;
    private boolean isHC = false;
    private byte postLen = 0;
    private byte infixLen = 0;
    private NtNode<Object> ind = null;
    private static int N_GOOD = 0;
    private static int N = 0;

    private static final boolean shouldSwitchToNT(int entryCount) {
        return entryCount >= 150;
    }

    private static final boolean shouldSwitchFromNtToHC(int entryCount) {
        return entryCount <= 120;
    }

    static final int IK_WIDTH(int dims) {
        return dims;
    }

    private Node() {
    }

    protected Node(Node original) {
        if (original.values != null) {
            this.values = Refs.arrayClone(original.values);
        }
        this.entryCnt = original.entryCnt;
        this.infixLen = original.infixLen;
        this.isHC = original.isHC;
        this.postLen = original.postLen;
        this.infixLen = original.infixLen;
        if (original.ind != null) {
            throw new UnsupportedOperationException();
        }
        if (original.ba != null) {
            this.ba = Bits.arrayClone(original.ba);
        }
    }

    static Node createEmpty() {
        return new Node();
    }

    private void initNode(int infixLen, int postLen, int dims) {
        this.infixLen = (byte)infixLen;
        this.postLen = (byte)postLen;
        this.entryCnt = 0;
        this.ind = null;
        this.isHC = false;
        int size = this.calcArraySizeTotalBits(2, dims);
        this.ba = Bits.arrayCreate(size);
        this.values = Refs.arrayCreate(2);
    }

    static Node createNode(int dims, int infixLen, int postLen) {
        Node n = NodePool.getNode();
        n.initNode(infixLen, postLen, dims);
        return n;
    }

    static Node createNode(Node original) {
        return new Node(original);
    }

    <T> PhEntry<T> createNodeEntry(long[] key, T value) {
        return new PhEntry<T>(key, value);
    }

    void discardNode() {
        Bits.arrayReplace(this.ba, null);
        Refs.arrayReplace(this.values, null);
        this.entryCnt = 0;
        NodePool.offer(this);
        this.ind = null;
    }

    int calcArraySizeTotalBits(int entryCount, int dims) {
        int nBits = this.getBitPosIndex();
        nBits = this.isAHC() ? (nBits += (0 + dims * this.postLen) * (1 << dims)) : (this.isNT() ? (nBits += 0) : (nBits += entryCount * (Node.IK_WIDTH(dims) + dims * this.postLen)));
        return nBits;
    }

    private int calcArraySizeTotalBitsNt() {
        return this.getBitPosIndex();
    }

    boolean getInfixOfSub(int pin, long hcPos, long[] outVal) {
        int offs = this.pinToOffsBitsData(pin, hcPos, outVal.length);
        if (!this.hasSubInfix(offs, outVal.length)) {
            return false;
        }
        long mask = -1L << this.postLen;
        for (int i = 0; i < outVal.length; ++i) {
            outVal[i] = mask & outVal[i] | Bits.readArray(this.ba, offs, this.postLen);
            offs += this.postLen;
        }
        return true;
    }

    void getInfixOfSubNt(long[] infix, long[] outKey) {
        if (!this.hasSubInfixNI(infix)) {
            return;
        }
        long mask = -1L << this.postLen;
        for (int i = 0; i < outKey.length; ++i) {
            outKey[i] = mask & outKey[i] | infix[i];
        }
    }

    Object doInsertIfMatching(long[] keyToMatch, Object newValueToInsert, PhTree11<?> tree) {
        int offs;
        Object v;
        long hcPos = PhTreeHelper.posInArray(keyToMatch, this.getPostLen());
        if (this.isNT()) {
            Object v2 = this.ntPut(hcPos, keyToMatch, newValueToInsert);
            if (v2 == null) {
                tree.increaseNrEntries();
            }
            return v2;
        }
        int pin = this.getPosition(hcPos, keyToMatch.length);
        if (pin < 0) {
            tree.increaseNrEntries();
            this.addPostPIN(hcPos, pin, keyToMatch, newValueToInsert);
            return null;
        }
        int dims = keyToMatch.length;
        if (this.isAHC()) {
            v = this.values[(int)hcPos];
            offs = this.posToOffsBitsDataAHC(hcPos, this.getBitPosIndex(), dims);
        } else {
            v = this.values[pin];
            offs = this.pinToOffsBitsDataLHC(pin, this.getBitPosIndex(), dims);
        }
        if (v instanceof Node) {
            Node sub = (Node)v;
            if (this.hasSubInfix(offs, dims)) {
                long mask = this.calcInfixMask(sub.getPostLen());
                return this.insertSplit(keyToMatch, newValueToInsert, v, pin, hcPos, tree, offs, mask);
            }
            return v;
        }
        if (this.postLen > 0) {
            long mask = this.calcPostfixMask();
            return this.insertSplit(keyToMatch, newValueToInsert, v, pin, hcPos, tree, offs, mask);
        }
        this.values[pin] = newValueToInsert;
        return v;
    }

    Object doIfMatching(long[] keyToMatch, boolean getOnly, Node parent, long[] newKey, int[] insertRequired, PhTree11<?> tree) {
        int offs;
        int pin;
        Object v;
        long hcPos = PhTreeHelper.posInArray(keyToMatch, this.getPostLen());
        if (this.isNT()) {
            if (getOnly) {
                return this.ntGetEntryIfMatches(hcPos, keyToMatch);
            }
            Object v2 = this.ntRemoveEntry(hcPos, keyToMatch, newKey, insertRequired);
            if (v2 != null && !(v2 instanceof Node)) {
                tree.decreaseNrEntries();
                if (this.getEntryCount() == 1) {
                    this.mergeIntoParentNt(keyToMatch, parent);
                }
            }
            return v2;
        }
        int dims = keyToMatch.length;
        if (this.isAHC()) {
            v = this.values[(int)hcPos];
            if (v == null) {
                return null;
            }
            pin = (int)hcPos;
            offs = this.posToOffsBitsDataAHC(hcPos, this.getBitPosIndex(), dims);
        } else {
            pin = this.getPosition(hcPos, keyToMatch.length);
            if (pin < 0) {
                return null;
            }
            v = this.values[pin];
            offs = this.pinToOffsBitsDataLHC(pin, this.getBitPosIndex(), dims);
        }
        if (v instanceof Node) {
            long mask;
            Node sub = (Node)v;
            if (this.hasSubInfix(offs, dims) && !this.readAndCheckKdKey(offs, keyToMatch, mask = this.calcInfixMask(sub.getPostLen()))) {
                return null;
            }
            return v;
        }
        long mask = this.calcPostfixMask();
        if (!this.readAndCheckKdKey(offs, keyToMatch, mask)) {
            return null;
        }
        if (getOnly) {
            return v;
        }
        return this.deleteAndMergeIntoParent(pin, hcPos, keyToMatch, parent, newKey, insertRequired, v, tree);
    }

    private boolean readAndCheckKdKey(int offs, long[] keyToMatch, long mask) {
        for (int i = 0; i < keyToMatch.length; ++i) {
            long k = Bits.readArray(this.ba, offs, this.postLen);
            if (((k ^ keyToMatch[i]) & mask) != 0L) {
                return false;
            }
            offs += this.postLen;
        }
        return true;
    }

    public long calcPostfixMask() {
        return -1L << this.postLen ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public long calcInfixMask(int subPostLen) {
        long mask = -1L << this.postLen - subPostLen - 1 ^ 0xFFFFFFFFFFFFFFFFL;
        return mask << subPostLen + 1;
    }

    private Object insertSplit(long[] newKey, Object newValue, Object currentValue, int pin, long hcPos, PhTree11<?> tree, int offs, long mask) {
        long[] buffer = new long[newKey.length];
        int maxConflictingBits = this.calcConflictingBits(newKey, offs, buffer, mask);
        if (maxConflictingBits == 0) {
            if (!(currentValue instanceof Node)) {
                this.values[pin] = newValue;
            }
            return currentValue;
        }
        Node newNode = this.createNode(newKey, newValue, buffer, currentValue, maxConflictingBits);
        this.replaceEntryWithSub(pin, hcPos, newKey, newNode);
        tree.increaseNrEntries();
        return null;
    }

    public Node createNode(long[] key1, Object val1, long[] key2, Object val2, int mcb) {
        long posSub2;
        int newLocalInfLen = this.postLen - mcb;
        int newPostLen = mcb - 1;
        Node newNode = Node.createNode(key1.length, newLocalInfLen, newPostLen);
        long posSub1 = PhTreeHelper.posInArray(key1, newPostLen);
        if (posSub1 < (posSub2 = PhTreeHelper.posInArray(key2, newPostLen))) {
            newNode.writeEntry(0, posSub1, key1, val1);
            newNode.writeEntry(1, posSub2, key2, val2);
        } else {
            newNode.writeEntry(0, posSub2, key2, val2);
            newNode.writeEntry(1, posSub1, key1, val1);
        }
        newNode.incEntryCount();
        newNode.incEntryCount();
        return newNode;
    }

    public static int calcConflictingBits(long[] v1, long[] v2, long mask) {
        long diff = 0L;
        for (int i = 0; i < v1.length; ++i) {
            diff |= v1[i] ^ v2[i];
        }
        return 64 - Long.numberOfLeadingZeros(diff & mask);
    }

    private int calcConflictingBits(long[] v1, int bitOffs, long[] outV, long mask) {
        long diff = 0L;
        long[] ia = this.ba;
        int offs = bitOffs;
        for (int i = 0; i < v1.length; ++i) {
            long k = Bits.readArray(ia, offs, this.postLen);
            diff |= v1[i] ^ k;
            outV[i] = k;
            offs += this.postLen;
        }
        return 64 - Long.numberOfLeadingZeros(diff & mask);
    }

    private Object deleteAndMergeIntoParent(int pinToDelete, long hcPos, long[] key, Node parent, long[] newKey, int[] insertRequired, Object valueToDelete, PhTree11<?> tree) {
        int dims = key.length;
        if (newKey != null) {
            int bitPosOfDiff = Node.calcConflictingBits(key, newKey, -1L);
            if (bitPosOfDiff <= this.getPostLen()) {
                return this.replacePost(pinToDelete, hcPos, newKey);
            }
            insertRequired[0] = bitPosOfDiff;
        }
        tree.decreaseNrEntries();
        if (parent == null || this.getEntryCount() > 2) {
            return this.removeEntry(hcPos, pinToDelete, dims);
        }
        int pin2 = -1;
        long pos2 = -1L;
        Object val2 = null;
        if (this.isAHC()) {
            for (int i = 0; i < 1 << key.length; ++i) {
                if (this.values[i] == null || i == pinToDelete) continue;
                pin2 = i;
                pos2 = i;
                val2 = this.values[i];
                break;
            }
        } else {
            pin2 = pinToDelete == 0 ? 1 : 0;
            int offs = this.pinToOffsBitsLHC(pin2, this.getBitPosIndex(), dims);
            pos2 = Bits.readArray(this.ba, offs, Node.IK_WIDTH(dims));
            val2 = this.values[pin2];
        }
        long[] newPost = new long[dims];
        RefsLong.arraycopy(key, 0, newPost, 0, key.length);
        long posInParent = PhTreeHelper.posInArray(key, parent.getPostLen());
        int pinInParent = parent.getPosition(posInParent, dims);
        if (val2 instanceof Node) {
            PhTreeHelper.applyHcPos(pos2, this.getPostLen(), newPost);
            this.getInfixOfSub(pin2, pos2, newPost);
            Node sub2 = (Node)val2;
            int newInfixLen = this.getInfixLen() + 1 + sub2.getInfixLen();
            sub2.setInfixLen(newInfixLen);
            parent.replaceEntryWithSub(pinInParent, posInParent, newPost, sub2);
        } else {
            this.getEntryByPIN(pin2, pos2, newPost);
            parent.replaceSubWithPost(pinInParent, posInParent, newPost, val2);
        }
        this.discardNode();
        return valueToDelete;
    }

    private void mergeIntoParentNt(long[] key, Node parent) {
        int dims = key.length;
        if (parent == null || this.getEntryCount() > 2) {
            return;
        }
        MaxKTreeI.PhIterator64<Object> iter = this.ntIterator(dims);
        MaxKTreeI.NtEntry<Object> nte = iter.nextEntryReuse();
        long posInParent = PhTreeHelper.posInArray(key, parent.getPostLen());
        int pinInParent = parent.getPosition(posInParent, dims);
        if (nte.getValue() instanceof Node) {
            long[] newPost = nte.getKdKey();
            Node sub2 = (Node)nte.getValue();
            int newInfixLen = this.getInfixLen() + 1 + sub2.getInfixLen();
            sub2.setInfixLen(newInfixLen);
            parent.replaceEntryWithSub(pinInParent, posInParent, newPost, sub2);
        } else {
            parent.replaceSubWithPost(pinInParent, posInParent, nte.getKdKey(), nte.getValue());
        }
        this.discardNode();
    }

    Object getEntryByPIN(int posInNode, long hcPos, long[] postBuf) {
        if (this.isNT()) {
            return this.ntGetEntry(hcPos, postBuf, null);
        }
        PhTreeHelper.applyHcPos(hcPos, this.postLen, postBuf);
        Object o = this.values[posInNode];
        if (o instanceof Node) {
            this.getInfixOfSub(posInNode, hcPos, postBuf);
        } else {
            int offsetBit = this.pinToOffsBitsData(posInNode, hcPos, postBuf.length);
            long mask = -1L << this.postLen;
            int i = 0;
            while (i < postBuf.length) {
                int n = i;
                postBuf[n] = postBuf[n] & mask;
                int n2 = i++;
                postBuf[n2] = postBuf[n2] | Bits.readArray(this.ba, offsetBit, this.postLen);
                offsetBit += this.postLen;
            }
        }
        return o;
    }

    Object getEntry(long hcPos, long[] postBuf) {
        int posInNode = this.getPosition(hcPos, postBuf.length);
        if (posInNode < 0) {
            return null;
        }
        return this.getEntryByPIN(posInNode, hcPos, postBuf);
    }

    Object getEntryPIN(int posInNode, long hcPos, long[] subNodePrefix, long[] outKey) {
        Object o = this.values[posInNode];
        if (o == null) {
            return null;
        }
        PhTreeHelper.applyHcPos(hcPos, this.postLen, subNodePrefix);
        if (o instanceof Node) {
            this.getInfixOfSub(posInNode, hcPos, subNodePrefix);
        } else {
            int offsetBit = this.pinToOffsBitsData(posInNode, hcPos, subNodePrefix.length);
            long mask = -1L << this.postLen;
            for (int i = 0; i < subNodePrefix.length; ++i) {
                outKey[i] = subNodePrefix[i] & mask | Bits.readArray(this.ba, offsetBit, this.postLen);
                offsetBit += this.postLen;
            }
        }
        return o;
    }

    private boolean shouldSwitchToAHC(int entryCount, int dims) {
        return this.useAHC(entryCount, dims);
    }

    private boolean shouldSwitchToLHC(int entryCount, int dims) {
        return !this.useAHC(entryCount + 2, dims);
    }

    private boolean useAHC(int entryCount, int dims) {
        long sizeAHC = (long)(dims * this.postLen + 0 + 32) * (1L << dims);
        long sizeLHC = (long)(dims * this.postLen + Node.IK_WIDTH(dims) + 32) * (long)entryCount;
        return dims <= 31 && (double)sizeLHC * 2.0 >= (double)sizeAHC;
    }

    private void writeEntry(int pin, long hcPos, long[] newKey, Object value) {
        int offsKey;
        if (this.isNT()) {
            this.ntPut(hcPos, newKey, value);
            return;
        }
        int dims = newKey.length;
        int offsIndex = this.getBitPosIndex();
        if (this.isAHC()) {
            this.values[(int)hcPos] = value;
            offsKey = this.posToOffsBitsDataAHC(hcPos, offsIndex, dims);
        } else {
            this.values[pin] = value;
            offsKey = this.pinToOffsBitsLHC(pin, offsIndex, dims);
            Bits.writeArray(this.ba, offsKey, Node.IK_WIDTH(dims), hcPos);
            offsKey += Node.IK_WIDTH(dims);
        }
        if (value instanceof Node) {
            int newSubInfixLen = this.postLen - ((Node)value).getPostLen() - 1;
            ((Node)value).setInfixLen(newSubInfixLen);
            this.writeSubInfix(pin, hcPos, newKey, newSubInfixLen);
        } else if (this.postLen > 0) {
            for (int i = 0; i < newKey.length; ++i) {
                Bits.writeArray(this.ba, offsKey, this.postLen, newKey[i]);
                offsKey += this.postLen;
            }
        }
    }

    private Object replacePost(int pin, long hcPos, long[] newKey) {
        int offs = this.pinToOffsBitsData(pin, hcPos, newKey.length);
        for (int i = 0; i < newKey.length; ++i) {
            Bits.writeArray(this.ba, offs, this.postLen, newKey[i]);
            offs += this.postLen;
        }
        return this.values[pin];
    }

    void replaceEntryWithSub(int posInNode, long hcPos, long[] infix, Node newSub) {
        if (this.isNT()) {
            this.ntReplaceEntry(hcPos, infix, newSub);
            return;
        }
        this.writeSubInfix(posInNode, hcPos, infix, newSub.getInfixLen());
        this.values[posInNode] = newSub;
    }

    void writeSubInfix(int pin, long hcPos, long[] infix, int subInfixLen) {
        if (this.isNT()) {
            throw new IllegalStateException();
        }
        if (subInfixLen > 0) {
            this.replacePost(pin, hcPos, infix);
        }
        int dims = infix.length;
        int subInfoOffs = this.pinToOffsBitsData(pin, hcPos, dims) + dims * this.postLen - 1;
        this.writeSubInfixInfo(this.ba, subInfoOffs, subInfixLen);
    }

    private void writeSubInfixInfo(long[] ba, int subInfoOffs, int subInfixLen) {
        boolean hasInfix = subInfixLen != 0;
        Bits.setBit(ba, subInfoOffs, hasInfix);
    }

    private boolean hasSubInfix(int subInfoOffs, int dims) {
        return Bits.getBit(this.ba, subInfoOffs + dims * this.postLen - 1);
    }

    boolean hasSubInfixNI(long[] infix) {
        return true;
    }

    void replaceSubWithPost(int pin, long hcPos, long[] key, Object value) {
        if (this.isNT()) {
            this.ntReplaceEntry(hcPos, key, value);
            return;
        }
        this.values[pin] = value;
        this.replacePost(pin, hcPos, key);
    }

    Object ntReplaceEntry(long hcPos, long[] kdKey, Object value) {
        return NodeTreeV11.addEntry(this.ind, hcPos, kdKey, value, null);
    }

    Object ntPut(long hcPos, long[] kdKey, Object value) {
        return NodeTreeV11.addEntry(this.ind, hcPos, kdKey, value, this);
    }

    Object ntRemoveAnything(long hcPos, int dims) {
        return NodeTreeV11.removeEntry(this.ind, hcPos, dims, null, null, null, null);
    }

    Object ntRemoveEntry(long hcPos, long[] key, long[] newKey, int[] insertRequired) {
        return NodeTreeV11.removeEntry(this.ind, hcPos, key.length, key, newKey, insertRequired, this);
    }

    Object ntGetEntry(long hcPos, long[] outKey, long[] valTemplate) {
        return NodeTreeV11.getEntry(this.ind(), hcPos, outKey, null, null);
    }

    Object ntGetEntryIfMatches(long hcPos, long[] keyToMatch) {
        return NodeTreeV11.getEntry(this.ind(), hcPos, null, keyToMatch, this);
    }

    int ntGetSize() {
        return this.getEntryCount();
    }

    private void switchLhcToAhcAndGrow(int oldEntryCount, int dims) {
        int posOfIndex = this.getBitPosIndex();
        int posOfData = this.posToOffsBitsDataAHC(0L, posOfIndex, dims);
        this.setAHC(true);
        long[] bia2 = Bits.arrayCreate(this.calcArraySizeTotalBits(oldEntryCount + 1, dims));
        T[] v2 = Refs.arrayCreate(1 << dims);
        Bits.copyBitsLeft(this.ba, 0, bia2, 0, posOfIndex);
        int postLenTotal = dims * this.postLen;
        for (int i = 0; i < oldEntryCount; ++i) {
            int entryPosLHC = posOfIndex + i * (Node.IK_WIDTH(dims) + postLenTotal);
            int p2 = (int)Bits.readArray(this.ba, entryPosLHC, Node.IK_WIDTH(dims));
            Bits.copyBitsLeft(this.ba, entryPosLHC + Node.IK_WIDTH(dims), bia2, posOfData + postLenTotal * p2, postLenTotal);
            v2[p2] = this.values[i];
        }
        this.ba = Bits.arrayReplace(this.ba, bia2);
        this.values = Refs.arrayReplace(this.values, v2);
    }

    private Object switchAhcToLhcAndShrink(int oldEntryCount, int dims, long hcPosToRemove) {
        Object oldEntry = null;
        this.setAHC(false);
        long[] bia2 = Bits.arrayCreate(this.calcArraySizeTotalBits(oldEntryCount - 1, dims));
        T[] v2 = Refs.arrayCreate(oldEntryCount - 1);
        int oldOffsIndex = this.getBitPosIndex();
        int oldOffsData = oldOffsIndex + (1 << dims) * 0;
        Bits.copyBitsLeft(this.ba, 0, bia2, 0, oldOffsIndex);
        int postLenTotal = dims * this.postLen;
        int n = 0;
        int i = 0;
        while ((long)i < 1L << dims) {
            if ((long)i == hcPosToRemove) {
                oldEntry = this.values[i];
            } else if (this.values[i] != null) {
                v2[n] = this.values[i];
                int entryPosLHC = oldOffsIndex + n * (Node.IK_WIDTH(dims) + postLenTotal);
                Bits.writeArray(bia2, entryPosLHC, Node.IK_WIDTH(dims), i);
                Bits.copyBitsLeft(this.ba, oldOffsData + postLenTotal * i, bia2, entryPosLHC + Node.IK_WIDTH(dims), postLenTotal);
                ++n;
            }
            ++i;
        }
        this.ba = Bits.arrayReplace(this.ba, bia2);
        this.values = Refs.arrayReplace(this.values, v2);
        return oldEntry;
    }

    void addPostPIN(long hcPos, int pin, long[] key, Object value) {
        int dims = key.length;
        int bufEntryCnt = this.getEntryCount();
        if (!this.isNT() && Node.shouldSwitchToNT(bufEntryCnt)) {
            this.ntBuild(bufEntryCnt, dims, key);
        }
        if (this.isNT()) {
            this.ntPut(hcPos, key, value);
            return;
        }
        if (!this.isAHC() && this.shouldSwitchToAHC(bufEntryCnt + 1, dims)) {
            this.switchLhcToAhcAndGrow(bufEntryCnt, dims);
        }
        this.incEntryCount();
        int offsIndex = this.getBitPosIndex();
        if (this.isAHC()) {
            int offsPostKey = this.posToOffsBitsDataAHC(hcPos, offsIndex, dims);
            for (int i = 0; i < key.length; ++i) {
                Bits.writeArray(this.ba, offsPostKey + this.postLen * i, this.postLen, key[i]);
            }
            this.values[(int)hcPos] = value;
        } else {
            pin = -(pin + 1);
            long[] ia = this.ba = Bits.arrayEnsureSize(this.ba, this.calcArraySizeTotalBits(bufEntryCnt + 1, dims));
            int offs = this.pinToOffsBitsLHC(pin, offsIndex, dims);
            Bits.insertBits(ia, offs, Node.IK_WIDTH(dims) + dims * this.postLen);
            Bits.writeArray(ia, offs, Node.IK_WIDTH(dims), hcPos);
            offs += Node.IK_WIDTH(dims);
            for (int i = 0; i < key.length; ++i) {
                Bits.writeArray(ia, offs, this.postLen, key[i]);
                offs += this.postLen;
            }
            this.values = Refs.insertSpaceAtPos(this.values, pin, bufEntryCnt + 1);
            this.values[pin] = value;
        }
    }

    void postToNI(int startBit, int postLen, long[] outKey, long hcPos, long[] prefix, long mask) {
        for (int d = 0; d < outKey.length; ++d) {
            outKey[d] = Bits.readArray(this.ba, startBit, postLen) | prefix[d] & mask;
            startBit += postLen;
        }
        PhTreeHelper.applyHcPos(hcPos, postLen, outKey);
    }

    void postFromNI(long[] ia, int startBit, long[] key, int postLen) {
        for (int d = 0; d < key.length; ++d) {
            Bits.writeArray(ia, startBit + postLen * d, postLen, key[d]);
        }
    }

    void infixFromNI(long[] ba, int startBit, long[] key, int subInfixLen) {
        for (int i = 0; i < key.length; ++i) {
            Bits.writeArray(ba, startBit, this.postLen, key[i]);
            startBit += this.postLen;
        }
        int subInfoOffs = startBit - 1;
        this.writeSubInfixInfo(ba, subInfoOffs, subInfixLen);
    }

    NtNode<Object> createNiIndex(int dims) {
        return NtNode.createRoot(dims);
    }

    private void ntBuild(int bufEntryCnt, int dims, long[] prefix) {
        if (this.ind != null || this.isNT()) {
            throw new IllegalStateException();
        }
        this.ind = this.createNiIndex(dims);
        long prefixMask = -1L << this.postLen;
        if (this.isAHC()) {
            int oldOffsIndex = this.getBitPosIndex();
            int oldPostBitsVal = this.posToOffsBitsDataAHC(0L, oldOffsIndex, dims);
            int postLenTotal = dims * this.postLen;
            long[] buffer = new long[dims];
            int i = 0;
            while ((long)i < 1L << dims) {
                Object o = this.values[i];
                if (o != null) {
                    int dataOffs = oldPostBitsVal + i * postLenTotal;
                    this.postToNI(dataOffs, this.postLen, buffer, i, prefix, prefixMask);
                    NodeTreeV11.addEntry(this.ind, (long)i, buffer, o, null);
                }
                ++i;
            }
        } else {
            int offsIndex = this.getBitPosIndex();
            int dataOffs = this.pinToOffsBitsLHC(0, offsIndex, dims);
            int postLenTotal = dims * this.postLen;
            long[] buffer = new long[dims];
            for (int i = 0; i < bufEntryCnt; ++i) {
                long p2 = Bits.readArray(this.ba, dataOffs, Node.IK_WIDTH(dims));
                Object e = this.values[i];
                this.postToNI(dataOffs += Node.IK_WIDTH(dims), this.postLen, buffer, p2, prefix, prefixMask);
                NodeTreeV11.addEntry(this.ind, p2, buffer, e, null);
                dataOffs += postLenTotal;
            }
        }
        this.setAHC(false);
        this.ba = Bits.arrayTrim(this.ba, this.calcArraySizeTotalBitsNt());
        this.values = Refs.arrayReplace(this.values, null);
    }

    private Object ntDeconstruct(int dims, long posToRemove) {
        if (this.ind == null || !this.isNT()) {
            throw new IllegalStateException();
        }
        int entryCountNew = this.ntGetSize() - 1;
        this.decEntryCount();
        boolean shouldBeAHC = this.useAHC(entryCountNew, dims);
        this.setAHC(shouldBeAHC);
        Object oldValue = null;
        int offsIndex = this.getBitPosIndex();
        long[] bia2 = Bits.arrayCreate(this.calcArraySizeTotalBits(entryCountNew, dims));
        Bits.copyBitsLeft(this.ba, 0, bia2, 0, offsIndex);
        int postLenTotal = dims * this.postLen;
        if (shouldBeAHC) {
            T[] v2 = Refs.arrayCreate(1 << dims);
            int startBitData = this.posToOffsBitsDataAHC(0L, offsIndex, dims);
            MaxKTreeI.PhIterator64<Object> it = this.ntIterator(dims);
            while (it.hasNext()) {
                MaxKTreeI.NtEntry<Object> e = it.nextEntryReuse();
                long pos = e.key();
                if (pos == posToRemove) {
                    oldValue = e.value();
                    v2[(int)pos] = null;
                    continue;
                }
                int p2 = (int)pos;
                int offsBitData = startBitData + this.postLen * dims * p2;
                if (e.value() instanceof Node) {
                    Node node = (Node)e.value();
                    this.infixFromNI(bia2, offsBitData, e.getKdKey(), node.getInfixLen());
                } else {
                    this.postFromNI(bia2, offsBitData, e.getKdKey(), this.postLen);
                }
                v2[p2] = e.value();
            }
            this.ba = Bits.arrayReplace(this.ba, bia2);
            this.values = Refs.arrayReplace(this.values, v2);
        } else {
            T[] v2 = Refs.arrayCreate(entryCountNew);
            int n = 0;
            MaxKTreeI.PhIterator64<Object> it = this.ntIterator(dims);
            int entryPosLHC = offsIndex;
            while (it.hasNext()) {
                MaxKTreeI.NtEntry<Object> e = it.nextEntryReuse();
                long pos = e.key();
                if (pos == posToRemove) {
                    oldValue = e.value();
                    continue;
                }
                Bits.writeArray(bia2, entryPosLHC, Node.IK_WIDTH(dims), pos);
                entryPosLHC += Node.IK_WIDTH(dims);
                v2[n] = e.value();
                if (e.value() instanceof Node) {
                    Node node = (Node)e.getValue();
                    this.infixFromNI(bia2, entryPosLHC, e.getKdKey(), node.getInfixLen());
                } else {
                    this.postFromNI(bia2, entryPosLHC, e.getKdKey(), this.postLen);
                }
                entryPosLHC += postLenTotal;
                ++n;
            }
            this.ba = Bits.arrayReplace(this.ba, bia2);
            this.values = Refs.arrayReplace(this.values, v2);
        }
        NtNodePool.offer(this.ind);
        this.ind = null;
        return oldValue;
    }

    Object checkAndGetEntryPIN(int pin, long hcPos, long[] inOutPrefix, long[] outKey, long[] rangeMin, long[] rangeMax) {
        Object o = this.values[pin];
        if (o == null) {
            return null;
        }
        PhTreeHelper.applyHcPos(hcPos, this.postLen, inOutPrefix);
        if (o instanceof Node) {
            return this.checkAndApplyInfix(((Node)o).getInfixLen(), pin, hcPos, inOutPrefix, rangeMin, rangeMax) ? o : null;
        }
        if (this.checkAndGetPost(pin, hcPos, inOutPrefix, outKey, rangeMin, rangeMax)) {
            return o;
        }
        return null;
    }

    private boolean checkAndApplyInfix(int infixLen, int pin, long hcPos, long[] valTemplate, long[] rangeMin, long[] rangeMax) {
        int dims = valTemplate.length;
        int subOffs = this.pinToOffsBitsData(pin, hcPos, dims);
        if (!this.hasSubInfix(subOffs, dims)) {
            return true;
        }
        long maskClean = -1L << this.postLen;
        long compMask = -1L << this.postLen - infixLen;
        for (int dim = 0; dim < valTemplate.length; ++dim) {
            long in = valTemplate[dim] & maskClean | Bits.readArray(this.ba, subOffs, this.postLen);
            if ((in &= compMask) > rangeMax[dim] || (in | compMask ^ 0xFFFFFFFFFFFFFFFFL) < rangeMin[dim]) {
                return false;
            }
            valTemplate[dim] = in;
            subOffs += this.postLen;
        }
        return true;
    }

    boolean checkAndApplyInfixNt(int infixLen, long[] postFix, long[] valTemplate, long[] rangeMin, long[] rangeMax) {
        if (!this.hasSubInfixNI(postFix)) {
            return true;
        }
        long maskClean = -1L << this.postLen;
        long compMask = -1L << this.postLen - infixLen;
        for (int dim = 0; dim < valTemplate.length; ++dim) {
            long in = valTemplate[dim] & maskClean | postFix[dim];
            if ((in &= compMask) > rangeMax[dim] || in < (rangeMin[dim] & compMask)) {
                return false;
            }
            valTemplate[dim] = in;
        }
        return true;
    }

    <T> boolean checkAndGetEntryNt(long hcPos, Object value, PhEntry<T> result, long[] valTemplate, long[] rangeMin, long[] rangeMax) {
        PhTreeHelper.applyHcPos(hcPos, this.postLen, valTemplate);
        if (value instanceof Node) {
            Node sub = (Node)value;
            if (!this.checkAndApplyInfixNt(sub.getInfixLen(), result.getKey(), valTemplate, rangeMin, rangeMax)) {
                return false;
            }
            result.setNodeInternal(sub);
        } else {
            long[] inKey = result.getKey();
            for (int i = 0; i < inKey.length; ++i) {
                long k = inKey[i];
                if (k >= rangeMin[i] && k <= rangeMax[i]) continue;
                return false;
            }
            result.setValueInternal(value);
        }
        return true;
    }

    private boolean checkAndGetPost(int pin, long hcPos, long[] inPrefix, long[] outKey, long[] rangeMin, long[] rangeMax) {
        long[] ia = this.ba;
        int offs = this.pinToOffsBitsData(pin, hcPos, rangeMin.length);
        long mask = -1L << this.postLen;
        for (int i = 0; i < outKey.length; ++i) {
            long k = inPrefix[i] & mask | Bits.readArray(ia, offs, this.postLen);
            if (k < rangeMin[i] || k > rangeMax[i]) {
                return false;
            }
            outKey[i] = k;
            offs += this.postLen;
        }
        return true;
    }

    Object removeEntry(long hcPos, int posInNode, int dims) {
        Object oldVal;
        int bufEntryCnt = this.getEntryCount();
        if (this.isNT()) {
            if (Node.shouldSwitchFromNtToHC(bufEntryCnt)) {
                return this.ntDeconstruct(dims, hcPos);
            }
            Object o = this.ntRemoveAnything(hcPos, dims);
            this.decEntryCount();
            return o;
        }
        if (this.isAHC() && this.shouldSwitchToLHC(bufEntryCnt, dims)) {
            Object oldVal2 = this.switchAhcToLhcAndShrink(bufEntryCnt, dims, hcPos);
            this.decEntryCount();
            return oldVal2;
        }
        int offsIndex = this.getBitPosIndex();
        if (this.isAHC()) {
            oldVal = this.values[(int)hcPos];
            this.values[(int)hcPos] = null;
        } else {
            int posBit = this.pinToOffsBitsLHC(posInNode, offsIndex, dims);
            Bits.removeBits(this.ba, posBit, Node.IK_WIDTH(dims) + dims * this.postLen);
            this.ba = Bits.arrayTrim(this.ba, this.calcArraySizeTotalBits(bufEntryCnt - 1, dims));
            oldVal = this.values[posInNode];
            this.values = Refs.removeSpaceAtPos(this.values, posInNode, bufEntryCnt - 1);
        }
        this.decEntryCount();
        return oldVal;
    }

    boolean isAHC() {
        return this.isHC;
    }

    void setAHC(boolean b) {
        this.isHC = b;
    }

    boolean isNT() {
        return this.ind != null;
    }

    public int getEntryCount() {
        return this.entryCnt;
    }

    public void decEntryCount() {
        --this.entryCnt;
    }

    public void incEntryCount() {
        ++this.entryCnt;
    }

    int getBitPosIndex() {
        return this.getBitPosInfix();
    }

    private int getBitPosInfix() {
        return 0;
    }

    private int posToOffsBitsDataAHC(long hcPos, int offsIndex, int dims) {
        return offsIndex + 0 * (1 << dims) + this.postLen * dims * (int)hcPos;
    }

    private int pinToOffsBitsDataLHC(int pin, int offsIndex, int dims) {
        return offsIndex + (Node.IK_WIDTH(dims) + this.postLen * dims) * pin + Node.IK_WIDTH(dims);
    }

    int pinToOffsBitsLHC(int pin, int offsIndex, int dims) {
        return offsIndex + (Node.IK_WIDTH(dims) + this.postLen * dims) * pin;
    }

    int pinToOffsBitsData(int pin, long hcPos, int dims) {
        int offsIndex = this.getBitPosIndex();
        if (this.isAHC()) {
            return this.posToOffsBitsDataAHC(hcPos, offsIndex, dims);
        }
        return this.pinToOffsBitsLHC(pin, offsIndex, dims) + Node.IK_WIDTH(dims);
    }

    int getPosition(long hcPos, int dims) {
        if (this.isAHC()) {
            int posInt = (int)hcPos;
            return this.values[posInt] != null ? posInt : -posInt - 1;
        }
        if (this.isNT()) {
            return Integer.MAX_VALUE;
        }
        int offsInd = this.getBitPosIndex();
        return Bits.binarySearch(this.ba, offsInd, this.getEntryCount(), hcPos, Node.IK_WIDTH(dims), dims * this.postLen);
    }

    int getInfixLen() {
        return this.infixLen;
    }

    void setInfixLen(int newInfLen) {
        this.infixLen = (byte)newInfLen;
    }

    public int getPostLen() {
        return this.postLen;
    }

    NtNode<Object> ind() {
        return this.ind;
    }

    MaxKTreeI.PhIterator64<Object> ntIterator(int dims) {
        return new NtIteratorMinMax<Object>(dims).reset(this.ind, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    NtIteratorMask<Object> ntIteratorWithMask(int dims, long maskLower, long maskUpper) {
        return new NtIteratorMask<Object>(dims).reset(this.ind, maskLower, maskUpper);
    }

    Object[] values() {
        return this.values;
    }
}

