/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v11.nt;

import clib.phtree.util.Refs;
import clib.phtree.util.RefsLong;
import clib.phtree.v11.nt.Bits;
import clib.phtree.v11.nt.NtNodePool;

public class NtNode<T> {
    public static final int MAX_DIM = 6;
    private static final long MAX_DIM_MASK = 63L;
    private static final int REF_BITS = 32;
    static final int HC_BITS = 0;
    static final int INN_HC_WIDTH = 0;
    private Object[] values;
    private short entryCnt = 0;
    long[] ba = null;
    private long[] kdKeys = null;
    private boolean isAHC = false;
    private byte postLen = 0;

    static final int IK_WIDTH(int dims) {
        return dims;
    }

    static final int KD_WIDTH(int kdDims) {
        return kdDims * 64;
    }

    protected NtNode(NtNode<T> original) {
        this.values = Refs.arrayClone(original.values);
        this.entryCnt = original.entryCnt;
        this.isAHC = original.isAHC;
        this.postLen = original.postLen;
        this.ba = Bits.arrayClone(original.ba);
        this.kdKeys = RefsLong.arrayClone(original.kdKeys);
    }

    private NtNode() {
    }

    static <T> NtNode<T> createNode(NtNode<T> original) {
        return new NtNode<T>(original);
    }

    public static <T> NtNode<T> createRoot(int keyBitWidth) {
        NtNode<?> n = NtNodePool.getNode();
        n.initNode(NtNode.calcTreeHeight(keyBitWidth) - 1, keyBitWidth);
        return n;
    }

    static <T> NtNode<T> createNode(int postLen, int keyBitWidth) {
        NtNode<?> n = NtNodePool.getNode();
        n.initNode(postLen, keyBitWidth);
        return n;
    }

    static <T> NtNode<T> createEmptyNode() {
        return new NtNode<T>();
    }

    void initNode(int postLen, int keyBitWidth) {
        this.postLen = (byte)postLen;
        this.entryCnt = 0;
        this.isAHC = false;
        int size = this.calcArraySizeTotalBits(2, 6);
        this.ba = Bits.arrayCreate(size);
        this.kdKeys = RefsLong.arrayCreate(this.calcArraySizeTotalLongs(2, 6, keyBitWidth));
        this.values = Refs.arrayCreate(2);
    }

    void discardNode() {
        Bits.arrayReplace(this.ba, null);
        RefsLong.arrayReplace(this.kdKeys, null);
        Refs.arrayReplace(this.values, null);
        NtNodePool.offer(this);
    }

    int calcArraySizeTotalBits(int entryCount, int dims) {
        int nBits = this.getBitPosIndex();
        nBits = this.isAHC() ? (nBits += (0 + dims * this.postLen) * (1 << dims)) : (nBits += entryCount * (NtNode.IK_WIDTH(dims) + dims * this.postLen));
        return nBits;
    }

    int calcArraySizeTotalLongs(int entryCount, int dims, int kdDims) {
        return this.isAHC() ? kdDims * (1 << dims) : kdDims * entryCount;
    }

    static int calcTreeHeight(int k) {
        return (k - 1) / 6 + 1;
    }

    static long pos2LocalPos(long hcPos, int postLen) {
        return hcPos >>> postLen * 6 & 0x3FL;
    }

    static long pos2LocalPosNegative(long hcPos, int postLen) {
        return hcPos >> postLen * 6;
    }

    long localReadInfix(int pin, long localHcPos) {
        int infixBits = this.getPostLen() * 6;
        int infixPos = this.pinToOffsBitsData(pin, localHcPos, 6);
        return Bits.readArray(this.ba, infixPos, infixBits);
    }

    long localReadPostfix(int pin, long localHcPos) {
        int postBits = this.getPostLen() * 6;
        int postPos = this.pinToOffsBitsData(pin, localHcPos, 6);
        return Bits.readArray(this.ba, postPos, postBits);
    }

    long localReadAndApplyReadPostfixAndHc(int pin, long localHcPos, long prefix) {
        int postBits = this.getPostLen() * 6;
        int postPos = this.pinToOffsBitsData(pin, localHcPos, 6);
        long postFix = Bits.readArray(this.ba, postPos, postBits);
        long mask = -1L << postBits;
        return prefix & (mask <<= 6) | localHcPos << postBits | postFix;
    }

    long localReadKey(int pin) {
        if (this.isAHC()) {
            return pin;
        }
        int keyPos = this.pinToOffsBitsLHC(pin, this.getBitPosIndex(), 6);
        return Bits.readArray(this.ba, keyPos, 6);
    }

    void localAddEntry(long localHcPos, long postFix, long[] kdKey, Object value) {
        int pin = this.getPosition(localHcPos, 6);
        this.localAddEntryPIN(pin, localHcPos, postFix, kdKey, value);
    }

    void localAddEntryPIN(int pin, long localHcPos, long postFix, long[] key, Object value) {
        this.addEntryPIN(localHcPos, pin, postFix, key, value, 6);
    }

    void localReplaceEntryWithSub(int pin, long localHcPos, long hcPos, NtNode<T> newSub) {
        int totalInfixLen = this.getPostLen() * 6;
        int infixPos = this.pinToOffsBitsData(pin, localHcPos, 6);
        Bits.writeArray(this.ba, infixPos, totalInfixLen, hcPos);
        this.replaceValueSub(pin, newSub);
    }

    Object localReplaceEntry(int pin, long[] kdKey, Object newValue) {
        return this.replaceEntry(pin, kdKey, newValue);
    }

    Object localReplaceValue(int pin, Object newValue) {
        Object ret = this.values[pin];
        this.values[pin] = newValue;
        return ret;
    }

    static int getConflictingLevels(long key, long infix, int postLen) {
        if (postLen == 0) {
            return 0;
        }
        int endInclusive = postLen * 6 - 1;
        int confBits = Bits.getMaxConflictingBits(key, infix, endInclusive);
        return (confBits + 6 - 1) / 6;
    }

    static boolean hasConflictingLevels(long key, long infix, int postLen) {
        if (postLen == 0) {
            return false;
        }
        int endInclusive = postLen * 6 - 1;
        return Bits.hasConflictingBits(key, infix, endInclusive);
    }

    static int getConflictingLevels(long key, long infix, int parentPostLen, int subPostLen) {
        int subInfixLen = parentPostLen - subPostLen - 1;
        if (subInfixLen == 0) {
            return 0;
        }
        int startExclusive = (subPostLen + 1) * 6;
        int endInclusive = parentPostLen * 6 - 1;
        int confBits = Bits.getMaxConflictingBits(key, infix, startExclusive, endInclusive);
        return (confBits + 6 - 1) / 6;
    }

    static boolean hasConflictingLevels(long key, long infix, int parentPostLen, int subPostLen) {
        int subInfixLen = parentPostLen - subPostLen - 1;
        if (subInfixLen == 0) {
            return false;
        }
        int startExclusive = (subPostLen + 1) * 6;
        int endInclusive = parentPostLen * 6 - 1;
        return Bits.hasConflictingBits(key, infix, startExclusive, endInclusive);
    }

    static long applyHcPos(long localHcPos, int postLen, long prefix) {
        long mask = 63L;
        int postLen2 = postLen * 6;
        mask = mask << postLen2 ^ 0xFFFFFFFFFFFFFFFFL;
        return prefix & mask | localHcPos << postLen2;
    }

    long applyHcPos(long localHcPos, long prefix) {
        long mask = 63L;
        int postLen2 = this.postLen * 6;
        mask = mask << postLen2 ^ 0xFFFFFFFFFFFFFFFFL;
        return prefix & mask | localHcPos << postLen2;
    }

    static long applyPostFix(long postFix, int postLen, long prefix) {
        int postLen2 = postLen * 6;
        long mask = -1L << postLen2 ^ 0xFFFFFFFFFFFFFFFFL;
        return prefix & mask | postFix;
    }

    static long applyHcAndPostFix(long localHcPos, long postFix, int postLen, long prefix) {
        int postLen2 = postLen * 6;
        long mask = -1L << postLen2 ^ 0xFFFFFFFFFFFFFFFFL;
        return prefix & (mask <<= 6) | localHcPos << postLen2 | postFix;
    }

    Object getValueByPIN(int posInNode) {
        return this.values[posInNode];
    }

    Object getEntryByPIN(int posInNode, long[] outKey) {
        RefsLong.readArray(this.kdKeys, this.pinToKdPos(posInNode, outKey.length), outKey);
        return this.values[posInNode];
    }

    void getKdKeyByPIN(int posInNode, long[] outKey) {
        RefsLong.readArray(this.kdKeys, this.pinToKdPos(posInNode, outKey.length), outKey);
    }

    private boolean shouldSwitchToAHC(int entryCount, int dims, int kdDims) {
        return this.useAHC(entryCount, dims, kdDims);
    }

    private boolean shouldSwitchToLHC(int entryCount, int dims, int kdDims) {
        return !this.useAHC(entryCount + 2, dims, kdDims);
    }

    private boolean useAHC(int entryCount, int dims, int kdDims) {
        long sizeAHC = (long)(dims * this.postLen + 0 + 32 + NtNode.KD_WIDTH(kdDims)) * (1L << dims);
        long sizeLHC = (long)(dims * this.postLen + NtNode.IK_WIDTH(dims) + 32 + NtNode.KD_WIDTH(kdDims)) * (long)entryCount;
        return dims <= 31 && (double)sizeLHC * 1.5 >= (double)sizeAHC;
    }

    void replacePost(int pin, long hcPos, long newKey, int dims) {
        int offs = this.pinToOffsBitsData(pin, hcPos, dims);
        Bits.writeArray(this.ba, offs, this.postLen * dims, newKey);
    }

    void replaceValueSub(int pin, NtNode<T> sub) {
        this.values[pin] = sub;
    }

    Object replaceEntry(int pin, long[] kdKey, Object val) {
        Object ret = this.values[pin];
        RefsLong.writeArray(kdKey, this.kdKeys, this.pinToKdPos(pin, kdKey.length));
        this.values[pin] = val;
        return ret;
    }

    void readKdKeyPIN(int pin, long[] outKdKey) {
        RefsLong.readArray(this.kdKeys, pin * outKdKey.length, outKdKey);
    }

    boolean readKdKeyAndCheck(int pin, long[] keyToMatch, long mask) {
        int pos = pin * keyToMatch.length;
        for (int i = 0; i < keyToMatch.length; ++i) {
            if (((this.kdKeys[pos++] ^ keyToMatch[i]) & mask) == 0L) continue;
            return false;
        }
        return true;
    }

    private void switchLhcToAhcAndGrow(int oldEntryCount, int dims, int kdDims) {
        int posOfIndex = this.getBitPosIndex();
        int posOfData = this.posToOffsBitsDataAHC(0L, posOfIndex, dims);
        this.setAHC(true);
        long[] bia2 = Bits.arrayCreate(this.calcArraySizeTotalBits(oldEntryCount + 1, dims));
        long[] kdKeys2 = RefsLong.arrayCreate(this.calcArraySizeTotalLongs(oldEntryCount + 1, dims, kdDims));
        T[] v2 = Refs.arrayCreate(1 << dims);
        Bits.copyBitsLeft(this.ba, 0, bia2, 0, posOfIndex);
        int postLenTotal = dims * this.postLen;
        for (int i = 0; i < oldEntryCount; ++i) {
            int entryPosLHC = posOfIndex + i * (NtNode.IK_WIDTH(dims) + postLenTotal);
            int p2 = (int)Bits.readArray(this.ba, entryPosLHC, NtNode.IK_WIDTH(dims));
            Bits.copyBitsLeft(this.ba, entryPosLHC + NtNode.IK_WIDTH(dims), bia2, posOfData + postLenTotal * p2, postLenTotal);
            int kdPos1 = this.posToKdPosLHC(i, kdDims);
            int kdPos2 = this.posToKdPosAHC(p2, kdDims);
            RefsLong.writeArray(this.kdKeys, kdPos1, kdKeys2, kdPos2, kdDims);
            v2[p2] = this.values[i];
        }
        this.ba = Bits.arrayReplace(this.ba, bia2);
        this.kdKeys = RefsLong.arrayReplace(this.kdKeys, kdKeys2);
        this.values = Refs.arrayReplace(this.values, v2);
    }

    private Object switchAhcToLhcAndShrink(int oldEntryCount, int dims, int kdDims, long hcPosToRemove) {
        Object oldEntry = null;
        this.setAHC(false);
        long[] bia2 = Bits.arrayCreate(this.calcArraySizeTotalBits(oldEntryCount - 1, dims));
        long[] kdKeys2 = RefsLong.arrayCreate(this.calcArraySizeTotalLongs(oldEntryCount - 1, dims, kdDims));
        T[] v2 = Refs.arrayCreate(oldEntryCount - 1);
        int oldOffsIndex = this.getBitPosIndex();
        int oldOffsData = oldOffsIndex + (1 << dims) * 0;
        Bits.copyBitsLeft(this.ba, 0, bia2, 0, oldOffsIndex);
        int postLenTotal = dims * this.postLen;
        int n = 0;
        int i = 0;
        while ((long)i < 1L << dims) {
            if ((long)i == hcPosToRemove) {
                oldEntry = this.values[i];
            } else if (this.values[i] != null) {
                v2[n] = this.values[i];
                int entryPosLHC = oldOffsIndex + n * (NtNode.IK_WIDTH(dims) + postLenTotal);
                Bits.writeArray(bia2, entryPosLHC, NtNode.IK_WIDTH(dims), i);
                Bits.copyBitsLeft(this.ba, oldOffsData + postLenTotal * i, bia2, entryPosLHC + NtNode.IK_WIDTH(dims), postLenTotal);
                int kdPos1 = this.posToKdPosAHC(i, kdDims);
                int kdPos2 = this.posToKdPosLHC(n, kdDims);
                RefsLong.writeArray(this.kdKeys, kdPos1, kdKeys2, kdPos2, kdDims);
                ++n;
            }
            ++i;
        }
        this.ba = Bits.arrayReplace(this.ba, bia2);
        this.kdKeys = RefsLong.arrayReplace(this.kdKeys, kdKeys2);
        this.values = Refs.arrayReplace(this.values, v2);
        return oldEntry;
    }

    void addEntryPIN(long hcPos, int negPin, long key, long[] kdKey, Object value, int dims) {
        int bufEntryCnt = this.getEntryCount();
        int kdDims = kdKey.length;
        if (!this.isAHC() && this.shouldSwitchToAHC(bufEntryCnt + 1, dims, kdKey.length)) {
            this.switchLhcToAhcAndGrow(bufEntryCnt, dims, kdKey.length);
        }
        this.incEntryCount();
        int offsIndex = this.getBitPosIndex();
        if (this.isAHC()) {
            int offsPostKey = this.posToOffsBitsDataAHC(hcPos, offsIndex, dims);
            Bits.writeArray(this.ba, offsPostKey, this.postLen * dims, key);
            int kdPos = this.posToKdPosAHC(hcPos, kdDims);
            RefsLong.writeArray(kdKey, this.kdKeys, kdPos);
            this.values[(int)hcPos] = value;
        } else {
            int pin = -(negPin + 1);
            long[] ia = this.ba = Bits.arrayEnsureSize(this.ba, this.calcArraySizeTotalBits(bufEntryCnt + 1, dims));
            int offs = this.pinToOffsBitsLHC(pin, offsIndex, dims);
            Bits.insertBits(ia, offs, NtNode.IK_WIDTH(dims) + dims * this.postLen);
            Bits.writeArray(ia, offs, NtNode.IK_WIDTH(dims), hcPos);
            int kdPos = this.posToKdPosLHC(pin, kdDims);
            this.kdKeys = RefsLong.insertArray(this.kdKeys, kdKey, kdPos);
            Bits.writeArray(ia, offs += NtNode.IK_WIDTH(dims), this.postLen * dims, key);
            this.values = Refs.insertSpaceAtPos(this.values, pin, bufEntryCnt + 1);
            this.values[pin] = value;
        }
    }

    void getPostPIN(int posInNode, long hcPos, long[] key) {
        long[] ia = this.ba;
        int offs = this.pinToOffsBitsData(posInNode, hcPos, key.length);
        long mask = -1L << this.postLen;
        int i = 0;
        while (i < key.length) {
            int n = i;
            key[n] = key[n] & mask;
            int n2 = i++;
            key[n2] = key[n2] | Bits.readArray(ia, offs, this.postLen);
            offs += this.postLen;
        }
    }

    Object removeValue(long hcPos, int posInNode, int kdDims, int dims) {
        Object oldVal;
        int bufEntryCnt = this.getEntryCount();
        if (this.isAHC() && this.shouldSwitchToLHC(bufEntryCnt, dims, kdDims)) {
            Object oldVal2 = this.switchAhcToLhcAndShrink(bufEntryCnt, dims, kdDims, hcPos);
            this.decEntryCount();
            return oldVal2;
        }
        int offsIndex = this.getBitPosIndex();
        if (this.isAHC()) {
            oldVal = this.values[(int)hcPos];
            this.values[(int)hcPos] = null;
        } else {
            int posBit = this.pinToOffsBitsLHC(posInNode, offsIndex, dims);
            Bits.removeBits(this.ba, posBit, NtNode.IK_WIDTH(dims) + dims * this.postLen);
            this.ba = Bits.arrayTrim(this.ba, this.calcArraySizeTotalBits(bufEntryCnt - 1, dims));
            oldVal = this.values[posInNode];
            this.values = Refs.removeSpaceAtPos(this.values, posInNode, bufEntryCnt - 1);
            int kdPos = this.posToKdPosLHC(posInNode, kdDims);
            this.kdKeys = RefsLong.arrayRemove(this.kdKeys, kdPos, kdDims);
        }
        this.decEntryCount();
        return oldVal;
    }

    boolean isAHC() {
        return this.isAHC;
    }

    void setAHC(boolean b) {
        this.isAHC = b;
    }

    int getEntryCount() {
        return this.entryCnt;
    }

    private void decEntryCount() {
        this.entryCnt = (short)(this.entryCnt - 1);
    }

    private void incEntryCount() {
        this.entryCnt = (short)(this.entryCnt + 1);
    }

    int getBitPosIndex() {
        return this.getBitPosInfix();
    }

    int getBitPosInfix() {
        return 0;
    }

    private int posToOffsBitsDataAHC(long hcPos, int offsIndex, int dims) {
        return offsIndex + 0 * (1 << dims) + this.postLen * dims * (int)hcPos;
    }

    int pinToOffsBitsLHC(int pin, int offsIndex, int dims) {
        return offsIndex + (NtNode.IK_WIDTH(dims) + this.postLen * dims) * pin;
    }

    int pinToOffsBitsData(int pin, long hcPos, int dims) {
        int offsIndex = this.getBitPosIndex();
        if (this.isAHC()) {
            return this.posToOffsBitsDataAHC(hcPos, offsIndex, dims);
        }
        return this.pinToOffsBitsLHC(pin, offsIndex, dims) + NtNode.IK_WIDTH(dims);
    }

    private int posToKdPosAHC(long hcPos, int kdDims) {
        return (int)(hcPos * (long)kdDims);
    }

    private int posToKdPosLHC(int pin, int kdDims) {
        return pin * kdDims;
    }

    private int pinToKdPos(int pin, int kdDims) {
        return pin * kdDims;
    }

    int getPosition(long hcPos, int dims) {
        int offsInd = this.getBitPosIndex();
        if (this.isAHC()) {
            int posInt = (int)hcPos;
            return this.values[posInt] != null ? posInt : -posInt - 1;
        }
        return Bits.binarySearch(this.ba, offsInd, this.getEntryCount(), hcPos, NtNode.IK_WIDTH(dims), dims * this.postLen);
    }

    int findFirstEntry(int dims) {
        if (this.isAHC()) {
            int i = 0;
            while ((long)i < 1L << dims) {
                if (this.values[i] != null) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        return 0;
    }

    int getPostLen() {
        return this.postLen;
    }

    Object[] values() {
        return this.values;
    }

    long[] kdKeys() {
        return this.kdKeys;
    }
}

