/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v13;

import clib.phtree.PhTreeHelper;
import clib.phtree.v13.Bits;
import clib.phtree.v13.PhTree13;
import java.util.function.BiFunction;

public class Node {
    private static final int REF_BITS = 32;
    private static final int HC_BITS = 0;
    private static final int INN_HC_WIDTH = 0;
    public static final double AHC_LHC_BIAS = 2.0;
    private Object[] values;
    private int entryCnt = 0;
    private long[] ba = null;
    private boolean isHC = false;
    private byte postLenStored = 0;
    private byte infixLenStored = 0;
    private static int N_GOOD = 0;
    private static int N = 0;

    static final int IK_WIDTH(int dims) {
        return dims;
    }

    private Node() {
    }

    protected Node(Node original, PhTree13<?> tree) {
        if (original.values != null) {
            this.values = tree.objPool().arrayClone((Object[])original.values);
        }
        this.entryCnt = original.entryCnt;
        this.isHC = original.isHC;
        this.postLenStored = original.postLenStored;
        this.infixLenStored = original.infixLenStored;
        if (original.ba != null) {
            this.ba = tree.longPool().arrayClone(original.ba);
        }
    }

    static Node createEmpty() {
        return new Node();
    }

    private void initNode(int infixLenClassic, int postLenClassic, int dims, PhTree13<?> tree) {
        this.infixLenStored = (byte)(infixLenClassic + 1);
        this.postLenStored = (byte)(postLenClassic + 1);
        this.entryCnt = 0;
        this.isHC = false;
        int size = this.calcArraySizeTotalBits(2, dims);
        this.ba = tree.longPool().arrayCreate(size);
        this.values = tree.objPool().arrayCreate(2);
    }

    static Node createNode(int dims, int infixLenClassic, int postLenClassic, PhTree13<?> tree) {
        Node n = tree.nodePool().get();
        n.initNode(infixLenClassic, postLenClassic, dims, tree);
        return n;
    }

    private void discardNode(PhTree13<?> tree) {
        tree.longPool().arrayReplace(this.ba, null);
        tree.objPool().arrayReplace((Object[])this.values, null);
        this.entryCnt = 0;
        tree.nodePool().offer(this);
    }

    int calcArraySizeTotalBits(int entryCount, int dims) {
        int nBits = this.getBitPosIndex();
        nBits = this.isAHC() ? (nBits += (0 + dims * this.postLenStored()) * (1 << dims)) : (nBits += entryCount * (Node.IK_WIDTH(dims) + dims * this.postLenStored()));
        return nBits;
    }

    private boolean getInfixOfSub(int pin, long hcPos, long[] outVal) {
        int offs = this.pinToOffsBitsData(pin, hcPos, outVal.length);
        if (!this.hasSubInfix(offs, outVal.length)) {
            this.applyHcPos(hcPos, outVal);
            return false;
        }
        long mask = Node.mask1100(this.postLenStored());
        for (int i = 0; i < outVal.length; ++i) {
            outVal[i] = mask & outVal[i] | Bits.readArray(this.ba, offs, this.postLenStored());
            offs += this.postLenStored();
        }
        return true;
    }

    Object doInsertIfMatching(long[] keyToMatch, Object newValueToInsert, PhTree13<?> tree) {
        int offs;
        Object v;
        long hcPos = PhTreeHelper.posInArray(keyToMatch, this.getPostLen());
        int pin = this.getPosition(hcPos, keyToMatch.length);
        if (pin < 0) {
            tree.increaseNrEntries();
            this.addPostPIN(hcPos, pin, keyToMatch, newValueToInsert, tree);
            return null;
        }
        int dims = keyToMatch.length;
        if (this.isAHC()) {
            v = this.values[(int)hcPos];
            offs = this.posToOffsBitsDataAHC(hcPos, this.getBitPosIndex(), dims);
        } else {
            v = this.values[pin];
            offs = this.pinToOffsBitsDataLHC(pin, this.getBitPosIndex(), dims);
        }
        if (v instanceof Node) {
            Node sub = (Node)v;
            if (this.hasSubInfix(offs, dims)) {
                long mask = this.calcInfixMask(sub.getPostLen());
                return this.insertSplit(keyToMatch, newValueToInsert, v, pin, hcPos, tree, offs, mask);
            }
            return v;
        }
        if (this.getPostLen() > 0) {
            long mask = this.calcPostfixMask();
            return this.insertSplit(keyToMatch, newValueToInsert, v, pin, hcPos, tree, offs, mask);
        }
        this.values[pin] = newValueToInsert;
        return v;
    }

    Object doIfMatching(long[] keyToMatch, boolean getOnly, Node parent, long[] newKey, int[] insertRequired, PhTree13<?> tree) {
        int offs;
        int pin;
        Object v;
        long hcPos = PhTreeHelper.posInArray(keyToMatch, this.getPostLen());
        int dims = keyToMatch.length;
        if (this.isAHC()) {
            v = this.values[(int)hcPos];
            if (v == null) {
                return null;
            }
            pin = (int)hcPos;
            offs = this.posToOffsBitsDataAHC(hcPos, this.getBitPosIndex(), dims);
        } else {
            pin = this.getPosition(hcPos, keyToMatch.length);
            if (pin < 0) {
                return null;
            }
            v = this.values[pin];
            offs = this.pinToOffsBitsDataLHC(pin, this.getBitPosIndex(), dims);
        }
        if (v instanceof Node) {
            long mask;
            Node sub = (Node)v;
            if (this.hasSubInfix(offs, dims) && !this.readAndCheckKdKey(offs, keyToMatch, mask = this.calcInfixMask(sub.getPostLen()))) {
                return null;
            }
            return v;
        }
        long mask = this.calcPostfixMask();
        if (!this.readAndCheckKdKey(offs, keyToMatch, mask)) {
            return null;
        }
        if (getOnly) {
            return v;
        }
        return this.deleteAndMergeIntoParent(pin, hcPos, keyToMatch, parent, newKey, insertRequired, v, tree);
    }

    <T> Object doCompute(long[] keyToMatch, boolean doIfAbsent, Node parent, PhTree13<?> tree, BiFunction<long[], ? super T, ? extends T> remappingFunction) {
        int offs;
        Object v;
        long hcPos = PhTreeHelper.posInArray(keyToMatch, this.getPostLen());
        int pin = this.getPosition(hcPos, keyToMatch.length);
        if (pin < 0) {
            if (doIfAbsent) {
                T newValue = remappingFunction.apply(keyToMatch, null);
                if (newValue != null) {
                    tree.increaseNrEntries();
                    this.addPostPIN(hcPos, pin, keyToMatch, newValue, tree);
                }
                return newValue;
            }
            return null;
        }
        int dims = keyToMatch.length;
        if (this.isAHC()) {
            v = this.values[(int)hcPos];
            offs = this.posToOffsBitsDataAHC(hcPos, this.getBitPosIndex(), dims);
        } else {
            v = this.values[pin];
            offs = this.pinToOffsBitsDataLHC(pin, this.getBitPosIndex(), dims);
        }
        if (v instanceof Node) {
            Node sub = (Node)v;
            if (this.hasSubInfix(offs, dims)) {
                long mask = this.calcInfixMask(sub.getPostLen());
                return this.insertSplitCompute(keyToMatch, v, doIfAbsent, parent, pin, hcPos, tree, offs, mask, remappingFunction);
            }
            return v;
        }
        if (this.getPostLen() > 0) {
            long mask = this.calcPostfixMask();
            return this.insertSplitCompute(keyToMatch, v, doIfAbsent, parent, pin, hcPos, tree, offs, mask, remappingFunction);
        }
        T newValue = remappingFunction.apply(keyToMatch, (long[])PhTreeHelper.unmaskNull(v));
        if (newValue == null) {
            this.deleteAndMergeIntoParent(pin, hcPos, keyToMatch, parent, null, null, v, tree);
        } else {
            this.values[pin] = newValue;
        }
        return newValue;
    }

    private boolean readAndCheckKdKey(int offs, long[] keyToMatch, long mask) {
        for (int i = 0; i < keyToMatch.length; ++i) {
            long k = Bits.readArray(this.ba, offs, this.postLenStored());
            if (((k ^ keyToMatch[i]) & mask) != 0L) {
                return false;
            }
            offs += this.postLenStored();
        }
        return true;
    }

    private long calcPostfixMask() {
        return -1L << this.getPostLen() ^ 0xFFFFFFFFFFFFFFFFL;
    }

    private long calcInfixMask(int subPostLen) {
        long mask = -1L << this.getPostLen() - subPostLen - 1 ^ 0xFFFFFFFFFFFFFFFFL;
        return mask << subPostLen + 1;
    }

    private Object insertSplit(long[] newKey, Object newValue, Object currentValue, int pin, long hcPos, PhTree13<?> tree, int offs, long mask) {
        long[] buffer = tree.longPool().getArray(newKey.length);
        int maxConflictingBits = this.calcConflictingBits(newKey, offs, buffer, mask);
        if (maxConflictingBits == 0) {
            if (!(currentValue instanceof Node)) {
                this.values[pin] = newValue;
            }
            tree.longPool().offer(buffer);
            return currentValue;
        }
        Node newNode = this.createNode(newKey, newValue, buffer, currentValue, maxConflictingBits, tree);
        tree.longPool().offer(buffer);
        this.replaceEntryWithSub(pin, hcPos, newKey, newNode, tree);
        tree.increaseNrEntries();
        return null;
    }

    private <T> Object insertSplitCompute(long[] newKey, Object currentValue, boolean doIfAbsent, Node parent, int pin, long hcPos, PhTree13<?> tree, int offs, long mask, BiFunction<long[], ? super T, ? extends T> remappingFunction) {
        long[] buffer = tree.longPool().getArray(newKey.length);
        int maxConflictingBits = this.calcConflictingBits(newKey, offs, buffer, mask);
        if (maxConflictingBits == 0) {
            tree.longPool().offer(buffer);
            if (currentValue instanceof Node) {
                return currentValue;
            }
            T newValue = remappingFunction.apply(newKey, (long[])PhTreeHelper.unmaskNull(currentValue));
            if (newValue != null) {
                this.values[pin] = newValue;
                return newValue;
            }
            this.deleteAndMergeIntoParent(pin, hcPos, newKey, parent, null, null, null, tree);
            return null;
        }
        if (!doIfAbsent) {
            tree.longPool().offer(buffer);
            return null;
        }
        T newValue = remappingFunction.apply(newKey, null);
        if (newValue == null) {
            tree.longPool().offer(buffer);
            return null;
        }
        Node newNode = this.createNode(newKey, newValue, buffer, currentValue, maxConflictingBits, tree);
        tree.longPool().offer(buffer);
        this.replaceEntryWithSub(pin, hcPos, newKey, newNode, tree);
        tree.increaseNrEntries();
        return newValue;
    }

    public Node createNode(long[] key1, Object val1, long[] key2, Object val2, int mcb, PhTree13<?> tree) {
        long posSub2;
        int newLocalInfLen = this.getPostLen() - mcb;
        int newPostLen = mcb - 1;
        Node newNode = Node.createNode(key1.length, newLocalInfLen, newPostLen, tree);
        long posSub1 = PhTreeHelper.posInArray(key1, newPostLen);
        if (posSub1 < (posSub2 = PhTreeHelper.posInArray(key2, newPostLen))) {
            newNode.writeEntry(0, posSub1, key1, val1, tree);
            newNode.writeEntry(1, posSub2, key2, val2, tree);
        } else {
            newNode.writeEntry(0, posSub2, key2, val2, tree);
            newNode.writeEntry(1, posSub1, key1, val1, tree);
        }
        newNode.incEntryCount();
        newNode.incEntryCount();
        return newNode;
    }

    private static int calcConflictingBits(long[] v1, long[] v2, long mask) {
        long diff = 0L;
        for (int i = 0; i < v1.length; ++i) {
            diff |= v1[i] ^ v2[i];
        }
        return 64 - Long.numberOfLeadingZeros(diff & mask);
    }

    private int calcConflictingBits(long[] v1, int bitOffs, long[] outV, long mask) {
        long diff = 0L;
        long[] ia = this.ba;
        int offs = bitOffs;
        for (int i = 0; i < v1.length; ++i) {
            long k = Bits.readArray(ia, offs, this.postLenStored());
            diff |= v1[i] ^ k;
            outV[i] = k;
            offs += this.postLenStored();
        }
        return 64 - Long.numberOfLeadingZeros(diff & mask);
    }

    private Object deleteAndMergeIntoParent(int pinToDelete, long hcPos, long[] key, Node parent, long[] newKey, int[] insertRequired, Object valueToDelete, PhTree13<?> tree) {
        int dims = key.length;
        if (newKey != null) {
            int bitPosOfDiff = Node.calcConflictingBits(key, newKey, -1L);
            if (bitPosOfDiff <= this.getPostLen()) {
                return this.replacePost(pinToDelete, hcPos, newKey);
            }
            insertRequired[0] = bitPosOfDiff;
        }
        tree.decreaseNrEntries();
        if (parent == null || this.getEntryCount() > 2) {
            return this.removeEntry(hcPos, pinToDelete, dims, tree);
        }
        int pin2 = -1;
        long pos2 = -1L;
        Object val2 = null;
        if (this.isAHC()) {
            for (int i = 0; i < 1 << key.length; ++i) {
                if (this.values[i] == null || i == pinToDelete) continue;
                pin2 = i;
                pos2 = i;
                val2 = this.values[i];
                break;
            }
        } else {
            pin2 = pinToDelete == 0 ? 1 : 0;
            int offs = this.pinToOffsBitsLHC(pin2, this.getBitPosIndex(), dims);
            pos2 = Bits.readArray(this.ba, offs, Node.IK_WIDTH(dims));
            val2 = this.values[pin2];
        }
        long[] newPost = new long[dims];
        Bits.arraycopy(key, 0, newPost, 0, key.length);
        long posInParent = PhTreeHelper.posInArray(key, parent.getPostLen());
        int pinInParent = parent.getPosition(posInParent, dims);
        if (val2 instanceof Node) {
            this.getInfixOfSub(pin2, pos2, newPost);
            Node sub2 = (Node)val2;
            int newInfixLen = this.getInfixLen() + 1 + sub2.getInfixLen();
            sub2.setInfixLen(newInfixLen);
            parent.replaceEntryWithSub(pinInParent, posInParent, newPost, sub2, tree);
        } else {
            this.getEntryByPIN(pin2, pos2, newPost);
            parent.replaceSubWithPost(pinInParent, posInParent, newPost, val2, tree);
        }
        this.discardNode(tree);
        return valueToDelete;
    }

    private Object getEntryByPIN(int posInNode, long hcPos, long[] postBuf) {
        Object o = this.values[posInNode];
        if (o instanceof Node) {
            this.getInfixOfSub(posInNode, hcPos, postBuf);
        } else {
            int offsetBit = this.pinToOffsBitsData(posInNode, hcPos, postBuf.length);
            long mask = Node.mask1100(this.postLenStored());
            int i = 0;
            while (i < postBuf.length) {
                int n = i;
                postBuf[n] = postBuf[n] & mask;
                int n2 = i++;
                postBuf[n2] = postBuf[n2] | Bits.readArray(this.ba, offsetBit, this.postLenStored());
                offsetBit += this.postLenStored();
            }
        }
        return o;
    }

    Object getEntry(long hcPos, long[] postBuf) {
        int posInNode = this.getPosition(hcPos, postBuf.length);
        if (posInNode < 0) {
            return null;
        }
        return this.getEntryByPIN(posInNode, hcPos, postBuf);
    }

    Object getEntryPIN(int posInNode, long hcPos, long[] subNodePrefix, long[] outKey) {
        Object o = this.values[posInNode];
        if (o == null) {
            return null;
        }
        if (o instanceof Node) {
            this.getInfixOfSub(posInNode, hcPos, subNodePrefix);
        } else {
            int offsetBit = this.pinToOffsBitsData(posInNode, hcPos, subNodePrefix.length);
            long mask = Node.mask1100(this.postLenStored());
            for (int i = 0; i < subNodePrefix.length; ++i) {
                outKey[i] = subNodePrefix[i] & mask | Bits.readArray(this.ba, offsetBit, this.postLenStored());
                offsetBit += this.postLenStored();
            }
        }
        return o;
    }

    private boolean shouldSwitchToAHC(int entryCount, int dims) {
        return this.useAHC(entryCount, dims);
    }

    private boolean shouldSwitchToLHC(int entryCount, int dims) {
        return !this.useAHC(entryCount + 2, dims);
    }

    private boolean useAHC(int entryCount, int dims) {
        long sizeAHC = (long)(dims * this.postLenStored() + 0 + 32) * (1L << dims);
        long sizeLHC = (long)(dims * this.postLenStored() + Node.IK_WIDTH(dims) + 32) * (long)entryCount;
        return dims <= 31 && (double)sizeLHC * 2.0 >= (double)sizeAHC;
    }

    private void writeEntry(int pin, long hcPos, long[] newKey, Object value, PhTree13<?> tree) {
        int offsKey;
        int dims = newKey.length;
        int offsIndex = this.getBitPosIndex();
        if (this.isAHC()) {
            this.values[(int)hcPos] = value;
            offsKey = this.posToOffsBitsDataAHC(hcPos, offsIndex, dims);
        } else {
            this.values[pin] = value;
            offsKey = this.pinToOffsBitsLHC(pin, offsIndex, dims);
            Bits.writeArray(this.ba, offsKey, Node.IK_WIDTH(dims), hcPos);
            offsKey += Node.IK_WIDTH(dims);
        }
        if (value instanceof Node) {
            Node node = (Node)value;
            int newSubInfixLen = this.postLenStored() - node.postLenStored() - 1;
            node.setInfixLen(newSubInfixLen);
            this.writeSubInfix(pin, hcPos, newKey, node.requiresInfix());
        } else if (this.postLenStored() > 0) {
            for (int i = 0; i < newKey.length; ++i) {
                Bits.writeArray(this.ba, offsKey, this.postLenStored(), newKey[i]);
                offsKey += this.postLenStored();
            }
        }
    }

    private Object replacePost(int pin, long hcPos, long[] newKey) {
        int offs = this.pinToOffsBitsData(pin, hcPos, newKey.length);
        for (int i = 0; i < newKey.length; ++i) {
            Bits.writeArray(this.ba, offs, this.postLenStored(), newKey[i]);
            offs += this.postLenStored();
        }
        return this.values[pin];
    }

    private void replaceEntryWithSub(int posInNode, long hcPos, long[] infix, Node newSub, PhTree13<?> tree) {
        this.writeSubInfix(posInNode, hcPos, infix, newSub.requiresInfix());
        this.values[posInNode] = newSub;
    }

    private void writeSubInfix(int pin, long hcPos, long[] infix, boolean subRequiresInfix) {
        this.replacePost(pin, hcPos, infix);
        int dims = infix.length;
        int subInfoOffs = this.pinToOffsBitsData(pin, hcPos, dims) + dims * this.postLenStored() - 1;
        this.writeSubInfixInfo(this.ba, subInfoOffs, subRequiresInfix);
    }

    private void writeSubInfixInfo(long[] ba, int subInfoOffs, boolean subRequiresInfix) {
        Bits.setBit(ba, subInfoOffs, subRequiresInfix);
    }

    private boolean hasSubInfix(int subInfoOffs, int dims) {
        return Bits.getBit(this.ba, subInfoOffs + dims * this.postLenStored() - 1);
    }

    private void replaceSubWithPost(int pin, long hcPos, long[] key, Object value, PhTree13<?> tree) {
        this.values[pin] = value;
        this.replacePost(pin, hcPos, key);
    }

    private void switchLhcToAhcAndGrow(int oldEntryCount, int dims, PhTree13<?> tree) {
        int posOfIndex = this.getBitPosIndex();
        int posOfData = this.posToOffsBitsDataAHC(0L, posOfIndex, dims);
        this.setAHC(true);
        long[] bia2 = tree.longPool().arrayCreate(this.calcArraySizeTotalBits(oldEntryCount + 1, dims));
        Object[] v2 = tree.objPool().arrayCreate(1 << dims);
        Bits.copyBitsLeft(this.ba, 0, bia2, 0, posOfIndex);
        int postLenTotal = dims * this.postLenStored();
        for (int i = 0; i < oldEntryCount; ++i) {
            int entryPosLHC = posOfIndex + i * (Node.IK_WIDTH(dims) + postLenTotal);
            int p2 = (int)Bits.readArray(this.ba, entryPosLHC, Node.IK_WIDTH(dims));
            Bits.copyBitsLeft(this.ba, entryPosLHC + Node.IK_WIDTH(dims), bia2, posOfData + postLenTotal * p2, postLenTotal);
            v2[p2] = this.values[i];
        }
        this.ba = tree.longPool().arrayReplace(this.ba, bia2);
        this.values = tree.objPool().arrayReplace((Object[])this.values, (Object[])v2);
    }

    private Object switchAhcToLhcAndShrink(int oldEntryCount, int dims, long hcPosToRemove, PhTree13<?> tree) {
        Object oldEntry = null;
        this.setAHC(false);
        long[] bia2 = tree.longPool().arrayCreate(this.calcArraySizeTotalBits(oldEntryCount - 1, dims));
        Object[] v2 = tree.objPool().arrayCreate(oldEntryCount - 1);
        int oldOffsIndex = this.getBitPosIndex();
        int oldOffsData = oldOffsIndex + (1 << dims) * 0;
        Bits.copyBitsLeft(this.ba, 0, bia2, 0, oldOffsIndex);
        int postLenTotal = dims * this.postLenStored();
        int n = 0;
        int i = 0;
        while ((long)i < 1L << dims) {
            if ((long)i == hcPosToRemove) {
                oldEntry = this.values[i];
            } else if (this.values[i] != null) {
                v2[n] = this.values[i];
                int entryPosLHC = oldOffsIndex + n * (Node.IK_WIDTH(dims) + postLenTotal);
                Bits.writeArray(bia2, entryPosLHC, Node.IK_WIDTH(dims), i);
                Bits.copyBitsLeft(this.ba, oldOffsData + postLenTotal * i, bia2, entryPosLHC + Node.IK_WIDTH(dims), postLenTotal);
                ++n;
            }
            ++i;
        }
        this.ba = tree.longPool().arrayReplace(this.ba, bia2);
        this.values = tree.objPool().arrayReplace((Object[])this.values, (Object[])v2);
        return oldEntry;
    }

    void addPostPIN(long hcPos, int pin, long[] key, Object value, PhTree13<?> tree) {
        int dims = key.length;
        int bufEntryCnt = this.getEntryCount();
        if (!this.isAHC() && this.shouldSwitchToAHC(bufEntryCnt + 1, dims)) {
            this.switchLhcToAhcAndGrow(bufEntryCnt, dims, tree);
        }
        this.incEntryCount();
        int offsIndex = this.getBitPosIndex();
        if (this.isAHC()) {
            int offsPostKey = this.posToOffsBitsDataAHC(hcPos, offsIndex, dims);
            for (int i = 0; i < key.length; ++i) {
                Bits.writeArray(this.ba, offsPostKey + this.postLenStored() * i, this.postLenStored(), key[i]);
            }
            this.values[(int)hcPos] = value;
        } else {
            pin = -(pin + 1);
            long[] ia = this.ba = tree.longPool().arrayEnsureSize(this.ba, this.calcArraySizeTotalBits(bufEntryCnt + 1, dims));
            int offs = this.pinToOffsBitsLHC(pin, offsIndex, dims);
            Bits.insertBits(ia, offs, Node.IK_WIDTH(dims) + dims * this.postLenStored);
            Bits.writeArray(ia, offs, Node.IK_WIDTH(dims), hcPos);
            offs += Node.IK_WIDTH(dims);
            for (int i = 0; i < key.length; ++i) {
                Bits.writeArray(ia, offs, this.postLenStored(), key[i]);
                offs += this.postLenStored();
            }
            this.values = tree.objPool().insertSpaceAtPos((Object[])this.values, pin, bufEntryCnt + 1);
            this.values[pin] = value;
        }
    }

    Object checkAndGetEntryPIN(int pin, long hcPos, long[] inOutPrefix, long[] outKey, long[] rangeMin, long[] rangeMax) {
        Object o = this.values[pin];
        if (o == null) {
            return null;
        }
        if (o instanceof Node) {
            return this.checkAndApplyInfix(((Node)o).getInfixLen(), pin, hcPos, inOutPrefix, rangeMin, rangeMax) ? o : null;
        }
        if (this.checkAndGetPost(pin, hcPos, inOutPrefix, outKey, rangeMin, rangeMax)) {
            return o;
        }
        return null;
    }

    private boolean checkAndApplyInfix(int infixLen, int pin, long hcPos, long[] valTemplate, long[] rangeMin, long[] rangeMax) {
        int dims = valTemplate.length;
        int subOffs = this.pinToOffsBitsData(pin, hcPos, dims);
        if (!this.hasSubInfix(subOffs, dims)) {
            this.applyHcPos(hcPos, valTemplate);
            return true;
        }
        long maskClean = Node.mask1100(this.postLenStored());
        long compMask = Node.mask1100(this.postLenStored() - infixLen);
        for (int dim = 0; dim < valTemplate.length; ++dim) {
            long inFull = valTemplate[dim] & maskClean | Bits.readArray(this.ba, subOffs, this.postLenStored());
            long in = inFull & compMask;
            if (in > rangeMax[dim] || (in | compMask ^ 0xFFFFFFFFFFFFFFFFL) < rangeMin[dim]) {
                return false;
            }
            valTemplate[dim] = inFull;
            subOffs += this.postLenStored();
        }
        return true;
    }

    private static long mask1100(int zeroBits) {
        return zeroBits == 64 ? 0L : -1L << zeroBits;
    }

    private void applyHcPos(long hcPos, long[] valTemplate) {
        PhTreeHelper.applyHcPos(hcPos, this.getPostLen(), valTemplate);
    }

    private boolean checkAndGetPost(int pin, long hcPos, long[] inPrefix, long[] outKey, long[] rangeMin, long[] rangeMax) {
        long[] ia = this.ba;
        int offs = this.pinToOffsBitsData(pin, hcPos, rangeMin.length);
        long mask = Node.mask1100(this.postLenStored());
        for (int i = 0; i < outKey.length; ++i) {
            long k = inPrefix[i] & mask | Bits.readArray(ia, offs, this.postLenStored());
            if (k < rangeMin[i] || k > rangeMax[i]) {
                return false;
            }
            outKey[i] = k;
            offs += this.postLenStored();
        }
        return true;
    }

    private Object removeEntry(long hcPos, int posInNode, int dims, PhTree13<?> tree) {
        Object oldVal;
        int bufEntryCnt = this.getEntryCount();
        if (this.isAHC() && this.shouldSwitchToLHC(bufEntryCnt, dims)) {
            Object oldVal2 = this.switchAhcToLhcAndShrink(bufEntryCnt, dims, hcPos, tree);
            this.decEntryCount();
            return oldVal2;
        }
        int offsIndex = this.getBitPosIndex();
        if (this.isAHC()) {
            oldVal = this.values[(int)hcPos];
            this.values[(int)hcPos] = null;
        } else {
            int posBit = this.pinToOffsBitsLHC(posInNode, offsIndex, dims);
            Bits.removeBits(this.ba, posBit, Node.IK_WIDTH(dims) + dims * this.postLenStored());
            this.ba = tree.longPool().arrayTrim(this.ba, this.calcArraySizeTotalBits(bufEntryCnt - 1, dims));
            oldVal = this.values[posInNode];
            this.values = tree.objPool().removeSpaceAtPos((Object[])this.values, posInNode, bufEntryCnt - 1);
        }
        this.decEntryCount();
        return oldVal;
    }

    boolean isAHC() {
        return this.isHC;
    }

    void setAHC(boolean b) {
        this.isHC = b;
    }

    public int getEntryCount() {
        return this.entryCnt;
    }

    public void decEntryCount() {
        --this.entryCnt;
    }

    public void incEntryCount() {
        ++this.entryCnt;
    }

    int getBitPosIndex() {
        return this.getBitPosInfix();
    }

    private int getBitPosInfix() {
        return 0;
    }

    private int posToOffsBitsDataAHC(long hcPos, int offsIndex, int dims) {
        return offsIndex + 0 * (1 << dims) + this.postLenStored() * dims * (int)hcPos;
    }

    private int pinToOffsBitsDataLHC(int pin, int offsIndex, int dims) {
        return offsIndex + (Node.IK_WIDTH(dims) + this.postLenStored() * dims) * pin + Node.IK_WIDTH(dims);
    }

    int pinToOffsBitsLHC(int pin, int offsIndex, int dims) {
        return offsIndex + (Node.IK_WIDTH(dims) + this.postLenStored() * dims) * pin;
    }

    private int pinToOffsBitsData(int pin, long hcPos, int dims) {
        int offsIndex = this.getBitPosIndex();
        if (this.isAHC()) {
            return this.posToOffsBitsDataAHC(hcPos, offsIndex, dims);
        }
        return this.pinToOffsBitsLHC(pin, offsIndex, dims) + Node.IK_WIDTH(dims);
    }

    int getPosition(long hcPos, int dims) {
        if (this.isAHC()) {
            int posInt = (int)hcPos;
            return this.values[posInt] != null ? posInt : -posInt - 1;
        }
        int offsInd = this.getBitPosIndex();
        return Bits.binarySearch(this.ba, offsInd, this.getEntryCount(), hcPos, Node.IK_WIDTH(dims), dims * this.postLenStored());
    }

    int getInfixLen() {
        return this.infixLenStored() - 1;
    }

    private boolean requiresInfix() {
        return this.getInfixLen() > 0;
    }

    private int infixLenStored() {
        return this.infixLenStored;
    }

    void setInfixLen(int newInfLen) {
        this.infixLenStored = (byte)(newInfLen + 1);
    }

    public int getPostLen() {
        return this.postLenStored - 1;
    }

    public int postLenStored() {
        return this.postLenStored;
    }

    Object[] values() {
        return this.values;
    }

    long[] ba() {
        return this.ba;
    }
}

