/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v13;

import clib.phtree.PhEntry;
import clib.phtree.v13.Bits;
import clib.phtree.v13.Node;
import clib.phtree.v13.PhResultList;
import clib.phtree.v13.PhTree13;
import java.util.List;

public class NodeIteratorListReuse<T, R> {
    private final int dims;
    private final PhResultList<T, R> results;
    private int maxResults;
    private final long[] valTemplate;
    private long[] rangeMin;
    private long[] rangeMax;
    private final PhIteratorStack pool;

    NodeIteratorListReuse(int dims, PhResultList<T, R> results) {
        this.dims = dims;
        this.valTemplate = new long[dims];
        this.results = results;
        this.pool = new PhIteratorStack();
    }

    List<R> resetAndRun(Node node, long[] rangeMin, long[] rangeMax, int maxResults) {
        this.results.clear();
        this.rangeMin = rangeMin;
        this.rangeMax = rangeMax;
        this.maxResults = maxResults;
        this.run(node);
        return this.results;
    }

    private void run(Node node) {
        int i;
        long maskHcBit = 1L << node.getPostLen();
        long maskVT = -1L << node.getPostLen();
        long lowerLimit = 0L;
        long upperLimit = 0L;
        if (maskHcBit >= 0L) {
            for (i = 0; i < this.valTemplate.length; ++i) {
                lowerLimit <<= 1;
                upperLimit <<= 1;
                long nodeBisection = (this.valTemplate[i] | maskHcBit) & maskVT;
                if (this.rangeMin[i] >= nodeBisection) {
                    lowerLimit |= 1L;
                }
                if (this.rangeMax[i] < nodeBisection) continue;
                upperLimit |= 1L;
            }
        } else {
            for (i = 0; i < this.valTemplate.length; ++i) {
                lowerLimit <<= 1;
                upperLimit <<= 1;
                if (this.rangeMin[i] < 0L) {
                    upperLimit |= 1L;
                }
                if (this.rangeMax[i] >= 0L) continue;
                lowerLimit |= 1L;
            }
        }
        NodeIterator nIt = this.pool.prepare();
        nIt.reinitAndRun(node, lowerLimit, upperLimit);
        this.pool.pop();
    }

    private final class NodeIterator {
        private Node node;
        private int nMaxEntry;
        private int nEntryFound = 0;
        private long maskLower;
        private long maskUpper;
        private boolean useHcIncrementer;

        private NodeIterator() {
        }

        void reinitAndRun(Node node, long lower, long upper) {
            this.node = node;
            this.nMaxEntry = node.getEntryCount();
            this.nEntryFound = 0;
            this.maskLower = lower;
            this.maskUpper = upper;
            this.useHcIncrementer = false;
            if (NodeIteratorListReuse.this.dims > 6) {
                this.initHCI();
            }
            this.getAll();
        }

        private void initHCI() {
            int logNPost;
            long maxHcAddr = -1L << NodeIteratorListReuse.this.dims ^ 0xFFFFFFFFFFFFFFFFL;
            int nSetFilterBits = Long.bitCount(this.maskLower | (this.maskUpper ^ 0xFFFFFFFFFFFFFFFFL) & maxHcAddr);
            long nPossibleMatch = 1L << NodeIteratorListReuse.this.dims - nSetFilterBits;
            this.useHcIncrementer = this.node.isAHC() ? nPossibleMatch < maxHcAddr : (double)this.nMaxEntry > (double)nPossibleMatch * (double)(logNPost = 64 - Long.numberOfLeadingZeros(this.nMaxEntry) + 1);
        }

        private void checkAndAddResult(PhEntry<T> e) {
            NodeIteratorListReuse.this.results.phOffer(e);
        }

        private void checkAndRunSubnode(Node sub, PhEntry<T> e) {
            if (e != null) {
                NodeIteratorListReuse.this.results.phReturnTemp(e);
            }
            if (NodeIteratorListReuse.this.results.phIsPrefixValid(NodeIteratorListReuse.this.valTemplate, sub.getPostLen() + 1)) {
                NodeIteratorListReuse.this.run(sub);
            }
        }

        private void readValue(int pin, long pos) {
            PhEntry<Object> resultBuffer = NodeIteratorListReuse.this.results.phGetTempEntry();
            long[] key = resultBuffer.getKey();
            Object o = this.node.checkAndGetEntryPIN(pin, pos, NodeIteratorListReuse.this.valTemplate, key, NodeIteratorListReuse.this.rangeMin, NodeIteratorListReuse.this.rangeMax);
            if (o == null) {
                NodeIteratorListReuse.this.results.phReturnTemp(resultBuffer);
                return;
            }
            if (o instanceof Node) {
                this.checkAndRunSubnode((Node)o, resultBuffer);
                return;
            }
            resultBuffer.setValue(o);
            this.checkAndAddResult(resultBuffer);
        }

        private void getAllHCI() {
            long currentPos = this.maskLower;
            do {
                int pin;
                if ((pin = this.node.getPosition(currentPos, NodeIteratorListReuse.this.dims)) < 0) continue;
                this.readValue(pin, currentPos);
            } while ((currentPos = PhTree13.inc(currentPos, this.maskLower, this.maskUpper)) > this.maskLower && NodeIteratorListReuse.this.results.size() < NodeIteratorListReuse.this.maxResults);
        }

        private void getAll() {
            if (this.useHcIncrementer) {
                this.getAllHCI();
            } else if (this.node.isAHC()) {
                this.getAllAHC();
            } else {
                this.getAllLHC();
            }
        }

        private void getAllAHC() {
            long currentPos = this.maskLower;
            while (NodeIteratorListReuse.this.results.size() < NodeIteratorListReuse.this.maxResults) {
                if (this.checkHcPos(currentPos)) {
                    this.readValue((int)currentPos, currentPos);
                }
                if (++currentPos <= this.maskUpper) continue;
                break;
            }
        }

        private void getAllLHC() {
            int currentOffsetKey = this.node.getBitPosIndex();
            int postEntryLenLHC = Node.IK_WIDTH(NodeIteratorListReuse.this.dims) + NodeIteratorListReuse.this.dims * this.node.postLenStored();
            while (NodeIteratorListReuse.this.results.size() < NodeIteratorListReuse.this.maxResults && ++this.nEntryFound <= this.nMaxEntry) {
                long currentPos = Bits.readArray(this.node.ba(), currentOffsetKey, Node.IK_WIDTH(NodeIteratorListReuse.this.dims));
                currentOffsetKey += postEntryLenLHC;
                if (!this.checkHcPos(currentPos)) {
                    if (currentPos <= this.maskUpper) continue;
                    break;
                }
                this.readValue(this.nEntryFound - 1, currentPos);
            }
        }

        private boolean checkHcPos(long pos) {
            return ((pos | this.maskLower) & this.maskUpper) == pos;
        }
    }

    private class PhIteratorStack {
        private final NodeIterator[] stack = new NodeIterator[64];
        private int size = 0;

        private PhIteratorStack() {
        }

        NodeIterator prepare() {
            NodeIterator ni;
            if ((ni = this.stack[this.size++]) == null) {
                this.stack[this.size - 1] = ni = new NodeIterator();
            }
            return ni;
        }

        NodeIterator pop() {
            return this.stack[--this.size];
        }
    }
}

